/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.client;

import com.flansmod.physics.client.DebugRenderer;
import com.flansmod.physics.common.collision.DynamicCollisionEvent;
import com.flansmod.physics.common.collision.StaticCollisionEvent;
import com.flansmod.physics.common.collision.TransformedBB;
import com.flansmod.physics.common.collision.TransformedBBCollection;
import com.flansmod.physics.common.collision.obb.DynamicObject;
import com.flansmod.physics.common.collision.obb.OBBCollisionSystem;
import com.flansmod.physics.common.entity.PhysicsEntity;
import com.flansmod.physics.common.units.AngularAcceleration;
import com.flansmod.physics.common.units.IAcceleration;
import com.flansmod.physics.common.units.LinearAcceleration;
import com.flansmod.physics.common.util.Transform;
import com.flansmod.physics.common.util.shapes.IPolygon;
import com.flansmod.physics.common.util.shapes.ISeparationAxis;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class PhysicsDebugRenderer {
    private static final DebugPalette CLIENT_PALETTE = new DebugPalette(0.0f, 1.0f);
    private static final DebugPalette SERVER_PALETTE = new DebugPalette(1.0f, 0.0f);

    public PhysicsDebugRenderer() {
        MinecraftForge.EVENT_BUS.addListener(this::ClientTick);
    }

    public void ClientTick(@Nonnull TickEvent.ClientTickEvent event) {
        ClientLevel clientLevel;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (Minecraft.m_91087_().m_91290_().m_114377_() && (clientLevel = Minecraft.m_91087_().f_91073_) != null) {
            OBBCollisionSystem clientPhysics = OBBCollisionSystem.ForLevel((Level)clientLevel);
            clientPhysics.tryForEachDynamic(dynamic -> this.DebugRender((DynamicObject)dynamic, CLIENT_PALETTE));
            this.DebugRenderSeparations(clientPhysics, CLIENT_PALETTE);
            this.DebugRender(clientLevel.m_104735_(), CLIENT_PALETTE);
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server != null) {
                for (ServerLevel loadedLevel : server.m_129785_()) {
                    if (loadedLevel.m_46472_() == clientLevel.m_46472_()) {
                        this.DebugRender(loadedLevel.m_8583_(), SERVER_PALETTE);
                    }
                    OBBCollisionSystem serverPhysics = OBBCollisionSystem.ForLevel((Level)loadedLevel);
                    serverPhysics.tryForEachDynamic(dynamic -> this.DebugRender((DynamicObject)dynamic, SERVER_PALETTE));
                    this.DebugRenderSeparations(serverPhysics, SERVER_PALETTE);
                }
            }
        }
    }

    private void DebugRenderSeparations(@Nonnull OBBCollisionSystem physics, @Nonnull DebugPalette palette) {
    }

    private void DebugRender(@Nonnull Vec3 position, @Nonnull ISeparationAxis axis, @Nonnull DebugPalette palette) {
        Vec3 normal = axis.getNormal();
        Vec3 up = new Vec3(normal.f_82481_, -normal.f_82479_, -normal.f_82480_);
        Transform frame = Transform.fromPositionAndLookDirection(position, axis.getNormal(), up);
        DebugRenderer.renderArrow(frame, 2, palette.CollisionStatic, new Vec3(0.0, 0.0, -1.0));
        DebugRenderer.renderCube(frame, 2, palette.CollisionStatic, new Vector3f(0.25f, 0.25f, 0.0f));
    }

    private void DebugRender(@Nonnull DynamicObject dynamic, @Nonnull DebugPalette palette) {
        Vec3 up;
        Vec3 normal;
        this.DebugRender(dynamic.getCurrentColliders(), palette, false);
        this.DebugRender(dynamic.getPendingColliders(), palette, true);
        for (StaticCollisionEvent staticCollisionEvent : dynamic.StaticCollisions) {
            Transform collisionFrame;
            normal = staticCollisionEvent.separationPlane().getNormal();
            up = new Vec3(normal.f_82481_, -normal.f_82479_, -normal.f_82480_);
            IPolygon collisionSurface = staticCollisionEvent.contactSurface();
            Vec3 avgPos = Vec3.f_82478_;
            int numVerts = collisionSurface.GetNumVertices();
            for (int i = 0; i < numVerts; ++i) {
                Vec3 vCurrent = collisionSurface.getVertexLooped(i);
                Vec3 vNext = collisionSurface.getVertexLooped(i + 1);
                DebugRenderer.renderPoint(Transform.fromPos(vCurrent), 2, palette.CollisionStatic);
                DebugRenderer.renderLine(Transform.fromPos(vCurrent), 2, palette.CollisionStatic, vNext.m_82546_(vCurrent));
                avgPos = avgPos.m_82549_(vCurrent);
            }
            if (numVerts > 0) {
                collisionFrame = Transform.fromPositionAndLookDirection(avgPos.m_82490_(1.0 / (double)numVerts), normal, up);
                DebugRenderer.renderArrow(collisionFrame, 2, palette.CollisionStatic, new Vec3(0.0, 0.0, -1.0));
                continue;
            }
            collisionFrame = Transform.fromPositionAndLookDirection(dynamic.getCurrentWorldBounds().m_82399_(), normal, up);
            DebugRenderer.renderArrow(collisionFrame, 2, palette.CollisionStatic.mul(1.0f, 0.5f, 0.5f, 1.0f, new Vector4f()), new Vec3(0.0, 0.0, -1.0));
        }
        for (DynamicCollisionEvent dynamicCollisionEvent : dynamic.DynamicCollisions) {
            normal = dynamicCollisionEvent.ContactNormal();
            up = new Vec3(normal.f_82481_, -normal.f_82479_, -normal.f_82480_);
            Transform collisionFrame = Transform.fromPositionAndLookDirection(dynamicCollisionEvent.ContactPoint(), normal, up);
            DebugRenderer.renderCube(collisionFrame, 2, palette.CollisionDynamic, new Vector3f(0.25f, 0.25f, 0.0f));
            DebugRenderer.renderArrow(collisionFrame, 2, palette.CollisionDynamic, new Vec3(0.0, 0.0, -1.0));
        }
    }

    private void DebugRender(@Nonnull TransformedBBCollection bbs, @Nonnull DebugPalette palette, boolean predicted) {
        for (int i = 0; i < bbs.getCount(); ++i) {
            TransformedBB bb = bbs.getColliderBB(i);
            DebugRenderer.renderCube(bb.Loc(), 3, predicted ? palette.PositionCurrent : palette.PositionPrevious, bb.HalfExtents());
        }
    }

    private void DebugRender(@Nonnull Iterable<Entity> entityList, @Nonnull DebugPalette palette) {
        for (Entity entity : entityList) {
            if (!(entity instanceof PhysicsEntity)) continue;
            PhysicsEntity vehicle = (PhysicsEntity)entity;
            vehicle.forEachPhysicsComponent(component -> {
                Transform componentPos = component.getCurrentTransform();
                Vec3 coreMotionNextFrame = this.DebugRenderForces(component.getCurrentForces(), vehicle.m_20184_(), componentPos, palette, (float)component.mass);
                DebugRenderer.renderRotation(componentPos, 1, palette.MotionCurrent, component.getCurrentAngularVelocity().Axis(), component.getCurrentAngularVelocity().Magnitude());
                this.DebugRenderForces(component.getCurrentReactionForces(), vehicle.m_20184_(), componentPos, palette, (float)component.mass);
                Transform componentPosNext = Transform.compose(componentPos, Transform.fromPos(coreMotionNextFrame.m_82490_((double)0.05f)));
            });
        }
    }

    private Vec3 DebugRenderForces(@Nullable List<IAcceleration> forces, @Nonnull Vec3 motion, @Nonnull Transform worldTransform, @Nonnull DebugPalette palette, float mass) {
        float inertia = 1.0f / mass;
        float motionArrowScale = 1.0f;
        if (forces != null) {
            Vec3 forceTotal = new Vec3(0.0, 0.0, 0.0);
            for (IAcceleration force : forces) {
                this.DebugRenderForce(worldTransform, force, palette.ForceInputs);
            }
            Vec3 motionNext = motion.m_82549_(forceTotal.m_82490_((double)inertia));
            DebugRenderer.renderArrow(worldTransform, 1, palette.MotionCurrent, motion.m_82490_((double)motionArrowScale));
            DebugRenderer.renderArrow(worldTransform.translated(motion.m_82490_((double)motionArrowScale)), 1, palette.ForceInputs, forceTotal.m_82490_((double)motionArrowScale));
            return motionNext;
        }
        return Vec3.f_82478_;
    }

    private void DebugRenderForce(@Nonnull Transform worldTransform, @Nonnull IAcceleration force, @Nonnull Vector4f forceColour) {
        float forceArrowScale = 0.05f;
        if (force.hasLinearComponent(worldTransform)) {
            LinearAcceleration linear = force.getLinearComponent(worldTransform);
            DebugRenderer.renderArrow(worldTransform, 1, forceColour, linear.Acceleration().m_82490_((double)forceArrowScale));
        }
        if (force.hasAngularComponent(worldTransform)) {
            AngularAcceleration torque = force.getAngularComponent(worldTransform);
            DebugRenderer.renderRotation(worldTransform, 1, forceColour, torque.Axis(), torque.Magnitude());
        }
    }

    private static class DebugPalette {
        public final Vector4f PositionCurrent;
        public final Vector4f PositionPrevious;
        public final Vector4f MotionCurrent;
        public final Vector4f MotionPrevious;
        public final Vector4f ForceInputs;
        public final Vector4f ForceReactions;
        public final Vector4f CollisionStatic;
        public final Vector4f CollisionDynamic;

        public DebugPalette(float redMult, float greenMult) {
            this.PositionCurrent = new Vector4f(0.0f, greenMult, 1.0f, 1.0f);
            this.PositionPrevious = new Vector4f(0.25f * redMult, 0.75f * greenMult, 1.0f, 1.0f);
            this.MotionPrevious = new Vector4f(redMult * 0.25f, greenMult * 0.25f, 1.0f, 1.0f);
            this.MotionCurrent = new Vector4f(redMult * 0.5f, greenMult * 0.5f, 1.0f, 1.0f);
            this.ForceInputs = new Vector4f(redMult, greenMult * 0.75f, 0.75f, 1.0f);
            this.ForceReactions = new Vector4f(redMult, 0.0f, 0.0f, 1.0f);
            this.CollisionStatic = new Vector4f(redMult, 0.0f, 1.0f, 1.0f);
            this.CollisionDynamic = new Vector4f(redMult, greenMult * 0.25f, 0.75f, 1.0f);
        }
    }
}

