/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.types.elements;

import com.flansmod.common.FlansMod;
import com.flansmod.common.types.JsonField;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemStackDefinition {
    @JsonField
    public String item = "minecraft:air";
    @JsonField
    public int count = 1;
    @JsonField
    public int damage = 0;
    @JsonField
    public String tags = "{}";

    @Nonnull
    public ItemStack CreateStack() {
        try {
            ResourceLocation itemLoc = new ResourceLocation(this.item);
            Item resolvedItem = (Item)ForgeRegistries.ITEMS.getValue(itemLoc);
            if (resolvedItem == null) {
                FlansMod.LOGGER.warn("Could not find item " + this.item + " in ItemStackDefinition");
                return ItemStack.f_41583_;
            }
            ItemStack stack = new ItemStack((ItemLike)resolvedItem, this.count);
            if (stack.m_41763_()) {
                stack.m_41721_(this.damage);
            }
            return stack;
        }
        catch (Exception e) {
            FlansMod.LOGGER.error("Failed to resolve item stack " + e.getMessage());
            return ItemStack.f_41583_;
        }
    }
}

