/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.types.crafting;

import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import net.minecraft.network.chat.Component;

public enum EMaterialType {
    Misc,
    Wood,
    Glass,
    Metal,
    Composite,
    Electronic,
    Fabric;

    private static final Pattern REGEX;

    public static MaterialAndTier Resolve(String tag) {
        EMaterialType type;
        MatchResult result = REGEX.matcher(tag).toMatchResult();
        if (result.groupCount() == 3) {
            int tier = Integer.parseInt(result.group(2));
            EMaterialType type2 = EMaterialType.parse(result.group(1));
            if (type2 != null) {
                return new MaterialAndTier(tier, type2);
            }
        } else if (result.groupCount() == 2 && (type = EMaterialType.parse(result.group(1))) != null) {
            return new MaterialAndTier(1, type);
        }
        return MaterialAndTier.Invalid;
    }

    public static EMaterialType parse(String value) {
        return switch (value.toLowerCase()) {
            case "wood" -> Wood;
            case "glass" -> Glass;
            case "metal" -> Metal;
            case "composite" -> Composite;
            case "electronic" -> Electronic;
            case "fabric" -> Fabric;
            case "misc" -> Misc;
            default -> null;
        };
    }

    public static EMaterialType GetType(String tag) {
        MatchResult result = REGEX.matcher(tag).toMatchResult();
        if (result.groupCount() > 2) {
            return switch (result.group(1).toLowerCase()) {
                case "wood" -> Wood;
                case "glass" -> Glass;
                case "metal" -> Metal;
                case "composite" -> Composite;
                case "electronic" -> Electronic;
                case "fabric" -> Fabric;
                case "misc" -> Misc;
                default -> null;
            };
        }
        return null;
    }

    public static int GetTier(String tag) {
        MatchResult result = REGEX.matcher(tag).toMatchResult();
        if (result.groupCount() > 2) {
            return Integer.parseInt(result.group(2));
        }
        return -1;
    }

    public Component ToComponent() {
        switch (this) {
            case Misc: {
                return Component.m_237115_((String)"material.misc");
            }
            case Wood: {
                return Component.m_237115_((String)"material.wood");
            }
            case Glass: {
                return Component.m_237115_((String)"material.glass");
            }
            case Metal: {
                return Component.m_237115_((String)"material.metal");
            }
            case Composite: {
                return Component.m_237115_((String)"material.composite");
            }
            case Electronic: {
                return Component.m_237115_((String)"material.electronic");
            }
            case Fabric: {
                return Component.m_237115_((String)"material.fabric");
            }
        }
        return Component.m_237115_((String)"material.unknown");
    }

    static {
        REGEX = Pattern.compile("(flansmod:items/)(misc|wood|glass|metal|composite|electronic|fabric)_tier_([0-9]*)");
    }

    public static class MaterialAndTier {
        public final int Tier;
        public final EMaterialType MaterialType;
        public static final int INVALID_TIER = -1;
        public static final MaterialAndTier Invalid = new MaterialAndTier(-1, Misc);

        public boolean IsValid() {
            return this.Tier != -1;
        }

        protected MaterialAndTier(int tier, EMaterialType type) {
            this.Tier = tier;
            this.MaterialType = type;
        }
    }
}

