/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.types.blocks.elements;

import com.flansmod.common.types.JsonField;
import com.flansmod.common.types.blocks.elements.VoxelShapeDefinition;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockDefinition {
    private static final VoxelShape DEFAULT_SHAPE = Shapes.m_83144_();
    @JsonField
    public boolean full3D = false;
    @JsonField(Docs="This is only used if full3D is false")
    public VoxelShapeDefinition[] hitboxes = new VoxelShapeDefinition[0];
    @JsonField(Docs="If empty, all facings are allowed")
    public Direction[] allowedFacings = new Direction[0];
    private VoxelShape Shape = null;

    @Nonnull
    public VoxelShape CreateVoxelShape() {
        if (this.full3D || this.hitboxes.length == 0) {
            return DEFAULT_SHAPE;
        }
        if (this.Shape == null) {
            this.Shape = this.hitboxes[0].Create();
            for (int i = 1; i < this.hitboxes.length; ++i) {
                this.Shape = Shapes.m_83113_((VoxelShape)this.Shape, (VoxelShape)this.hitboxes[i].Create(), (BooleanOp)BooleanOp.f_82689_);
            }
        }
        return this.Shape;
    }

    @Nonnull
    public Direction GetPlacementFacing(@Nonnull Direction lookDirection) {
        if (this.allowedFacings.length > 0) {
            if (this.allowedFacings.length == 1) {
                return this.allowedFacings[0];
            }
            Direction best = null;
            for (Direction facing : this.allowedFacings) {
                if (lookDirection == facing) {
                    return facing;
                }
                if (lookDirection == facing.m_122424_()) {
                    best = facing;
                }
                if (best != null) continue;
                best = facing;
            }
            return best;
        }
        return lookDirection;
    }
}

