/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.types.abilities.elements;

import com.flansmod.common.actions.contexts.TargetsContext;
import com.flansmod.common.actions.contexts.TriggerContext;
import com.flansmod.common.types.JsonField;
import com.flansmod.common.types.abilities.elements.EAbilityTarget;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class AbilityTargetDefinition {
    @JsonField
    public EAbilityTarget targetType = EAbilityTarget.Shooter;
    @JsonField
    public ResourceLocation[] matchIDs = new ResourceLocation[0];
    @JsonField(AssetPathHint="tags/")
    public ResourceLocation[] matchTags = new ResourceLocation[0];

    public boolean Matches(@Nonnull EAbilityTarget checkTargetType) {
        return this.targetType == checkTargetType;
    }

    public boolean Matches(@Nonnull EAbilityTarget checkTargetType, @Nonnull TriggerContext triggerContext) {
        return this.targetType == checkTargetType;
    }

    public static boolean Matches(@Nonnull AbilityTargetDefinition[] targetDefs, @Nonnull EAbilityTarget checkTargetType, @Nonnull TriggerContext triggerContext) {
        for (AbilityTargetDefinition targetDef : targetDefs) {
            if (!targetDef.Matches(checkTargetType, triggerContext)) continue;
            return true;
        }
        return false;
    }

    public void ApplyTo(@Nonnull TriggerContext triggerContext, @Nonnull TargetsContext targetsContext) {
        switch (this.targetType) {
            case Owner: {
                targetsContext.Add(triggerContext.Owner);
                break;
            }
            case Shooter: {
                targetsContext.Add(triggerContext.Shooter);
                break;
            }
            case ShotEntity: {
                HitResult hitResult = triggerContext.Hit;
                if (!(hitResult instanceof EntityHitResult)) break;
                EntityHitResult entHitResult = (EntityHitResult)hitResult;
                targetsContext.Add(entHitResult.m_82443_());
                break;
            }
            case ShotBlock: {
                HitResult hitResult;
                Level level;
                Level level2 = level = triggerContext.Shooter != null ? triggerContext.Shooter.m_9236_() : null;
                if (level == null || !((hitResult = triggerContext.Hit) instanceof BlockHitResult)) break;
                BlockHitResult blockHitResult = (BlockHitResult)hitResult;
                targetsContext.Add(blockHitResult.m_82425_(), level.m_8055_(blockHitResult.m_82425_()));
                break;
            }
            case ShotPosition: {
                if (triggerContext.Hit == null) break;
                targetsContext.Add(triggerContext.Hit.m_82450_());
                break;
            }
            case SplashedEntities: {
                if (triggerContext.SplashedEntities == null) break;
                for (Entity entity : triggerContext.SplashedEntities) {
                    targetsContext.Add(entity);
                }
                break;
            }
        }
    }

    @Nonnull
    public Component GetTooltip(boolean expanded) {
        String localisationKey = "target.expanded." + this.targetType.toString().toLowerCase();
        switch (this.targetType) {
            case Owner: 
            case Shooter: 
            case ShotEntity: 
            case SplashedEntities: {
                for (ResourceLocation resourceLocation : this.matchIDs) {
                }
                return Component.m_237110_((String)localisationKey, (Object[])new Object[]{Component.m_237115_((String)"target.any")});
            }
        }
        return Component.m_237115_((String)localisationKey);
    }
}

