/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.types.abilities.elements;

import com.flansmod.common.abilities.Abilities;
import com.flansmod.common.abilities.IAbilityEffect;
import com.flansmod.common.types.JsonField;
import com.flansmod.common.types.abilities.elements.EAbilityEffect;
import com.flansmod.common.types.elements.ModifierDefinition;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;

public class AbilityEffectDefinition {
    @JsonField
    public EAbilityEffect effectType = EAbilityEffect.Nothing;
    @JsonField(Docs="The modifiers to add when the effect is active")
    public ModifierDefinition[] modifiers = new ModifierDefinition[0];
    @Nullable
    private IAbilityEffect EffectProcessor = null;

    @Nonnull
    public ModifierDefinition[] MatchModifiers(@Nonnull String stat) {
        ArrayList<ModifierDefinition> matches = new ArrayList<ModifierDefinition>();
        for (ModifierDefinition modifier : this.modifiers) {
            if (!modifier.GetStatWithId().equals(stat)) continue;
            matches.add(modifier);
        }
        return matches.toArray(new ModifierDefinition[0]);
    }

    @Nonnull
    public String ModifyString(@Nonnull String stat, @Nonnull String defaultValue) {
        for (ModifierDefinition modifier : this.modifiers) {
            if (!modifier.GetStatWithId().equals(stat) || modifier.setValue.isEmpty()) continue;
            defaultValue = modifier.setValue;
        }
        return defaultValue;
    }

    public boolean ModifyBoolean(@Nonnull String stat, boolean defaultValue) {
        for (ModifierDefinition modifier : this.modifiers) {
            if (!modifier.GetStatWithId().equals(stat) || modifier.setValue.isEmpty()) continue;
            return Boolean.parseBoolean(modifier.setValue);
        }
        return defaultValue;
    }

    @Nonnull
    public IAbilityEffect GetEffectProcessor() {
        if (this.EffectProcessor == null) {
            this.EffectProcessor = Abilities.CreateEffectProcessor(this);
        }
        return this.EffectProcessor;
    }

    @Nonnull
    public Component GetTooltip(boolean expanded) {
        String localisationKey = "effect.expanded." + this.effectType.toString().toLowerCase();
        switch (this.effectType) {
            default: 
        }
        return Component.m_237115_((String)localisationKey);
    }
}

