/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.network;

import com.flansmod.client.FlansModClient;
import com.flansmod.common.FlansMod;
import com.flansmod.common.network.FlansModMessage;
import com.flansmod.common.network.bidirectional.ActionUpdateMessage;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.server.ServerLifecycleHooks;

public class FlansModPacketHandler {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("flansmod", "main"), () -> "1", "1"::equals, "1"::equals);
    private static int NextMessageID = 0;

    public static void RegisterMessages() {
        FlansModPacketHandler.RegisterClientHandler(ActionUpdateMessage.ToClient.class, ActionUpdateMessage.ToClient::new, () -> FlansModClient.ACTIONS_CLIENT::OnClientReceivedActionUpdate);
        FlansModPacketHandler.RegisterServerHandler(ActionUpdateMessage.ToServer.class, ActionUpdateMessage.ToServer::new, FlansMod.ACTIONS_SERVER::OnServerReceivedActionUpdate);
    }

    public static <TMessage extends FlansModMessage> void RegisterServerHandler(@Nonnull Class<TMessage> clazz, @Nonnull Factory<TMessage> factory, @Nonnull BiConsumer<TMessage, ServerPlayer> handler) {
        INSTANCE.registerMessage(NextMessageID, clazz, FlansModMessage::Encode, buf -> {
            FlansModMessage msg = (FlansModMessage)factory.Create();
            msg.Decode((FriendlyByteBuf)buf);
            return msg;
        }, (msg, ctx) -> ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> FlansModPacketHandler.lambda$RegisterServerHandler$3(handler, msg, (Supplier)ctx)));
        ++NextMessageID;
    }

    public static <TMessage extends FlansModMessage> void RegisterClientHandler(@Nonnull Class<TMessage> clazz, @Nonnull Factory<TMessage> factory, @Nonnull Supplier<Consumer<TMessage>> handlerSupplier) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FlansModPacketHandler.lambda$RegisterClientHandler$8(clazz, factory, (Supplier)handlerSupplier));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> INSTANCE.registerMessage(NextMessageID, clazz, FlansModMessage::Encode, buf -> {
            FlansModMessage msg = (FlansModMessage)factory.Create();
            msg.Decode((FriendlyByteBuf)buf);
            return msg;
        }, (msg, ctx) -> {}));
        ++NextMessageID;
    }

    public static <MSG> void SendToPlayer(@Nonnull ServerPlayer player, @Nonnull MSG message) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), message);
    }

    public static <MSG> void SendToChunk(@Nonnull LevelChunk levelChunk, @Nonnull MSG message) {
        INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> levelChunk), message);
    }

    public static <MSG> void SendToAll(@Nonnull MSG message) {
        INSTANCE.send(PacketDistributor.ALL.noArg(), message);
    }

    public static <MSG> void SendToAllAroundPoint(@Nonnull MSG message, @Nonnull ResourceKey<Level> dimension, @Nonnull Vec3 point, double radius, @Nullable Entity excluding) {
        for (ServerPlayer player : FlansModPacketHandler.getServer().m_6846_().m_11314_()) {
            if (player.equals((Object)excluding) || !player.m_9236_().m_46472_().equals(dimension) || !(player.m_20182_().m_82554_(point) <= radius)) continue;
            INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), message);
            break;
        }
    }

    public static <MSG> void SendToAllAroundPoints(@Nonnull MSG message, @Nonnull ResourceKey<Level> dimension, @Nonnull Collection<Vec3> points, double radius, @Nullable Entity excluding) {
        block0: for (ServerPlayer player : FlansModPacketHandler.getServer().m_6846_().m_11314_()) {
            if (player.equals((Object)excluding) || !player.m_9236_().m_46472_().equals(dimension)) continue;
            for (Vec3 checkPoint : points) {
                if (!(player.m_20182_().m_82554_(checkPoint) <= radius)) continue;
                INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), message);
                continue block0;
            }
        }
    }

    @Nullable
    private static MinecraftServer getServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <MSG> void SendToServer(MSG message) {
        INSTANCE.send(PacketDistributor.SERVER.noArg(), message);
    }

    private static /* synthetic */ void lambda$RegisterClientHandler$8(Class clazz, Factory factory, Supplier handlerSupplier) {
        INSTANCE.registerMessage(NextMessageID, clazz, FlansModMessage::Encode, buf -> {
            FlansModMessage msg = (FlansModMessage)factory.Create();
            msg.Decode((FriendlyByteBuf)buf);
            return msg;
        }, (arg_0, arg_1) -> FlansModPacketHandler.lambda$RegisterClientHandler$7((Supplier)handlerSupplier, arg_0, arg_1));
    }

    private static /* synthetic */ void lambda$RegisterClientHandler$7(Supplier handlerSupplier, FlansModMessage msg, Supplier ctx) {
        ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> FlansModPacketHandler.lambda$RegisterClientHandler$6((Supplier)handlerSupplier, msg, (Supplier)ctx));
    }

    private static /* synthetic */ void lambda$RegisterClientHandler$6(Supplier handlerSupplier, FlansModMessage msg, Supplier ctx) {
        ((Consumer)handlerSupplier.get()).accept(msg);
        ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$RegisterServerHandler$3(BiConsumer handler, FlansModMessage msg, Supplier ctx) {
        handler.accept(msg, ((NetworkEvent.Context)ctx.get()).getSender());
        ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
    }

    public static interface Factory<TMessage> {
        public TMessage Create();
    }
}

