/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.item;

import com.flansmod.common.FlansMod;
import com.flansmod.common.item.AttachmentItem;
import com.flansmod.common.item.PartItem;
import com.flansmod.common.types.JsonDefinition;
import com.flansmod.common.types.abilities.CraftingTraitDefinition;
import com.flansmod.common.types.abilities.elements.CraftingTraitProviderDefinition;
import com.flansmod.common.types.attachments.AttachmentDefinition;
import com.flansmod.common.types.attachments.EAttachmentType;
import com.flansmod.common.types.elements.ModifierDefinition;
import com.flansmod.common.types.elements.PaintableDefinition;
import com.flansmod.common.types.guns.GunDefinition;
import com.flansmod.common.types.guns.elements.AttachmentSettingsDefinition;
import com.flansmod.common.types.parts.PartDefinition;
import com.flansmod.physics.common.util.Maths;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.extensions.IForgeItem;

public abstract class FlanItem
extends Item
implements IForgeItem {
    private static final List<FlanItem> ALL_ITEMS = new ArrayList<FlanItem>(256);
    @Nonnull
    public final ResourceLocation DefinitionLocation;
    public static final UUID InvalidGunUUID = new UUID(0L, 0L);

    public static Iterable<FlanItem> GetAllItems() {
        return ALL_ITEMS;
    }

    public abstract JsonDefinition Def();

    @Nonnull
    public ResourceLocation getDefinitionLocation() {
        return this.DefinitionLocation;
    }

    public FlanItem(@Nonnull ResourceLocation definitionLocation, @Nonnull Item.Properties props) {
        super(props);
        this.DefinitionLocation = definitionLocation;
        ALL_ITEMS.add(this);
    }

    @Nonnull
    public PaintableDefinition GetPaintDef() {
        JsonDefinition jsonDefinition = this.Def();
        if (jsonDefinition instanceof GunDefinition) {
            GunDefinition gunDef = (GunDefinition)jsonDefinition;
            return gunDef.paints;
        }
        return PaintableDefinition.Invalid;
    }

    public boolean ShouldRenderAsIcon(@Nonnull ItemDisplayContext transformType) {
        return transformType == ItemDisplayContext.GUI;
    }

    public boolean CanBeCraftedFromParts() {
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltips, @Nonnull TooltipFlag flags) {
        boolean expanded;
        boolean bl = expanded = InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)344) || InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340);
        if (this.CanBeCraftedFromParts()) {
            if (!expanded) {
                tooltips.add((Component)Component.m_237115_((String)"tooltip.flansmod.hold_shift_for_more"));
            } else {
                PartDefinition[] craftedFromParts = FlanItem.GetCraftingInputs(stack);
                if (craftedFromParts.length == 0) {
                    tooltips.add((Component)Component.m_237115_((String)"tooltip.crafted_from_nothing"));
                } else {
                    for (PartDefinition craftedFrom : craftedFromParts) {
                        tooltips.add((Component)Component.m_237110_((String)"tooltip.crafted_from", (Object[])new Object[]{Component.m_237115_((String)("item." + craftedFrom.GetLocation().m_135827_() + "." + craftedFrom.GetLocation().m_135815_()))}));
                        for (ModifierDefinition modDef : craftedFrom.modifiers) {
                            for (Component modString : modDef.GetModifierStrings()) {
                                tooltips.add((Component)Component.m_237110_((String)"tooltip.crafted_from.modifier_format", (Object[])new Object[]{modString}));
                            }
                        }
                    }
                }
            }
        }
        for (Map.Entry<CraftingTraitDefinition, Integer> kvp : FlanItem.GetTraits(stack).entrySet()) {
            tooltips.add(FlanItem.CreateTraitComponent(kvp.getKey(), kvp.getValue(), expanded));
        }
        for (ItemStack attachmentStack : FlanItem.GetAttachmentStacks(stack)) {
            tooltips.add((Component)Component.m_237110_((String)"tooltip.format.attached", (Object[])new Object[]{attachmentStack.m_41786_()}));
        }
    }

    @Nonnull
    public static UUID Server_GetOrSetNewGunID(@Nonnull ItemStack stack) {
        if (stack.m_41783_() == null || !stack.m_41783_().m_128441_("id")) {
            UUID newUUID = UUID.randomUUID();
            FlansMod.LOGGER.info("GunUUID: Created UUID " + newUUID + " for " + stack);
            stack.m_41784_().m_128362_("id", newUUID);
            return newUUID;
        }
        return stack.m_41783_().m_128342_("id");
    }

    @Nonnull
    public static UUID GetGunID(@Nonnull ItemStack stack) {
        if (stack.m_41619_()) {
            return InvalidGunUUID;
        }
        if (stack.m_41783_() == null || !stack.m_41783_().m_128441_("id")) {
            return InvalidGunUUID;
        }
        if (stack.m_41783_().m_128423_("id").m_6458_() != IntArrayTag.f_128599_) {
            return InvalidGunUUID;
        }
        return stack.m_41783_().m_128342_("id");
    }

    public boolean HasAttachmentSlot(@Nonnull EAttachmentType type, int slot) {
        AttachmentSettingsDefinition attachSettings = null;
        JsonDefinition jsonDefinition = this.Def();
        if (jsonDefinition instanceof GunDefinition) {
            GunDefinition gunDef = (GunDefinition)jsonDefinition;
            attachSettings = gunDef.GetAttachmentSettings(type);
        }
        if (attachSettings != null) {
            return attachSettings.numAttachmentSlots > slot;
        }
        return false;
    }

    public boolean CanAcceptAttachment(@Nonnull ItemStack attachmentStack, @Nonnull EAttachmentType slotType, int slotIndex) {
        JsonDefinition jsonDefinition = this.Def();
        if (jsonDefinition instanceof GunDefinition) {
            GunDefinition gunDef = (GunDefinition)jsonDefinition;
            AttachmentSettingsDefinition attachSettings = gunDef.GetAttachmentSettings(slotType);
            if (slotIndex < attachSettings.numAttachmentSlots) {
                if (attachSettings.matchNames.length == 0 && attachSettings.matchTags.length == 0) {
                    return true;
                }
                if (attachSettings.matchNames.length > 0) {
                    for (String matchName : attachSettings.matchNames) {
                        if (!attachmentStack.m_41720_().m_204114_().m_203373_(new ResourceLocation(matchName))) continue;
                        return true;
                    }
                }
                if (attachSettings.matchTags.length > 0) {
                    for (String matchTag : attachSettings.matchTags) {
                        if (!attachmentStack.m_41720_().m_204114_().containsTag(TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(matchTag)))) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Nonnull
    private static String GetSlotKey(@Nonnull EAttachmentType type, int slot) {
        return type.name() + "_" + slot;
    }

    @Nonnull
    public static ItemStack GetAttachmentInSlot(@Nonnull ItemStack stack, @Nonnull EAttachmentType type, int slot) {
        CompoundTag attachTags;
        CompoundTag tags;
        if (stack.m_41782_() && (tags = stack.m_41784_()).m_128441_("attachments") && (attachTags = tags.m_128469_("attachments")).m_128441_(FlanItem.GetSlotKey(type, slot))) {
            return ItemStack.m_41712_((CompoundTag)attachTags.m_128469_(FlanItem.GetSlotKey(type, slot)));
        }
        return ItemStack.f_41583_;
    }

    @Nonnull
    public static List<AttachmentDefinition> GetAttachmentDefinitions(@Nonnull ItemStack stack) {
        ArrayList<AttachmentDefinition> defs = new ArrayList<AttachmentDefinition>();
        for (ItemStack attachmentStack : FlanItem.GetAttachmentStacks(stack)) {
            Item item = attachmentStack.m_41720_();
            if (!(item instanceof AttachmentItem)) continue;
            AttachmentItem attachmentItem = (AttachmentItem)item;
            defs.add(attachmentItem.Def());
        }
        return defs;
    }

    @Nonnull
    public static List<ItemStack> GetAttachmentStacks(@Nonnull ItemStack stack) {
        CompoundTag tags;
        ArrayList<ItemStack> attachmentStacks = new ArrayList<ItemStack>();
        if (stack.m_41782_() && (tags = stack.m_41784_()).m_128441_("attachments")) {
            CompoundTag attachTags = tags.m_128469_("attachments");
            for (String key : attachTags.m_128431_()) {
                ItemStack attachmentStack = ItemStack.m_41712_((CompoundTag)attachTags.m_128469_(key));
                if (attachmentStack.m_41619_()) continue;
                attachmentStacks.add(attachmentStack);
            }
        }
        return attachmentStacks;
    }

    public static boolean TryAttach(@Nonnull ItemStack stack, @Nonnull ItemStack attachmentStack) {
        Item item = attachmentStack.m_41720_();
        if (item instanceof AttachmentItem) {
            AttachmentItem attachmentItem = (AttachmentItem)item;
            CompoundTag tags = stack.m_41784_();
            CompoundTag attachTags = tags.m_128469_("attachments");
            EAttachmentType type = attachmentItem.Def().attachmentType;
            int slot = 0;
            while (attachTags.m_128441_(FlanItem.GetSlotKey(type, slot))) {
                ++slot;
            }
            CompoundTag saveTags = new CompoundTag();
            attachmentStack.m_41739_(saveTags);
            attachTags.m_128365_(FlanItem.GetSlotKey(type, slot), (Tag)saveTags);
            if (!tags.m_128441_("attachments")) {
                tags.m_128365_("attachments", (Tag)attachTags);
            }
            return true;
        }
        return false;
    }

    public static void SetAttachmentInSlot(@Nonnull ItemStack stack, @Nonnull EAttachmentType type, int slot, @Nonnull ItemStack attachmentStack) {
        CompoundTag tags = stack.m_41784_();
        CompoundTag attachTags = tags.m_128469_("attachments");
        CompoundTag saveTags = new CompoundTag();
        attachmentStack.m_41739_(saveTags);
        attachTags.m_128365_(FlanItem.GetSlotKey(type, slot), (Tag)saveTags);
        if (!tags.m_128441_("attachments")) {
            tags.m_128365_("attachments", (Tag)attachTags);
        }
    }

    @Nonnull
    public static ItemStack RemoveAttachmentFromSlot(@Nonnull ItemStack stack, @Nonnull EAttachmentType type, int slot) {
        ItemStack ret = FlanItem.GetAttachmentInSlot(stack, type, slot);
        FlanItem.SetAttachmentInSlot(stack, type, slot, ItemStack.f_41583_);
        return ret;
    }

    @Nonnull
    public static String GetPaintjobName(@Nonnull ItemStack stack) {
        if (stack.m_41782_() && stack.m_41784_().m_128441_("paint")) {
            return stack.m_41784_().m_128461_("paint");
        }
        return "default";
    }

    public static void SetPaintjobName(@Nonnull ItemStack stack, @Nonnull String paint) {
        stack.m_41784_().m_128359_("paint", paint);
    }

    @Nonnull
    public static PartDefinition[] GetCraftingInputs(@Nonnull ItemStack stack) {
        if (stack.m_41782_() && stack.m_41784_().m_128441_("parts")) {
            CompoundTag craftingTags = stack.m_41784_().m_128469_("parts");
            PartDefinition[] parts = new PartDefinition[craftingTags.m_128431_().size()];
            int index = 0;
            for (String key : craftingTags.m_128431_()) {
                ResourceLocation resLoc = new ResourceLocation(craftingTags.m_128461_(key));
                parts[index] = (PartDefinition)FlansMod.PARTS.Get(resLoc);
                ++index;
            }
            return parts;
        }
        return new PartDefinition[0];
    }

    public static void SetCraftingInputs(@Nonnull ItemStack stack, @Nonnull List<ItemStack> partStacks) {
        CompoundTag craftingTags = new CompoundTag();
        int index = 0;
        for (ItemStack partStack : partStacks) {
            if (partStack.m_41619_()) continue;
            Item item = partStack.m_41720_();
            if (item instanceof PartItem) {
                PartItem part = (PartItem)item;
                craftingTags.m_128359_(Integer.toString(index), part.DefinitionLocation.toString());
            }
            ++index;
        }
        stack.m_41784_().m_128365_("parts", (Tag)craftingTags);
    }

    public static void SetCraftingInputs(@Nonnull ItemStack stack, @Nonnull ItemStack[] partStacks) {
        CompoundTag craftingTags = new CompoundTag();
        int index = 0;
        for (ItemStack partStack : partStacks) {
            if (partStack.m_41619_()) continue;
            Item item = partStack.m_41720_();
            if (item instanceof PartItem) {
                PartItem part = (PartItem)item;
                craftingTags.m_128359_(Integer.toString(index), part.DefinitionLocation.toString());
            }
            ++index;
        }
        stack.m_41784_().m_128365_("parts", (Tag)craftingTags);
    }

    protected void CollectAbilities(@Nonnull ItemStack stack, @Nonnull Map<CraftingTraitDefinition, Integer> abilityMap) {
    }

    @Nonnull
    public static Map<CraftingTraitDefinition, Integer> GetTraits(@Nonnull ItemStack stack) {
        HashMap<CraftingTraitDefinition, Integer> abilityMap = new HashMap<CraftingTraitDefinition, Integer>();
        for (PartDefinition part : FlanItem.GetCraftingInputs(stack)) {
            for (CraftingTraitProviderDefinition abilityProvider : part.traits) {
                CraftingTraitDefinition ability = abilityProvider.GetAbility();
                if (!ability.IsValid()) continue;
                int newLevel = abilityMap.getOrDefault(ability, 0) + abilityProvider.level;
                newLevel = Maths.min(newLevel, ability.maxLevel);
                abilityMap.put(ability, newLevel);
            }
        }
        for (AttachmentDefinition attachment : FlanItem.GetAttachmentDefinitions(stack)) {
            for (CraftingTraitProviderDefinition abilityProvider : attachment.abilities) {
                CraftingTraitDefinition ability = abilityProvider.GetAbility();
                if (!ability.IsValid()) continue;
                int newLevel = abilityMap.getOrDefault(ability, 0) + abilityProvider.level;
                newLevel = Maths.min(newLevel, ability.maxLevel);
                abilityMap.put(ability, newLevel);
            }
        }
        Item item = stack.m_41720_();
        if (item instanceof FlanItem) {
            FlanItem flanItem = (FlanItem)item;
            flanItem.CollectAbilities(stack, abilityMap);
        }
        return abilityMap;
    }

    @Nonnull
    public static String GetModeValue(@Nonnull ItemStack stack, @Nonnull String modeKey, @Nonnull String defaultValue) {
        if (stack.m_41784_().m_128441_("modes")) {
            return stack.m_41784_().m_128469_("modes").m_128461_(modeKey);
        }
        return defaultValue;
    }

    public static void SetModeValue(@Nonnull ItemStack stack, @Nonnull String modeKey, @Nonnull String modeValue) {
        if (!stack.m_41784_().m_128441_("modes")) {
            stack.m_41784_().m_128365_("modes", (Tag)new CompoundTag());
        }
        stack.m_41784_().m_128469_("modes").m_128359_(modeKey, modeValue);
    }

    @Nonnull
    public static Component ListOf(@Nonnull String prefix, @Nonnull String[] strings) {
        MutableComponent commaList = Component.m_237115_((String)(prefix + strings[0]));
        for (int i = 1; i < strings.length; ++i) {
            commaList = Component.m_237110_((String)(i == strings.length - 1 ? "comma_list.append_last" : "comma_list.append_one"), (Object[])new Object[]{commaList, Component.m_237115_((String)(prefix + strings[i]))});
        }
        return commaList;
    }

    @Nonnull
    public static Component ListOf(@Nonnull Component[] strings) {
        Component commaList = strings[0];
        for (int i = 1; i < strings.length; ++i) {
            commaList = Component.m_237110_((String)(i == strings.length - 1 ? "comma_list.append_last" : "comma_list.append_one"), (Object[])new Object[]{commaList, strings[i]});
        }
        return commaList;
    }

    @Nonnull
    public static Component CreateTraitComponent(@Nonnull CraftingTraitDefinition trait, int level, boolean expanded) {
        MutableComponent abilityString = trait.maxLevel == 1 ? Component.m_237110_((String)"tooltip.ability_without_level", (Object[])new Object[]{Component.m_237115_((String)("ability." + trait.Location.m_135827_() + "." + trait.Location.m_135815_()))}) : Component.m_237110_((String)"tooltip.ability_with_level", (Object[])new Object[]{Component.m_237115_((String)("ability." + trait.Location.m_135827_() + "." + trait.Location.m_135815_())), Component.m_237115_((String)Maths.toRomanNumerals(level))});
        MutableComponent abilityColour = Component.m_237115_((String)("ability." + trait.Location.m_135827_() + "." + trait.Location.m_135815_() + ".colour"));
        if (!expanded) {
            return Component.m_237113_((String)("\u00a7" + abilityColour.getString() + abilityString.getString()));
        }
        MutableComponent abilityTooltipString = Component.m_237115_((String)("ability." + trait.Location.m_135827_() + "." + trait.Location.m_135815_() + ".tooltip." + level));
        return Component.m_237113_((String)("\u00a7" + abilityColour.getString() + abilityString.getString() + " - " + abilityTooltipString.getString()));
    }
}

