/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.gunshots;

import com.flansmod.common.gunshots.PlayerSnapshot;
import com.flansmod.common.gunshots.snapshots.CommonPlayerModel;
import com.flansmod.physics.common.util.Maths;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector4f;

public class PlayerMovementHistory {
    private CommonPlayerModel PlayerModel;
    private PlayerSnapshot[] snapshotRingBuffer;
    private int mostRecentSnapshot;
    private int snapshotCount;

    public PlayerMovementHistory(int numSnaps) {
        this.snapshotCount = numSnaps;
        this.snapshotRingBuffer = new PlayerSnapshot[numSnaps];
        this.mostRecentSnapshot = numSnaps - 1;
        for (int i = 0; i < this.snapshotCount; ++i) {
            this.snapshotRingBuffer[i] = new PlayerSnapshot();
        }
        this.PlayerModel = new CommonPlayerModel();
    }

    private int GetNextIndex() {
        return (this.mostRecentSnapshot + 1) % this.snapshotCount;
    }

    private int GetCurrentIndex() {
        return this.mostRecentSnapshot;
    }

    private int GetIndexNTicksAgo(int n) {
        return Maths.modulo(this.mostRecentSnapshot - n, this.snapshotCount);
    }

    public void TakeSnapshot(@Nonnull Player player) {
        PlayerSnapshot snap = this.snapshotRingBuffer[this.GetNextIndex()];
        this.PlayerModel.Snap(player, snap);
        this.mostRecentSnapshot = this.GetNextIndex();
    }

    public int GetNumSnapshots() {
        return this.snapshotCount;
    }

    @Nonnull
    public PlayerSnapshot GetSnapshotNTicksAgo(int nTicks) {
        if (nTicks < 0 || nTicks >= this.snapshotCount) {
            return PlayerSnapshot.INVALID;
        }
        PlayerSnapshot snap = this.snapshotRingBuffer[this.GetIndexNTicksAgo(nTicks)];
        return snap == null ? PlayerSnapshot.INVALID : snap;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void debugRender(boolean client) {
        int i = 40;
        float decay = (float)i / (float)this.snapshotCount;
        this.GetSnapshotNTicksAgo(i).debugRender(new Vec3(0.0, 0.0, 0.0), new Vector4f(decay, client ? 1.0f : 0.0f, client ? 0.0f : 1.0f, 1.0f - decay));
    }
}

