/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.entity.vehicle.modules;

import com.flansmod.common.entity.vehicle.PerPartMap;
import com.flansmod.common.entity.vehicle.VehicleEntity;
import com.flansmod.common.entity.vehicle.hierarchy.VehicleComponentPath;
import com.flansmod.common.entity.vehicle.save.SeatSyncState;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;

public interface IVehicleSeatHelper {
    @Nonnull
    public PerPartMap<SeatSyncState> GetSeatSaveData();

    public void SetSeatSaveData(@Nonnull PerPartMap<SeatSyncState> var1);

    public List<VehicleComponentPath> GetSeatOrdering();

    @Nonnull
    default public SeatSyncState GetSeat(@Nonnull VehicleComponentPath seatPath) {
        return this.GetSeatSaveData().GetOrDefault(seatPath, SeatSyncState.INVALID);
    }

    @Nonnull
    default public UUID GetPassengerIDInSeat(@Nonnull VehicleComponentPath seatPath) {
        return this.GetSeat((VehicleComponentPath)seatPath).PassengerID;
    }

    @Nullable
    default public Entity GetPassengerInSeat(@Nonnull VehicleComponentPath seatPath, @Nonnull List<Entity> passengers) {
        UUID id = this.GetPassengerIDInSeat(seatPath);
        for (Entity entity : passengers) {
            if (!entity.m_20148_().equals(id)) continue;
            return entity;
        }
        return null;
    }

    @Nonnull
    default public VehicleComponentPath GetControlSeatPath() {
        int i = 0;
        if (i < this.GetSeatOrdering().size()) {
            return this.GetSeatOrdering().get(i);
        }
        return VehicleComponentPath.Invalid;
    }

    @Nonnull
    default public SeatSyncState GetSeat(int seatIndex) {
        return this.GetSeat(this.GetSeatOrdering().get(seatIndex));
    }

    default public int GetSeatIndexOf(@Nonnull Entity entity) {
        for (int i = 0; i < this.GetSeatOrdering().size(); ++i) {
            if (this.GetSeat((int)i).PassengerID != entity.m_20148_()) continue;
            return i;
        }
        return -1;
    }

    default public int GetSeatIndexForNewPassenger(@Nonnull Entity passenger) {
        for (int i = 0; i < this.GetSeatOrdering().size(); ++i) {
            if (!this.GetSeat(i).IsEmpty()) continue;
            return i;
        }
        return -1;
    }

    default public int GetControlSeatIndex() {
        return -1;
    }

    @Nullable
    default public Entity GetControllingPassenger(@Nonnull VehicleEntity vehicle) {
        return this.GetPassengerInSeat(this.GetControlSeatPath(), vehicle.m_20197_());
    }
}

