/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.entity.vehicle.hierarchy;

import com.flansmod.common.entity.vehicle.VehicleEntity;
import com.flansmod.physics.common.collision.TransformedBB;
import com.flansmod.physics.common.deprecated.ContinuousSeparationManifold;
import com.flansmod.physics.common.util.ITransformPair;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.Transform;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class VehicleCollisionSystem {
    private static PlayerType GetAuth(@Nonnull Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!entity.m_9236_().f_46443_) {
                return PlayerType.SERVER;
            }
            return entity.m_6109_() ? PlayerType.CLIENT_LOCAL : PlayerType.CLIENT_REMOTE;
        }
        return PlayerType.NOT_A_PLAYER;
    }

    public static void CollideEntities(@Nonnull VehicleEntity vehicle) {
        Level world = vehicle.m_20193_();
        Transform rootTransform = vehicle.RootTransformCurrent();
        AABB bounds = vehicle.m_20191_();
        List entitiesWithinAABB = world.m_6443_(Entity.class, bounds.m_82400_(2.0).m_82363_(0.0, 32.0, 0.0), vehicle::m_7337_);
        boolean processedLocalPlayer = false;
        for (Entity entity : entitiesWithinAABB) {
            if (!entity.m_6084_()) continue;
            PlayerType playerType = VehicleCollisionSystem.GetAuth(entity);
            switch (playerType) {
                case CLIENT_REMOTE: {
                    break;
                }
                case CLIENT_LOCAL: {
                    if (processedLocalPlayer) break;
                    VehicleCollisionSystem.CollideWithAuthority(vehicle, entity);
                    processedLocalPlayer = true;
                    break;
                }
                case SERVER: {
                    VehicleCollisionSystem.ResetGroundedTicks(entity);
                    break;
                }
                case NOT_A_PLAYER: {
                    VehicleCollisionSystem.ResetGroundedTicks(entity);
                    VehicleCollisionSystem.CollideWithAuthority(vehicle, entity);
                }
            }
        }
    }

    private static void ResetGroundedTicks(@Nonnull Entity entity) {
    }

    private static void CollideWithAuthority(@Nonnull VehicleEntity vehicle, @Nonnull Entity entity) {
    }

    private static void CollideWithAuthority(@Nonnull VehicleEntity vehicle, @Nonnull ITransformPair partTransformPair, @Nonnull Vec3 partMotion, @Nonnull List<AABB> partColliders, @Nonnull Entity entity) {
        double idealVerticalMotion;
        boolean anyCollision;
        Vec3 entityMotion;
        Transform partTransform = partTransformPair.current();
        Vec3 entityPosGlobal = entity.m_20182_();
        AABB entityBounds = entity.m_20191_();
        Vec3 motionGlobal = entity.m_20184_();
        TransformedBB entityTransformLocal = TransformedBB.EntityInSpace(entityBounds, entityPosGlobal, partTransform);
        Vec3 motionLocal = partTransform.globalToLocalVelocity(motionGlobal).m_82546_(partMotion);
        CollisionResolver resolver = new CollisionResolver(entity, entityTransformLocal, motionLocal);
        resolver.DoPassAgainst(partColliders, true);
        resolver.DoPassAgainst(partColliders, false);
        Vec3 entityMotionNoTemporal = entityMotion = entity.m_20184_();
        Vec3 resultNormal = resolver.CollisionNormal;
        Vec3 resultPosition = resolver.CollisionPosition;
        Vec3 totalResponse = resolver.CollisionResponse;
        boolean hardCollision = !totalResponse.equals((Object)Vec3.f_82478_);
        boolean temporalCollision = !Maths.approx(resolver.TemporalResponse, 1.0f);
        Vec3 motionResponse = temporalCollision ? motionLocal.m_82490_((double)resolver.TemporalResponse) : motionLocal;
        Vec3 globalMotionResponse = partTransform.localToGlobalVelocity(motionResponse).m_82549_(partMotion);
        Vec3 globalTotalResponse = partTransform.localToGlobalVelocity(totalResponse);
        Vec3 globalNormal = partTransform.localToGlobalDirection(resultNormal).m_82541_();
        Vec3 globalPosition = partTransform.localToGlobalPosition(resultPosition);
        double slide = 0.0;
        if (!Maths.approx(globalPosition, Vec3.f_82478_)) {
            globalPosition = globalPosition.m_82549_(entity.m_20182_().m_82549_(entity.m_20191_().m_82399_()).m_82490_(0.5));
            if (temporalCollision) {
                globalPosition = globalPosition.m_82520_(0.0, globalMotionResponse.f_82480_, 0.0);
            }
        }
        boolean hasNormal = !globalNormal.equals((Object)Vec3.f_82478_);
        boolean bl = anyCollision = hardCollision || temporalCollision;
        if (temporalCollision && Maths.approx(idealVerticalMotion = globalMotionResponse.f_82480_, entityMotion.f_82480_)) {
            entity.m_20256_(entityMotion.m_82542_(1.0, 0.0, 1.0).m_82520_(0.0, idealVerticalMotion, 0.0));
            entityMotion = entity.m_20184_();
        }
        if (hardCollision) {
            double motionX = entityMotion.m_7096_();
            double motionY = entityMotion.m_7098_();
            double motionZ = entityMotion.m_7094_();
            double intersectX = totalResponse.m_7096_();
            double intersectY = totalResponse.m_7098_();
            double intersectZ = totalResponse.m_7094_();
            double horizonalEpsilon = 0.0078125;
            if (motionX != 0.0 && Math.abs(intersectX) > horizonalEpsilon && motionX > 0.0 == intersectX < 0.0) {
                entityMotion = entityMotion.m_82542_(0.0, 1.0, 1.0);
            }
            if (motionY != 0.0 && intersectY != 0.0 && motionY > 0.0 == intersectY < 0.0) {
                entityMotion = entityMotion.m_82542_(1.0, 0.0, 1.0).m_82520_(0.0, partMotion.f_82480_, 0.0);
            }
            if (motionZ != 0.0 && Math.abs(intersectZ) > horizonalEpsilon && motionZ > 0.0 == intersectZ < 0.0) {
                entityMotion = entityMotion.m_82542_(1.0, 1.0, 0.0);
            }
        }
        if (slide > 0.0 && hasNormal && anyCollision) {
            double slideFactor = globalNormal.m_82542_(1.0, 0.0, 1.0).m_82553_() * 1.25;
            Vec3 motionIn = entityMotionNoTemporal.m_82542_(0.0, 0.9, 0.0).m_82520_(0.0, (double)-0.01f, 0.0);
            Vec3 slideNormal = globalNormal.m_82537_(motionIn.m_82537_(globalNormal)).m_82541_();
            Vec3 newMotion = entityMotion.m_82542_(0.85, 0.0, 0.85).m_82549_(slideNormal.m_82490_(((double)0.2f + slide) * motionIn.m_82553_() * slideFactor).m_82520_(0.0, (double)-0.1f - globalNormal.f_82480_ * 0.125, 0.0));
            entity.m_20256_(newMotion);
            entityMotion = entity.m_20184_();
        }
        if (hardCollision || resolver.IsSurfaceCollision) {
            Vec3 allowedMovement = VehicleCollisionSystem.ApplyDefaultEntityCollision(globalTotalResponse, entity);
            entity.m_6034_(entityPosGlobal.f_82479_ + allowedMovement.f_82479_, entityPosGlobal.f_82480_ + allowedMovement.f_82480_, entityPosGlobal.f_82481_ + allowedMovement.f_82481_);
            entityPosGlobal = entity.m_20182_();
            entity.f_19864_ = true;
            Vec3 contactPointMotion = Vec3.f_82478_;
            if (resolver.IsSurfaceCollision) {
                boolean canWalk;
                entity.f_19789_ = 0.0f;
                for (Entity entity2 : entity.m_146897_()) {
                }
                boolean bl2 = canWalk = slide == 0.0;
                if (canWalk) {
                    entity.m_6853_(true);
                    if (entity instanceof ItemEntity) {
                        entityMotion = entityMotion.m_82542_(0.5, 1.0, 0.5);
                    }
                }
                contactPointMotion = VehicleCollisionSystem.GetMovementOfPointOnPart(globalPosition, partTransformPair);
                allowedMovement = VehicleCollisionSystem.ApplyDefaultEntityCollision(contactPointMotion, entity);
                entity.m_6034_(entityPosGlobal.f_82479_ + allowedMovement.f_82479_, entityPosGlobal.f_82480_, entityPosGlobal.f_82481_ + allowedMovement.f_82481_);
            }
            entity.m_20256_(entityMotion);
            if (VehicleCollisionSystem.GetAuth(entity) == PlayerType.CLIENT_LOCAL) {
                double d0 = entity.m_20185_() - entity.f_19854_ - contactPointMotion.f_82479_;
                double d = entity.m_20189_() - entity.f_19856_ - contactPointMotion.f_82481_;
            }
        }
    }

    @Nonnull
    private static Vec3 GetMovementOfPointOnPart(@Nonnull Vec3 globalPointPrevious, @Nonnull ITransformPair partTransformPair) {
        Vec3 partLocalPos = partTransformPair.previous().globalToLocalPosition(globalPointPrevious);
        Vec3 globalPosCurrent = partTransformPair.current().localToGlobalPosition(partLocalPos);
        return globalPosCurrent.m_82546_(partLocalPos);
    }

    private static Vec3 ApplyDefaultEntityCollision(Vec3 p_20273_, Entity e) {
        boolean flag3;
        AABB aabb = e.m_20191_();
        List list = e.m_9236_().m_183134_(e, aabb.m_82369_(p_20273_));
        Vec3 vec3 = p_20273_.m_82556_() == 0.0 ? p_20273_ : Entity.m_198894_((Entity)e, (Vec3)p_20273_, (AABB)aabb, (Level)e.m_9236_(), (List)list);
        boolean flag = p_20273_.f_82479_ != vec3.f_82479_;
        boolean flag1 = p_20273_.f_82480_ != vec3.f_82480_;
        boolean flag2 = p_20273_.f_82481_ != vec3.f_82481_;
        boolean bl = flag3 = flag1 && p_20273_.f_82480_ < 0.0;
        if (e.getStepHeight() > 0.0f && flag3 && (flag || flag2)) {
            Vec3 vec33;
            Vec3 vec31 = Entity.m_198894_((Entity)e, (Vec3)new Vec3(p_20273_.f_82479_, (double)e.getStepHeight(), p_20273_.f_82481_), (AABB)aabb, (Level)e.m_9236_(), (List)list);
            Vec3 vec32 = Entity.m_198894_((Entity)e, (Vec3)new Vec3(0.0, (double)e.getStepHeight(), 0.0), (AABB)aabb.m_82363_(p_20273_.f_82479_, 0.0, p_20273_.f_82481_), (Level)e.m_9236_(), (List)list);
            if (vec32.f_82480_ < (double)e.getStepHeight() && (vec33 = Entity.m_198894_((Entity)e, (Vec3)new Vec3(p_20273_.f_82479_, 0.0, p_20273_.f_82481_), (AABB)aabb.m_82383_(vec32), (Level)e.m_9236_(), (List)list).m_82549_(vec32)).m_165925_() > vec31.m_165925_()) {
                vec31 = vec33;
            }
            if (vec31.m_165925_() > vec3.m_165925_()) {
                return vec31.m_82549_(Entity.m_198894_((Entity)e, (Vec3)new Vec3(0.0, -vec31.f_82480_ + p_20273_.f_82480_, 0.0), (AABB)aabb.m_82383_(vec31), (Level)e.m_9236_(), (List)list));
            }
        }
        return vec3;
    }

    private static enum PlayerType {
        NOT_A_PLAYER,
        SERVER,
        CLIENT_LOCAL,
        CLIENT_REMOTE;

    }

    private static class CollisionResolver {
        @Nonnull
        public final Entity TestEntity;
        @Nonnull
        public final Vec3 RelativeMotion;
        @Nonnull
        public TransformedBB RelativeEntity;
        @Nonnull
        public Vec3 CollisionResponse;
        @Nonnull
        public Vec3 CollisionPosition;
        @Nonnull
        public Vec3 CollisionNormal;
        public boolean IsSurfaceCollision;
        public float TemporalResponse;

        public CollisionResolver(@Nonnull Entity testEntity, @Nonnull TransformedBB relativeEntity, @Nonnull Vec3 relativeMotion) {
            this.TestEntity = testEntity;
            this.RelativeEntity = relativeEntity;
            this.RelativeMotion = relativeMotion;
            this.CollisionPosition = Vec3.f_82478_;
            this.CollisionNormal = Vec3.f_82478_;
            this.CollisionResponse = Vec3.f_82478_;
            this.IsSurfaceCollision = false;
            this.TemporalResponse = 1.0f;
        }

        public void DoPassAgainst(@Nonnull List<AABB> partAABBs, boolean horizontal) {
            for (AABB bb : partAABBs) {
                boolean isNearest;
                Vec3 separation;
                double tImpact;
                boolean isTemporal;
                double dZ;
                double dY;
                Vec3 currentResponse = this.CollisionResponse;
                Vec3 currentCenter = this.RelativeEntity.GetCenter().m_82549_(currentResponse);
                double dX = Math.abs(currentCenter.f_82479_ - bb.m_82399_().f_82479_) - this.RelativeEntity.XSize() - 1.0;
                if (dX < bb.m_82362_() / 2.0 || (dY = Math.abs(currentCenter.f_82480_ + this.RelativeMotion.f_82480_ - bb.m_82399_().f_82479_) - this.RelativeEntity.YSize() - 1.0) > bb.m_82376_() / 2.0 || (dZ = Math.abs(currentCenter.f_82481_ - bb.m_82399_().f_82481_) - this.RelativeEntity.ZSize() - 1.0) > bb.m_82385_() / 2.0) continue;
                this.RelativeEntity = this.RelativeEntity.Move(t -> t.withPosition(currentCenter));
                ContinuousSeparationManifold intersection = this.RelativeEntity.Intersect(bb, this.RelativeMotion);
                if (intersection == null) continue;
                if (!horizontal && !this.IsSurfaceCollision && intersection.IsSurfaceCollision()) {
                    this.IsSurfaceCollision = true;
                }
                boolean bl = isTemporal = 0.0 < (tImpact = intersection.GetTimeOfImpact()) && tImpact < 1.0;
                if (!isTemporal && (separation = intersection.AsSeparationVec(this.TestEntity.getStepHeight())) != null && !separation.equals((Object)Vec3.f_82478_)) {
                    this.CollisionResponse = currentResponse.m_82549_(separation);
                    tImpact = 0.0;
                }
                boolean bl2 = isNearest = 0.0 <= tImpact && tImpact < (double)this.TemporalResponse;
                if (isNearest) {
                    Vec3 collidingPosition;
                    Vec3 collidingNormal = intersection.GetCollisionNormal();
                    if (collidingNormal != null) {
                        this.CollisionNormal = collidingNormal;
                    }
                    if ((collidingPosition = intersection.GetCollisionPosition()) != null) {
                        this.CollisionPosition = collidingPosition;
                    }
                }
                if (!isTemporal || !(tImpact < (double)this.TemporalResponse)) continue;
                this.TemporalResponse = (float)tImpact;
            }
            if (horizontal) {
                boolean noVerticalCollision;
                boolean noVerticalMotionResponse = this.TemporalResponse == 1.0f;
                boolean bl = noVerticalCollision = this.CollisionResponse.f_82480_ == 0.0;
                if (!noVerticalCollision || !noVerticalMotionResponse) {
                    this.CollisionResponse = this.CollisionResponse.m_82542_(1.0078125, 0.0, 1.0078125);
                }
            }
        }
    }
}

