/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.entity.vehicle.hierarchy;

import com.flansmod.common.entity.vehicle.hierarchy.VehicleComponentPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MultiLookup<THint, TValue> {
    private final Map<VehicleComponentPath, TValue> ByPartName = new HashMap<VehicleComponentPath, TValue>();
    private final List<VehicleComponentPath> PartListByIndex = new ArrayList<VehicleComponentPath>();
    private final List<TValue> ByIndex = new ArrayList<TValue>();
    private final Map<THint, List<TValue>> ByHint = new HashMap<THint, List<TValue>>();

    @Nonnull
    public Collection<TValue> All() {
        return this.ByIndex;
    }

    @Nullable
    public TValue ByIndex(int index) {
        return this.ByIndex.get(index);
    }

    @Nonnull
    public VehicleComponentPath PartNameOfIndex(int index) {
        return this.PartListByIndex.get(index);
    }

    @Nullable
    public TValue ByPath(@Nonnull VehicleComponentPath partName) {
        return this.ByPartName.get(partName);
    }

    @Nonnull
    public Collection<TValue> ByHint(@Nonnull THint hint) {
        return this.ByHint.getOrDefault(hint, List.of());
    }

    @Nonnull
    public Collection<TValue> ByHints(THint ... hints) {
        if (hints.length == 0) {
            return List.of();
        }
        Collection<TValue> check0 = this.ByHint(hints[0]);
        if (hints.length == 1) {
            return check0;
        }
        ArrayList<TValue> validWheels = new ArrayList<TValue>(check0.size());
        for (THint hint : hints) {
            Collection<TValue> checkForHint = this.ByHint(hint);
            for (TValue t : checkForHint) {
                if (validWheels.contains(t)) continue;
                validWheels.add(t);
            }
        }
        return validWheels;
    }

    public void ForEach(@Nonnull Consumer<TValue> func) {
        for (TValue t : this.ByIndex) {
            func.accept(t);
        }
    }

    public void ForEachWithRemoval(@Nonnull Function<TValue, Boolean> func) {
        for (int i = this.ByIndex.size() - 1; i >= 0; --i) {
            TValue wheel = this.ByIndex.get(i);
            boolean remove = func.apply(wheel);
            if (!remove) continue;
            this.RemoveAt(i);
        }
    }

    public int Add(@Nonnull TValue t, @Nonnull VehicleComponentPath partName, @Nonnull THint[] hints) {
        this.ByIndex.add(t);
        this.PartListByIndex.add(partName);
        if (!this.ByPartName.containsKey(partName)) {
            this.ByPartName.put(partName, t);
        }
        for (THint hint : hints) {
            if (!this.ByHint.containsKey(hint)) {
                this.ByHint.put(hint, new ArrayList());
            }
            this.ByHint.get(hint).add(t);
        }
        return this.ByIndex.size() - 1;
    }

    public void RemoveAt(int index) {
        TValue t = this.ByIndex.get(index);
        VehicleComponentPath path = null;
        for (Map.Entry<VehicleComponentPath, TValue> entry : this.ByPartName.entrySet()) {
            if (entry.getValue() != t) continue;
            path = entry.getKey();
        }
        if (path != null) {
            this.ByPartName.remove(path);
        }
        for (List list : this.ByHint.values()) {
            list.remove(t);
        }
        this.ByIndex.remove(index);
        this.PartListByIndex.remove(index);
    }
}

