/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.entity.vehicle.controls;

import com.flansmod.common.entity.vehicle.VehicleEntity;
import com.flansmod.common.entity.vehicle.controls.ControlLogic;
import com.flansmod.common.entity.vehicle.controls.VehicleInputState;
import com.flansmod.common.entity.vehicle.hierarchy.EPartDefComponent;
import com.flansmod.common.entity.vehicle.hierarchy.VehicleComponentPath;
import com.flansmod.common.entity.vehicle.hierarchy.VehiclePartPath;
import com.flansmod.common.entity.vehicle.save.VehiclePropellerSaveState;
import com.flansmod.common.types.parts.elements.EngineDefinition;
import com.flansmod.common.types.vehicles.ControlSchemeDefinition;
import com.flansmod.common.types.vehicles.VehicleDefinition;
import com.flansmod.common.types.vehicles.elements.EControlLogicHint;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.Transform;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class LegacyPlaneControlLogic
extends ControlLogic {
    private static final VehicleComponentPath SingleEngineKey = VehicleComponentPath.of(VehiclePartPath.Core, EPartDefComponent.Engine, 0);
    private static final VehicleComponentPath DefaultLeftWingDamageable = VehicleComponentPath.of(VehiclePartPath.of("left_wing"), EPartDefComponent.Damage, 0);
    private static final VehicleComponentPath DefaultRightWingDamageable = VehicleComponentPath.of(VehiclePartPath.of("right_wing"), EPartDefComponent.Damage, 0);
    private static final VehicleComponentPath DefaultTailDamageable = VehicleComponentPath.of(VehiclePartPath.of("tail"), EPartDefComponent.Damage, 0);
    private static final VehicleComponentPath DefaultBladesDamageable = VehicleComponentPath.of(VehiclePartPath.of("blades"), EPartDefComponent.Damage, 0);
    public final boolean Heli;
    public float flapsYaw;
    public float flapsPitchLeft;
    public float flapsPitchRight;
    public float propAngle;
    public float throttle;
    private static final float g = 0.098000005f;

    public LegacyPlaneControlLogic(@Nonnull ControlSchemeDefinition def, boolean heli) {
        super(def);
        this.Heli = heli;
    }

    @Override
    public boolean CanControl(@Nonnull VehicleDefinition vehicleDef) {
        return false;
    }

    @Override
    public void TickAuthoritative(@Nonnull VehicleEntity vehicle, @Nonnull VehicleInputState inputs) {
        this.TickShared(vehicle, inputs);
    }

    @Override
    public void TickRemote(@Nonnull VehicleEntity vehicle, @Nonnull VehicleInputState inputs) {
        this.TickShared(vehicle, inputs);
    }

    private void TickShared(@Nonnull VehicleEntity vehicle, @Nonnull VehicleInputState inputs) {
        Player player;
        LivingEntity livingEntity = vehicle.m_6688_();
        Player driver = livingEntity instanceof Player ? (player = (Player)livingEntity) : null;
        this.flapsYaw *= 0.9f;
        this.flapsPitchLeft *= 0.9f;
        this.flapsPitchRight *= 0.9f;
        this.flapsYaw = Maths.clamp(this.flapsYaw, -20.0f, 20.0f);
        this.flapsPitchLeft = Maths.clamp(this.flapsPitchLeft, -20.0f, 20.0f);
        this.flapsPitchRight = Maths.clamp(this.flapsPitchRight, -20.0f, 20.0f);
        float throttlePull = 0.99f;
        if (driver != null && this.Heli && vehicle.CanThrust(driver, SingleEngineKey)) {
            this.throttle = (this.throttle - 0.5f) * throttlePull + 0.5f;
        }
        float sensitivityAdjust = 2.006771f - (float)Math.exp(-2.0f * this.throttle) / (4.5f * (this.throttle + 0.1f));
        sensitivityAdjust = Maths.clamp(sensitivityAdjust, 0.0f, 1.0f);
        float yaw = this.flapsYaw * (sensitivityAdjust *= 0.125f);
        float flapsPitch = (this.flapsPitchLeft + this.flapsPitchRight) / 2.0f;
        float pitch = flapsPitch * sensitivityAdjust;
        float flapsRoll = (this.flapsPitchRight - this.flapsPitchLeft) / 2.0f;
        float roll = flapsRoll * sensitivityAdjust;
        if (!this.Heli) {
            if (vehicle.IsPartDestroyed(DefaultTailDamageable)) {
                yaw = 0.0f;
                pitch = 0.0f;
                roll = 0.0f;
            }
            if (vehicle.IsPartDestroyed(DefaultLeftWingDamageable)) {
                roll = (float)((double)roll - 7.0 * vehicle.GetSpeedXZ());
            }
            if (vehicle.IsPartDestroyed(DefaultRightWingDamageable)) {
                roll = (float)((double)roll + 7.0 * vehicle.GetSpeedXZ());
            }
        }
        vehicle.RotateYaw(yaw);
        vehicle.RotatePitch(pitch);
        vehicle.RotateRoll(-roll);
        float drag = 1.0f - 0.05f * vehicle.Def().physics.drag;
        float wobbleFactor = 0.0f;
        EngineDefinition engine = vehicle.GetEngineDef(SingleEngineKey);
        float throttleScaled = 0.01f * (vehicle.Def().physics.maxThrottle + engine.maxSpeed);
        if (!vehicle.CanThrust(driver, SingleEngineKey)) {
            throttleScaled = 0.0f;
        }
        boolean numPropsWorking = false;
        boolean numProps = false;
        if (this.Heli) {
            this.HeliPhysics(vehicle, throttleScaled, drag);
        } else {
            this.PlanePhysics(vehicle, throttleScaled, drag);
        }
    }

    private void HeliPhysics(@Nonnull VehicleEntity vehicle, float throttleScaled, float drag) {
        int numProps;
        Collection<VehiclePropellerSaveState> liftPropellers = vehicle.Propellers.ByHint(EControlLogicHint.LiftPropeller);
        Collection<VehiclePropellerSaveState> tailPropellers = vehicle.Propellers.ByHint(EControlLogicHint.TailPropeller);
        int numPropsWorking = numProps = liftPropellers.size();
        for (VehiclePropellerSaveState prop : liftPropellers) {
            if (!vehicle.IsPartDestroyed(VehicleComponentPath.of(prop.Def.attachedTo))) continue;
            --numPropsWorking;
        }
        Transform root = vehicle.getRootTransform().current();
        Vec3 up = root.up();
        float upwardsForce = this.throttle * (throttleScaled *= numProps == 0 ? 0.0f : (float)numPropsWorking / (float)numProps * 2.0f) + (0.098000005f - throttleScaled / 2.0f);
        if (this.throttle < 0.5f) {
            upwardsForce = 0.098000005f * this.throttle * 2.0f;
        }
        if (vehicle.IsPartDestroyed(DefaultBladesDamageable)) {
            upwardsForce = 0.0f;
        }
        Vec3 motion = vehicle.m_20184_();
        motion = motion.m_82520_((double)upwardsForce * up.f_82479_ * 0.5, (double)upwardsForce * up.f_82480_ - 0.09800000488758087, (double)upwardsForce * up.f_82481_ * 0.5);
        motion = motion.m_82490_((double)drag);
        vehicle.m_20256_(motion);
        vehicle.SetThrottle(SingleEngineKey, upwardsForce * 2.0f);
    }

    private void PlanePhysics(@Nonnull VehicleEntity vehicle, float throttleScaled, float drag) {
        float amountOfLift;
        int numProps;
        Collection<VehiclePropellerSaveState> forwardPropellers = vehicle.Propellers.ByHint(EControlLogicHint.ForwardPropeller);
        int numPropsWorking = numProps = forwardPropellers.size();
        for (VehiclePropellerSaveState prop : forwardPropellers) {
            if (!vehicle.IsPartDestroyed(VehicleComponentPath.of(prop.Def.attachedTo))) continue;
            --numPropsWorking;
        }
        float throttleTemp = this.throttle * (numProps == 0 ? 0.0f : (float)numPropsWorking / (float)numProps * 2.0f);
        Transform root = vehicle.getRootTransform().current();
        Vec3 forwards = root.forward();
        float lastTickSpeed = (float)vehicle.GetSpeed();
        if (lastTickSpeed > 2.0f) {
            lastTickSpeed = 2.0f;
        }
        float newSpeed = lastTickSpeed + throttleScaled * 2.0f;
        float proportionOfMotionToCorrect = 2.0f * throttleTemp - 0.5f;
        if (proportionOfMotionToCorrect < this.throttle * 0.25f) {
            proportionOfMotionToCorrect = this.throttle * 0.25f;
        }
        if (proportionOfMotionToCorrect > 0.6f) {
            proportionOfMotionToCorrect = 0.6f;
        }
        Vec3 motion = vehicle.m_20184_();
        motion = motion.m_82520_(0.0, -0.09800000488758087, 0.0);
        int numWingsIntact = 2;
        if (vehicle.IsPartDestroyed(DefaultRightWingDamageable)) {
            --numWingsIntact;
        }
        if (vehicle.IsPartDestroyed(DefaultLeftWingDamageable)) {
            --numWingsIntact;
        }
        if ((amountOfLift = 0.19600001f * throttleTemp * (float)numWingsIntact / 2.0f) > 0.098000005f) {
            amountOfLift = 0.098000005f;
        }
        if (vehicle.IsPartDestroyed(DefaultTailDamageable)) {
            amountOfLift *= 0.75f;
        }
        motion = motion.m_82520_(0.0, (double)amountOfLift, 0.0);
        motion = motion.m_82490_((double)(1.0f - proportionOfMotionToCorrect));
        motion = motion.m_82549_(forwards.m_82490_((double)(proportionOfMotionToCorrect * newSpeed)));
        motion = motion.m_82490_((double)drag);
        vehicle.m_20256_(motion);
        vehicle.SetThrottle(SingleEngineKey, Math.abs(this.throttle) * throttleScaled * 10.0f);
    }
}

