/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.entity.vehicle;

import com.flansmod.common.entity.vehicle.VehicleSubContainer;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class VehicleInventory
implements Container {
    @Nonnull
    public final VehicleSubContainer GunStacks;
    @Nonnull
    public final VehicleSubContainer AmmoStacks;
    @Nonnull
    public final VehicleSubContainer FuelStacks;

    public VehicleInventory(int numGuns, int numAmmos, int numFuels) {
        this.GunStacks = new VehicleSubContainer(VehicleSubContainer.EType.Gun, numGuns);
        this.AmmoStacks = new VehicleSubContainer(VehicleSubContainer.EType.Ammo, numAmmos);
        this.FuelStacks = new VehicleSubContainer(VehicleSubContainer.EType.Fuel, numFuels);
    }

    @Nonnull
    public List<VehicleSubContainer> AllSubContainers() {
        return List.of(this.GunStacks, this.AmmoStacks, this.FuelStacks);
    }

    @Nonnull
    public VehicleSubContainer GetGuns() {
        return this.GunStacks;
    }

    @Nonnull
    public VehicleSubContainer GetAmmos() {
        return this.AmmoStacks;
    }

    @Nonnull
    public VehicleSubContainer GetFuels() {
        return this.FuelStacks;
    }

    @Nonnull
    public VehicleSubContainer Get(@Nonnull VehicleSubContainer.EType slotType) {
        return switch (slotType) {
            default -> throw new IncompatibleClassChangeError();
            case VehicleSubContainer.EType.Gun -> this.GunStacks;
            case VehicleSubContainer.EType.Ammo -> this.AmmoStacks;
            case VehicleSubContainer.EType.Fuel -> this.FuelStacks;
        };
    }

    @Nonnull
    public Pair<VehicleSubContainer, Integer> ContainerIndexToSubIndex(int containerIndex) {
        for (VehicleSubContainer subContainer : this.AllSubContainers()) {
            if (containerIndex < subContainer.m_6643_()) {
                return Pair.of((Object)subContainer, (Object)containerIndex);
            }
            containerIndex -= this.GunStacks.m_6643_();
        }
        return Pair.of(null, (Object)-1);
    }

    public int SubIndexToContainer(@Nonnull VehicleSubContainer.EType slotType, int subIndex) {
        for (VehicleSubContainer subContainer : this.AllSubContainers()) {
            if (subContainer.Type == slotType) {
                return subIndex;
            }
            subIndex += subContainer.m_6643_();
        }
        return -1;
    }

    public int m_6643_() {
        return this.GunStacks.m_6643_() + this.AmmoStacks.m_6643_() + this.FuelStacks.m_6643_();
    }

    public boolean m_7983_() {
        for (VehicleSubContainer subContainer : this.AllSubContainers()) {
            if (subContainer.m_7983_()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public ItemStack m_8020_(int index) {
        Pair<VehicleSubContainer, Integer> kvp = this.ContainerIndexToSubIndex(index);
        if (kvp.getFirst() != null) {
            return ((VehicleSubContainer)kvp.getFirst()).m_8020_((Integer)kvp.getSecond());
        }
        return ItemStack.f_41583_;
    }

    @Nonnull
    public ItemStack m_7407_(int index, int count) {
        Pair<VehicleSubContainer, Integer> kvp = this.ContainerIndexToSubIndex(index);
        if (kvp.getFirst() != null) {
            return ((VehicleSubContainer)kvp.getFirst()).m_7407_((Integer)kvp.getSecond(), count);
        }
        return ItemStack.f_41583_;
    }

    @Nonnull
    public ItemStack m_8016_(int index) {
        Pair<VehicleSubContainer, Integer> kvp = this.ContainerIndexToSubIndex(index);
        if (kvp.getFirst() != null) {
            return ((VehicleSubContainer)kvp.getFirst()).m_8016_((Integer)kvp.getSecond());
        }
        return ItemStack.f_41583_;
    }

    public void m_6836_(int index, @Nonnull ItemStack stack) {
        Pair<VehicleSubContainer, Integer> kvp = this.ContainerIndexToSubIndex(index);
        if (kvp.getFirst() != null) {
            ((VehicleSubContainer)kvp.getFirst()).m_6836_((Integer)kvp.getSecond(), stack);
        }
    }

    public void m_6596_() {
        for (VehicleSubContainer subContainer : this.AllSubContainers()) {
            subContainer.m_6596_();
        }
    }

    public boolean m_6542_(@Nonnull Player player) {
        return true;
    }

    public void m_6211_() {
        for (VehicleSubContainer subContainer : this.AllSubContainers()) {
            subContainer.m_6211_();
        }
    }
}

