/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.crafting.menus;

import com.flansmod.common.FlansMod;
import com.flansmod.common.crafting.AbstractWorkbench;
import com.flansmod.common.crafting.menus.WorkbenchMenu;
import com.flansmod.common.crafting.recipes.GunFabricationRecipe;
import com.flansmod.common.crafting.slots.GunCraftingInputSlot;
import com.flansmod.common.crafting.slots.GunCraftingOutputSlot;
import com.flansmod.common.crafting.slots.RestrictedSlot;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class WorkbenchMenuGunCrafting
extends WorkbenchMenu {
    public static final int GUN_RECIPE_VIEWER_X_ORIGIN = 4;
    public static final int GUN_RECIPE_VIEWER_Y_ORIGIN = 64;
    public static final int GUN_RECIPE_VIEWER_COLUMNS = 6;
    public static final int GUN_RECIPE_VIEWER_ROWS = 1;
    public static final int BUTTON_SELECT_GUN_RECIPE_0 = 0;
    public static final int BUTTON_SELECT_GUN_RECIPE_MAX = 127;
    public static final int BUTTON_AUTO_FILL_INGREDIENT_0 = 128;
    public static final int BUTTON_AUTO_FULL_INGREDIENT_MAX = 255;
    public static final int BUTTON_SET_RECIPE_SCROLL_0 = 4096;
    public static final int BUTTON_SET_RECIPE_SCROLL_MAX = 4351;
    public final Container GunCraftingInputContainer;
    public final Container GunCraftingOutputContainer;
    protected GunCraftingInputSlot[] GunCraftingInputSlots;
    protected GunCraftingOutputSlot GunCraftingOutputSlot;

    public WorkbenchMenuGunCrafting(int containerID, @Nonnull Inventory inventory, @Nonnull AbstractWorkbench workbench) {
        super((MenuType<? extends WorkbenchMenu>)((MenuType)FlansMod.WORKBENCH_MENU_GUN_CRAFTING.get()), containerID, inventory, workbench);
        this.GunCraftingInputContainer = this.Workbench.GunCraftingInputContainer;
        this.GunCraftingOutputContainer = this.Workbench.GunCraftingOutputContainer;
        this.CreateSlots(inventory, 0);
    }

    public WorkbenchMenuGunCrafting(int containerID, @Nonnull Inventory inventory, @Nonnull FriendlyByteBuf data) {
        super((MenuType<? extends WorkbenchMenu>)((MenuType)FlansMod.WORKBENCH_MENU_GUN_CRAFTING.get()), containerID, inventory, data);
        this.GunCraftingInputContainer = this.Workbench.GunCraftingInputContainer;
        this.GunCraftingOutputContainer = this.Workbench.GunCraftingOutputContainer;
        this.CreateSlots(inventory, 0);
    }

    public boolean m_6366_(@Nonnull Player player, int buttonID) {
        if (buttonID < 0) {
            buttonID += 256;
        }
        if (4096 <= buttonID && buttonID <= 4351) {
            int scrollIndex = buttonID - 4096;
            if (scrollIndex != this.ScrollIndex) {
                this.ScrollIndex = scrollIndex;
                this.UpdateActiveSlots();
            }
            return true;
        }
        if (0 <= buttonID && buttonID <= 127) {
            this.Workbench.SelectGunCraftingRecipe(player.m_9236_(), buttonID - 0);
            this.UpdateActiveSlots();
            return true;
        }
        if (128 <= buttonID && buttonID <= 255) {
            int ingredientIndex = buttonID - 128;
            this.Workbench.AutoFillGunCraftingInputSlot(player, ingredientIndex);
            return true;
        }
        return false;
    }

    @Override
    protected void CreateSlots(@Nonnull Inventory playerInventory, int inventorySlotOffsetX) {
        super.CreateSlots(playerInventory, inventorySlotOffsetX);
        if (this.GunCraftingOutputContainer.m_6643_() > 0) {
            this.GunCraftingOutputSlot = new GunCraftingOutputSlot(this, this.GunCraftingOutputContainer, 0, 151, 73);
            this.m_38897_(this.GunCraftingOutputSlot);
        }
        this.GunCraftingInputSlots = new GunCraftingInputSlot[this.GunCraftingInputContainer.m_6643_()];
        if (this.GunCraftingInputContainer.m_6643_() > 0) {
            for (int i = 0; i < this.GunCraftingInputContainer.m_6643_(); ++i) {
                this.GunCraftingInputSlots[i] = new GunCraftingInputSlot(this, this.GunCraftingInputContainer, i, 78, 66);
                this.m_38897_(this.GunCraftingInputSlots[i]);
            }
        }
        this.UpdateActiveSlots();
    }

    private void UpdateActiveSlots() {
        for (int i = 0; i < this.GunCraftingInputSlots.length; ++i) {
            GunFabricationRecipe gunRecipe;
            boolean active = false;
            if (!this.GunCraftingInputSlots[i].m_7993_().m_41619_()) {
                active = true;
            }
            if ((gunRecipe = this.Workbench.GetSelectedGunRecipe(this.World)) != null && i < gunRecipe.InputIngredients.size()) {
                active = true;
            }
            GunCraftingInputSlot replacementSlot = new GunCraftingInputSlot(this, this.GunCraftingInputContainer, i, active ? 7 + 22 * (i % 6) : -1000, active ? 72 + 30 * (i / 6) : -1000);
            replacementSlot.f_40219_ = this.GunCraftingInputSlots[i].f_40219_;
            this.GunCraftingInputSlots[i].SetActive(false);
            this.f_38839_.set(replacementSlot.f_40219_, (Object)replacementSlot);
            this.GunCraftingInputSlots[i] = replacementSlot;
            this.GunCraftingInputSlots[i].SetActive(active);
        }
    }

    @Nonnull
    public ItemStack m_7648_(@Nonnull Player player, int slot) {
        if (this.GunCraftingOutputSlot != null && slot == this.GunCraftingOutputSlot.f_40219_) {
            return this.QuickStackIntoInventory(player, this.GunCraftingOutputSlot);
        }
        if (this.GunCraftingInputSlots != null && this.GunCraftingInputSlots.length > 0 && slot >= this.GunCraftingInputSlots[0].f_40219_ && slot < this.GunCraftingInputSlots[0].f_40219_ + this.GunCraftingInputSlots.length) {
            int craftingInputSlotIndex = slot - this.GunCraftingInputSlots[0].f_40219_;
            return this.QuickStackIntoInventory(player, this.GunCraftingInputSlots[craftingInputSlotIndex]);
        }
        ItemStack stack = ((Slot)this.f_38839_.get(slot)).m_7993_();
        for (GunCraftingInputSlot inputSlot : this.GunCraftingInputSlots) {
            if (!inputSlot.m_7993_().m_41619_() || !((RestrictedSlot)inputSlot).m_5857_(stack)) continue;
            inputSlot.m_5852_(stack);
            ((Slot)this.f_38839_.get(slot)).m_5852_(ItemStack.f_41583_);
            return ItemStack.f_41583_;
        }
        return ItemStack.f_41583_;
    }

    @Nullable
    public GunFabricationRecipe GetSelectedGunRecipe() {
        return this.Workbench.GetSelectedGunRecipe(this.World);
    }

    public void UpdateGunCraftingOutputSlot() {
        this.Workbench.UpdateGunCraftingOutputSlot(this.World);
    }

    public boolean IsGunCraftingFullyValid() {
        return this.Workbench.IsGunCraftingFullyValid(this.World);
    }

    public void ConsumeGunCraftingInputs() {
        this.Workbench.ConsumeGunCraftingInputs(this.World);
    }
}

