/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.crafting.menus;

import com.flansmod.client.FlansModClient;
import com.flansmod.common.FlansMod;
import com.flansmod.common.crafting.AbstractWorkbench;
import com.flansmod.common.crafting.WorkbenchBlockEntity;
import com.flansmod.common.crafting.slots.RestrictedSlot;
import com.flansmod.common.crafting.temporary.TemporaryWorkbench;
import com.flansmod.common.item.TemporaryWorkbenchItem;
import com.flansmod.common.types.crafting.WorkbenchDefinition;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class WorkbenchMenu
extends AbstractContainerMenu {
    @Nonnull
    public final WorkbenchDefinition Def;
    @Nonnull
    public final ContainerData WorkbenchData;
    @Nonnull
    public final AbstractWorkbench Workbench;
    @Nonnull
    public final Level World;
    private Slot[] InventorySlots;
    public int ScrollIndex = 0;

    public WorkbenchMenu(@Nonnull MenuType<? extends WorkbenchMenu> menuType, int containerID, @Nonnull Inventory inventory, @Nonnull AbstractWorkbench workbench) {
        super(menuType, containerID);
        this.World = inventory.f_35978_.m_9236_();
        this.Def = workbench.Def;
        this.Workbench = workbench;
        this.WorkbenchData = workbench.GetDataAccess();
    }

    @OnlyIn(value=Dist.CLIENT)
    public WorkbenchMenu(@Nonnull MenuType<? extends WorkbenchMenu> menuType, int containerID, @Nonnull Inventory inventory, @Nonnull FriendlyByteBuf data) {
        super(menuType, containerID);
        Item item;
        this.World = inventory.f_35978_.m_9236_();
        BlockPos blockPos = data.m_130135_();
        if (blockPos.equals((Object)BlockPos.f_121853_) && (item = inventory.f_35978_.m_21205_().m_41720_()) instanceof TemporaryWorkbenchItem) {
            TemporaryWorkbenchItem workbenchItem = (TemporaryWorkbenchItem)item;
            this.Def = (WorkbenchDefinition)FlansMod.WORKBENCHES.Get(workbenchItem.DefLoc);
            TemporaryWorkbench tempWorkbench = FlansModClient.INVENTORY_MANAGER.GetTemporaryInventory(workbenchItem.DefLoc);
            this.Workbench = tempWorkbench.Workbench;
            this.WorkbenchData = tempWorkbench.Workbench.GetDataAccess();
        } else {
            item = inventory.f_35978_.m_9236_().m_7702_(blockPos);
            if (item instanceof WorkbenchBlockEntity) {
                WorkbenchBlockEntity workbenchBlockEntity = (WorkbenchBlockEntity)item;
                this.Def = workbenchBlockEntity.Def;
                this.Workbench = workbenchBlockEntity.Workbench;
                this.WorkbenchData = workbenchBlockEntity.DataAccess;
            } else {
                FlansMod.LOGGER.error("Could not read GunModificationMenu data");
                this.Def = WorkbenchDefinition.INVALID;
                this.Workbench = null;
                this.WorkbenchData = null;
            }
        }
    }

    protected void CreateSlots(@Nonnull Inventory playerInventory, int inventorySlotOffsetX) {
        this.m_38884_(this.WorkbenchData);
        this.InventorySlots = new Slot[36];
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                RestrictedSlot restrictedSlot = new RestrictedSlot((Container)playerInventory, x + y * 9 + 9, inventorySlotOffsetX + 6 + x * 18, 137 + y * 18);
                this.InventorySlots[x + 9 * y + 9] = restrictedSlot;
                this.m_38897_(restrictedSlot);
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.InventorySlots[x] = new RestrictedSlot((Container)playerInventory, x, inventorySlotOffsetX + 6 + x * 18, 195);
            this.m_38897_(this.InventorySlots[x]);
        }
    }

    @Nonnull
    protected ItemStack QuickStackIntoInventory(@Nonnull Player player, @Nonnull Slot slot) {
        if (player.m_150109_().m_36054_(slot.m_7993_())) {
            slot.m_5852_(ItemStack.f_41583_);
            return ItemStack.f_41583_;
        }
        return slot.m_7993_();
    }

    public void m_6877_(@Nonnull Player player) {
        super.m_6877_(player);
        if (player.m_9236_().f_46443_) {
            this.ClientRemoved();
        } else {
            FlansMod.INVENTORY_MANAGER.CloseTemporaryInventory(player);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void ClientRemoved() {
        FlansModClient.INVENTORY_MANAGER.CloseTemporaryInventory();
    }

    public boolean m_6875_(@Nonnull Player player) {
        return true;
    }
}

