/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.crafting.ingredients;

import com.flansmod.common.crafting.ingredients.StackedIngredient;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;

public class StackedVanillaIngredient
extends StackedIngredient {
    public final ResourceLocation[] Items;
    public final List<TagKey<Item>> Tags;
    private ItemStack[] MatchingStacks = null;

    public StackedVanillaIngredient(ResourceLocation[] items, List<TagKey<Item>> tags, int count) {
        super(count);
        this.Items = items;
        this.Tags = tags;
    }

    public boolean isSimple() {
        return true;
    }

    public boolean m_43947_() {
        return this.m_43908_().length == 0;
    }

    @Nonnull
    public ItemStack[] m_43908_() {
        if (this.MatchingStacks == null) {
            ArrayList<ItemStack> matches = new ArrayList<ItemStack>();
            for (Item item : ForgeRegistries.ITEMS.getValues()) {
                boolean match = false;
                for (ResourceLocation itemLoc : this.Items) {
                    if (!item.m_204114_().m_203373_(itemLoc)) continue;
                    match = true;
                }
                for (TagKey tagKey : this.Tags) {
                    if (!item.m_204114_().m_203656_(tagKey)) continue;
                    match = true;
                }
                if (!match) continue;
                matches.add(new ItemStack((ItemLike)item, this.Count));
            }
            this.MatchingStacks = new ItemStack[matches.size()];
            matches.toArray(this.MatchingStacks);
        }
        return this.MatchingStacks;
    }

    @Override
    public int Count(@Nullable ItemStack target) {
        if (target == null) {
            return 0;
        }
        boolean value = false;
        for (ResourceLocation itemLoc : this.Items) {
            if (!target.m_41720_().m_204114_().m_203373_(itemLoc)) continue;
            return target.m_41613_();
        }
        for (TagKey tagKey : this.Tags) {
            if (!target.m_204117_(tagKey)) continue;
            return target.m_41613_();
        }
        return 0;
    }

    @Nonnull
    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        JsonArray itemArray = new JsonArray();
        for (ResourceLocation item : this.Items) {
            itemArray.add(item.toString());
        }
        json.add("items", (JsonElement)itemArray);
        JsonArray tagArray = new JsonArray();
        for (TagKey<Item> tag : this.Tags) {
            tagArray.add(tag.toString());
        }
        json.add("tags", (JsonElement)tagArray);
        json.addProperty("count", (Number)this.Count);
        return json;
    }

    @Nonnull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements IIngredientSerializer<StackedVanillaIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        @Nonnull
        public StackedVanillaIngredient parse(@Nonnull JsonObject json) {
            ResourceLocation[] items = new ResourceLocation[]{};
            if (json.has("items")) {
                JsonArray itemArray = GsonHelper.m_13933_((JsonObject)json, (String)"items");
                items = new ResourceLocation[itemArray.size()];
                for (int i = 0; i < itemArray.size(); ++i) {
                    items[i] = new ResourceLocation(itemArray.get(i).getAsString());
                }
            }
            ArrayList<TagKey<Item>> tags = new ArrayList<TagKey<Item>>();
            if (json.has("tags")) {
                JsonArray tagArray = GsonHelper.m_13933_((JsonObject)json, (String)"tags");
                for (int i = 0; i < tagArray.size(); ++i) {
                    tags.add((TagKey<Item>)TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(tagArray.get(i).getAsString())));
                }
            }
            int count = GsonHelper.m_13824_((JsonObject)json, (String)"count", (int)1);
            return new StackedVanillaIngredient(items, tags, count);
        }

        public void write(FriendlyByteBuf buffer, StackedVanillaIngredient ingredient) {
            int i;
            buffer.writeInt(ingredient.Items.length);
            for (i = 0; i < ingredient.Items.length; ++i) {
                buffer.m_130070_(ingredient.Items[i].toString());
            }
            buffer.writeInt(ingredient.Tags.size());
            for (i = 0; i < ingredient.Tags.size(); ++i) {
                buffer.m_130070_(ingredient.Tags.get(i).f_203868_().toString());
            }
            buffer.writeInt(ingredient.Count);
        }

        @Nonnull
        public StackedVanillaIngredient parse(FriendlyByteBuf buffer) {
            int itemCount = buffer.readInt();
            ResourceLocation[] items = new ResourceLocation[itemCount];
            for (int i = 0; i < itemCount; ++i) {
                items[i] = new ResourceLocation(buffer.m_130277_());
            }
            int tagCount = buffer.readInt();
            ArrayList<TagKey<Item>> tags = new ArrayList<TagKey<Item>>(tagCount);
            for (int i = 0; i < tagCount; ++i) {
                tags.add(TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(buffer.m_130277_())));
            }
            int count = buffer.readInt();
            return new StackedVanillaIngredient(items, tags, count);
        }
    }
}

