/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.crafting;

import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class RestrictedContainer
implements Container,
ContainerData {
    public final int SlotCount;
    public final Function<Player, Boolean> StillValidFunc;
    public final int MaxStackSize;
    public final Function<ItemStack, Boolean> AllowFunction;
    public final ItemStack[] Slots;

    public RestrictedContainer() {
        this(0, 0, stack -> false, player -> true);
    }

    public RestrictedContainer(@Nonnull BlockEntity parent) {
        this.StillValidFunc = player -> {
            if (parent.m_58901_() || parent.m_58904_().m_7702_(parent.m_58899_()) != parent) {
                return false;
            }
            return true;
        };
        this.AllowFunction = stack -> false;
        this.SlotCount = 0;
        this.MaxStackSize = 0;
        this.Slots = new ItemStack[0];
    }

    public RestrictedContainer(int slots, int maxStack, @Nonnull Function<ItemStack, Boolean> allowFunc, @Nonnull Function<Player, Boolean> stillValidFunc) {
        this.StillValidFunc = stillValidFunc;
        this.AllowFunction = allowFunc;
        this.SlotCount = slots;
        this.MaxStackSize = maxStack;
        this.Slots = new ItemStack[slots];
        for (int i = 0; i < this.SlotCount; ++i) {
            this.Slots[i] = ItemStack.f_41583_;
        }
    }

    public RestrictedContainer(int slots, int maxStack, @Nonnull Function<ItemStack, Boolean> allowFunc) {
        this(slots, maxStack, allowFunc, player -> true);
    }

    public int m_6413_(int index) {
        return index >= 0 && index < this.SlotCount ? this.Slots[index].m_41613_() : 0;
    }

    public void m_8050_(int index, int value) {
    }

    public int m_6499_() {
        return this.SlotCount;
    }

    public int m_6643_() {
        return this.SlotCount;
    }

    public int m_6893_() {
        return this.MaxStackSize;
    }

    public boolean m_7983_() {
        for (int i = 0; i < this.SlotCount; ++i) {
            if (this.Slots[i].m_41619_()) continue;
            return false;
        }
        return true;
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return stack.m_41619_() || this.AllowFunction.apply(stack) != false;
    }

    public ItemStack m_8020_(int index) {
        return index >= 0 && index < this.SlotCount ? this.Slots[index] : ItemStack.f_41583_;
    }

    public ItemStack m_7407_(int index, int count) {
        if (index >= 0 && index < this.SlotCount) {
            return this.Slots[index].m_41620_(count);
        }
        return ItemStack.f_41583_;
    }

    public ItemStack m_8016_(int index) {
        if (index >= 0 && index < this.SlotCount) {
            ItemStack ret = this.Slots[index];
            this.Slots[index] = ItemStack.f_41583_;
            return ret;
        }
        return ItemStack.f_41583_;
    }

    public void m_6836_(int index, ItemStack stack) {
        this.Slots[index] = stack;
    }

    public void m_6596_() {
    }

    public boolean m_6542_(@Nonnull Player player) {
        return this.StillValidFunc.apply(player);
    }

    public void m_6211_() {
        for (int i = 0; i < this.SlotCount; ++i) {
            this.Slots[i] = ItemStack.f_41583_;
        }
    }

    public CompoundTag save(CompoundTag tags) {
        for (int i = 0; i < this.SlotCount; ++i) {
            CompoundTag itemTag = new CompoundTag();
            this.Slots[i].m_41739_(itemTag);
            tags.m_128365_("slot" + i, (Tag)itemTag);
        }
        return tags;
    }

    public void load(CompoundTag tags) {
        for (int i = 0; i < this.SlotCount; ++i) {
            CompoundTag itemTag = tags.m_128469_("slot" + i);
            this.Slots[i] = itemTag.m_128456_() ? ItemStack.f_41583_ : ItemStack.m_41712_((CompoundTag)itemTag);
        }
    }
}

