/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.blocks;

import com.flansmod.common.FlansMod;
import com.flansmod.common.actions.ActionStack;
import com.flansmod.common.actions.contexts.GunContext;
import com.flansmod.common.actions.contexts.GunContextTileEntity;
import com.flansmod.common.actions.contexts.ShooterBlockEntity;
import com.flansmod.common.actions.contexts.ShooterContext;
import com.flansmod.common.actions.contexts.ShooterContextBlockEntity;
import com.flansmod.common.blocks.TurretBlock;
import com.flansmod.common.blocks.TurretContainerMenu;
import com.flansmod.common.item.GunItem;
import com.flansmod.common.types.blocks.TurretBlockDefinition;
import com.flansmod.common.types.elements.EPlayerInput;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.Transform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Clearable;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.registries.ForgeRegistries;

public class TurretBlockEntity
extends ShooterBlockEntity
implements WorldlyContainer,
MenuProvider,
Clearable,
ICapabilityProvider {
    @Nonnull
    public final TurretBlockDefinition Def;
    @Nonnull
    public ItemStack GunStack;
    @Nonnull
    public ActionStack Actions;
    @Nonnull
    public Map<EPlayerInput, Integer> InputHeldTicks = new HashMap<EPlayerInput, Integer>();
    @Nonnull
    public final ItemStack[] BulletStacks;
    private static final Component DISPLAY_NAME = Component.m_237115_((String)"turret.title");

    public TurretBlockEntity(@Nonnull ResourceLocation defLoc, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        super((BlockEntityType)ForgeRegistries.BLOCK_ENTITY_TYPES.getValue(defLoc), pos, state);
        this.Def = (TurretBlockDefinition)FlansMod.TURRETS.Get(defLoc);
        this.BulletStacks = new ItemStack[this.Def.ammoSlots.slots.length];
        Arrays.fill(this.BulletStacks, ItemStack.f_41583_);
        this.GunStack = ItemStack.f_41583_;
        this.Actions = ActionStack.Invalid;
    }

    @Override
    @Nonnull
    public UUID GetShooterID() {
        return ShooterContextBlockEntity.GenerateBlockEntityShooterID((ResourceKey<Level>)this.m_58904_().m_46472_(), this.m_58899_());
    }

    @Override
    public int GetNumValidContexts() {
        return 1;
    }

    @Override
    @Nonnull
    public UUID[] GetAllGunIDs() {
        return new UUID[]{this.GetGunID()};
    }

    @Override
    @Nonnull
    public UUID GetGunIDForSlot(int gunSlotIndex) {
        return gunSlotIndex == 0 ? this.GetGunID() : GunContext.INVALID.GetUUID();
    }

    @Override
    @Nonnull
    public GunContext CreateContext(@Nonnull UUID gunID) {
        ShooterContext shooterContext = this.GetShooterContext();
        if (shooterContext.IsValid() && shooterContext instanceof ShooterContextBlockEntity) {
            ShooterContextBlockEntity shooterContextBlockEntity = (ShooterContextBlockEntity)shooterContext;
            return new GunContextTileEntity(shooterContextBlockEntity, 0);
        }
        return GunContext.INVALID;
    }

    @Override
    @Nonnull
    public Transform GetShootOrigin(float deltaTick) {
        return Transform.fromPosAndQuat(this.m_58899_().m_252807_(), ((Direction)this.m_58900_().m_61143_((Property)TurretBlock.FACING)).m_253075_().rotateX(1.5707964f));
    }

    @Nonnull
    public UUID GetGunID() {
        return GunItem.GetGunID(this.GunStack);
    }

    @Nonnull
    public GunContext GetGunContext() {
        return this.CreateContext(this.GetGunID());
    }

    @Override
    @Nonnull
    public ActionStack GetActionStack(int gunSlotIndex) {
        if (!this.Actions.IsValid()) {
            this.OnGunStackChange();
        }
        return this.Actions;
    }

    @Nonnull
    public int[] m_7071_(@Nonnull Direction direction) {
        return new int[0];
    }

    public boolean m_7155_(int p_19235_, @Nonnull ItemStack stack, @Nullable Direction direction) {
        return false;
    }

    public boolean m_7157_(int p_19239_, @Nonnull ItemStack stack, @Nonnull Direction direction) {
        return false;
    }

    public int m_6643_() {
        return this.BulletStacks.length + 1;
    }

    public boolean m_7983_() {
        for (ItemStack stack : this.BulletStacks) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return this.GunStack.m_41619_();
    }

    public boolean m_6542_(@Nonnull Player player) {
        return true;
    }

    @Nonnull
    public ItemStack m_8020_(int slot) {
        if (slot == 0) {
            return this.GunStack;
        }
        if (0 <= slot - 1 && slot - 1 < this.BulletStacks.length) {
            return this.BulletStacks[slot - 1];
        }
        return ItemStack.f_41583_;
    }

    @Nonnull
    public ItemStack m_7407_(int slot, int count) {
        if (slot == 0) {
            ItemStack ret = this.GunStack.m_41620_(count);
            this.OnGunStackChange();
            return ret;
        }
        if (0 <= slot - 1 && slot - 1 < this.BulletStacks.length) {
            return this.BulletStacks[slot - 1].m_41620_(count);
        }
        return ItemStack.f_41583_;
    }

    @Nonnull
    public ItemStack m_8016_(int slot) {
        if (slot == 0) {
            ItemStack ret = this.GunStack;
            this.GunStack = ItemStack.f_41583_;
            this.OnGunStackChange();
            return ret;
        }
        if (0 <= slot - 1 && slot - 1 < this.BulletStacks.length) {
            ItemStack ret = this.BulletStacks[slot - 1];
            this.BulletStacks[slot - 1] = ItemStack.f_41583_;
            return ret;
        }
        return ItemStack.f_41583_;
    }

    public void m_6836_(int slot, @Nonnull ItemStack stack) {
        if (slot == 0) {
            this.GunStack = stack;
            this.OnGunStackChange();
        } else if (0 <= slot - 1 && slot - 1 < this.BulletStacks.length) {
            this.BulletStacks[slot - 1] = stack;
        }
    }

    public void m_6211_() {
        this.GunStack = ItemStack.f_41583_;
        Arrays.fill(this.BulletStacks, ItemStack.f_41583_);
        this.OnGunStackChange();
    }

    @Nonnull
    public ItemStack SwapGun(@Nonnull ItemStack gunStack) {
        ItemStack ret = this.GunStack;
        this.GunStack = gunStack;
        this.OnGunStackChange();
        return ret;
    }

    @Nonnull
    public ItemStack QuickStackBullets(@Nonnull ItemStack bulletStack) {
        for (int i = 0; i < this.BulletStacks.length; ++i) {
            if (this.BulletStacks[i].m_41619_()) {
                this.BulletStacks[i] = bulletStack;
                bulletStack = ItemStack.f_41583_;
            } else if (ItemStack.m_150942_((ItemStack)bulletStack, (ItemStack)this.BulletStacks[i])) {
                int count = Maths.min(bulletStack.m_41613_(), this.m_6893_() - this.BulletStacks[i].m_41613_());
                this.BulletStacks[i].m_41764_(this.BulletStacks[i].m_41613_() + count);
                bulletStack.m_41764_(bulletStack.m_41613_() - count);
            }
            if (bulletStack.m_41619_()) break;
        }
        return bulletStack;
    }

    @Nonnull
    public ItemStack TakeFirstStack() {
        if (!this.GunStack.m_41619_()) {
            return this.m_7407_(0, 1);
        }
        for (int i = 0; i < this.BulletStacks.length; ++i) {
            if (this.BulletStacks[i].m_41619_()) continue;
            return this.m_7407_(i + 1, this.BulletStacks[i].m_41613_());
        }
        return ItemStack.f_41583_;
    }

    private void OnGunStackChange() {
        this.Actions = new ActionStack(this.f_58857_.f_46443_);
        this.m_6596_();
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    @Nonnull
    public ShooterContext GetShooterContext() {
        return ShooterContext.of(this);
    }

    public void SetInputs(@Nonnull List<EPlayerInput> activeInputs) {
        for (EPlayerInput input : activeInputs) {
            if (!this.InputHeldTicks.containsKey((Object)input)) {
                this.InputHeldTicks.put(input, 1);
                this.SimulatePress(input);
                continue;
            }
            this.InputHeldTicks.put(input, this.InputHeldTicks.get((Object)input) + 1);
            this.SimulateHold(input);
        }
        ArrayList<EPlayerInput> deactivations = new ArrayList<EPlayerInput>(activeInputs.size());
        for (EPlayerInput input : this.InputHeldTicks.keySet()) {
            if (activeInputs.contains((Object)input)) continue;
            deactivations.add(input);
        }
        for (EPlayerInput deactivated : deactivations) {
            this.InputHeldTicks.remove((Object)deactivated);
            this.SimulateRelease(deactivated);
        }
    }

    private void SimulatePress(@Nonnull EPlayerInput inputType) {
        FlansMod.ACTIONS_SERVER.KeyPressed(this.GetShooterContext(), inputType);
    }

    private void SimulateHold(@Nonnull EPlayerInput inputType) {
    }

    private void SimulateRelease(@Nonnull EPlayerInput inputType) {
    }

    protected void m_183515_(@Nonnull CompoundTag tags) {
        super.m_183515_(tags);
        tags.m_128365_("gun", (Tag)this.GunStack.m_41739_(new CompoundTag()));
        for (int i = 0; i < this.BulletStacks.length; ++i) {
            tags.m_128365_("bullet_" + i, (Tag)this.BulletStacks[i].m_41739_(new CompoundTag()));
        }
    }

    protected void saveForClientUpdate(@Nonnull CompoundTag tags) {
        super.m_183515_(tags);
        tags.m_128365_("gun", (Tag)this.GunStack.m_41739_(new CompoundTag()));
    }

    public void m_142466_(@Nonnull CompoundTag tags) {
        super.m_142466_(tags);
        if (tags.m_128441_("gun")) {
            this.GunStack = ItemStack.m_41712_((CompoundTag)tags.m_128469_("gun"));
        }
        for (int i = 0; i < this.BulletStacks.length; ++i) {
            if (!tags.m_128441_("bullet_" + i)) continue;
            this.BulletStacks[i] = ItemStack.m_41712_((CompoundTag)tags.m_128469_("bullet_" + i));
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag tags = new CompoundTag();
        this.saveForClientUpdate(tags);
        return tags;
    }

    @Nonnull
    public Component m_5446_() {
        return DISPLAY_NAME;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerID, @Nonnull Inventory inventory, @Nonnull Player player) {
        return new TurretContainerMenu(containerID, inventory, this);
    }

    protected void ServerTick() {
        if (!this.Actions.IsValid()) {
            this.OnGunStackChange();
        }
        this.Actions.OnTick(this.f_58857_, this.GetGunContext());
    }

    protected void ClientTick() {
        if (!this.Actions.IsValid()) {
            this.OnGunStackChange();
        }
        this.Actions.OnTick(this.f_58857_, this.GetGunContext());
    }

    public static void ServerTurretTicker(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull TurretBlockEntity turret) {
        turret.ServerTick();
    }

    public static void ClientTurretTicker(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull TurretBlockEntity turret) {
        turret.ClientTick();
    }

    public static class TurretBlockEntityTypeHolder
    implements BlockEntityType.BlockEntitySupplier<TurretBlockEntity> {
        private final ResourceLocation DefLoc;

        public TurretBlockEntityTypeHolder(ResourceLocation defLoc) {
            this.DefLoc = defLoc;
        }

        @Nonnull
        public TurretBlockEntity create(@Nonnull BlockPos pos, @Nonnull BlockState state) {
            return new TurretBlockEntity(this.DefLoc, pos, state);
        }

        public BlockEntityType<TurretBlockEntity> CreateType() {
            return new BlockEntityType<TurretBlockEntity>((BlockEntityType.BlockEntitySupplier)this, Set.of(), null){

                public boolean m_155262_(@Nonnull BlockState state) {
                    return state.m_60734_() instanceof TurretBlock;
                }
            };
        }
    }
}

