/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.blocks;

import com.flansmod.common.FlansMod;
import com.flansmod.common.blocks.TurretBlockEntity;
import com.flansmod.common.types.LazyDefinition;
import com.flansmod.common.types.blocks.TurretBlockDefinition;
import com.flansmod.common.types.blocks.elements.RedstoneResponseDefinition;
import com.flansmod.common.types.blocks.elements.TurretSideDefinition;
import com.flansmod.common.types.elements.EPlayerInput;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

public class TurretBlock
extends BaseEntityBlock {
    protected static final VoxelShape DEFAULT_SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)15.0);
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final BooleanProperty TRIGGERED = BlockStateProperties.f_61360_;
    private static final int TRIGGER_DURATION = 4;
    @Nonnull
    public final LazyDefinition<TurretBlockDefinition> DefRef;

    @Nonnull
    public TurretBlockDefinition Def() {
        return (TurretBlockDefinition)this.DefRef.DefGetter().get();
    }

    public TurretBlock(@Nonnull ResourceLocation defLoc, @Nonnull BlockBehaviour.Properties props) {
        super(props);
        this.DefRef = LazyDefinition.of(defLoc, FlansMod.TURRETS);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public void m_6861_(@Nonnull BlockState blockState, @Nonnull Level level, @Nonnull BlockPos thisBlockPos, @Nonnull Block srcBlock, @Nonnull BlockPos srcBlockPos, boolean p_52705_) {
        TurretBlockDefinition def = this.Def();
        ArrayList<EPlayerInput> activeInputs = new ArrayList<EPlayerInput>();
        int indirectInput = level.m_277086_(thisBlockPos.m_7494_());
        for (Direction dir : Direction.values()) {
            TurretSideDefinition sideDef = def.GetSideDefinition(dir);
            for (RedstoneResponseDefinition response : sideDef.redstoneResponses) {
                int redstoneInput = level.m_277185_(thisBlockPos.m_121945_(dir), dir);
                if (response.minRedstoneLevel <= redstoneInput && redstoneInput <= response.maxRedstoneLevel) {
                    activeInputs.add(response.simulateInput);
                    continue;
                }
                if (!response.allowIndirectPower || response.minRedstoneLevel > indirectInput || indirectInput > response.maxRedstoneLevel) continue;
                activeInputs.add(response.simulateInput);
            }
        }
        boolean shouldBeActive = !activeInputs.isEmpty();
        boolean isActive = (Boolean)blockState.m_61143_((Property)TRIGGERED);
        if (shouldBeActive && !isActive) {
            level.m_186460_(thisBlockPos, (Block)this, 4);
            level.m_7731_(thisBlockPos, (BlockState)blockState.m_61124_((Property)TRIGGERED, (Comparable)Boolean.valueOf(true)), 4);
        } else if (!shouldBeActive && isActive) {
            level.m_7731_(thisBlockPos, (BlockState)blockState.m_61124_((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)), 4);
        }
        BlockEntity blockEntity = level.m_7702_(thisBlockPos);
        if (blockEntity instanceof TurretBlockEntity) {
            TurretBlockEntity turretBlockEntity = (TurretBlockEntity)blockEntity;
            turretBlockEntity.SetInputs(activeInputs);
        }
    }

    public MenuProvider m_7246_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos) {
        return new SimpleMenuProvider((containerID, inventory, playerEntity) -> {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof TurretBlockEntity) {
                TurretBlockEntity turretBlockEntity = (TurretBlockEntity)blockEntity;
                return turretBlockEntity.m_7208_(containerID, inventory, playerEntity);
            }
            return null;
        }, (Component)Component.m_237115_((String)"menu.title.flansmod.turret_menu"));
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!level.f_46443_ && blockEntity instanceof TurretBlockEntity) {
            TurretBlockEntity turretBlockEntity = (TurretBlockEntity)blockEntity;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)this.m_7246_(state, level, pos), (BlockPos)pos);
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    @Nullable
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        BlockEntityType type = (BlockEntityType)ForgeRegistries.BLOCK_ENTITY_TYPES.getValue(this.DefRef.Loc());
        if (type != null) {
            return type.m_155264_(pos, state);
        }
        return null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        return (level1, pos1, state1, blockEntity) -> {
            if (blockEntity instanceof TurretBlockEntity) {
                TurretBlockEntity turretBlockEntity = (TurretBlockEntity)blockEntity;
                if (level1.f_46443_) {
                    TurretBlockEntity.ClientTurretTicker(level1, pos1, state1, turretBlockEntity);
                } else {
                    TurretBlockEntity.ServerTurretTicker(level1, pos1, state1, turretBlockEntity);
                }
            }
        };
    }

    @Nonnull
    public BlockState m_6843_(@Nonnull BlockState src, @Nonnull Rotation rotation) {
        return (BlockState)src.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)src.m_61143_((Property)FACING)));
    }

    @Nonnull
    public BlockState m_6943_(@Nonnull BlockState src, @Nonnull Mirror mirror) {
        return src.m_60717_(mirror.m_54846_((Direction)src.m_61143_((Property)FACING)));
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, TRIGGERED});
    }

    public BlockState m_5573_(@Nonnull BlockPlaceContext context) {
        return (BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)TRIGGERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)this.Def().blockSettings.GetPlacementFacing(context.m_7820_()));
    }

    @Nonnull
    public RenderShape m_7514_(@Nonnull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter getter, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return this.Def().blockSettings.CreateVoxelShape();
    }
}

