/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.actions.stats;

import com.flansmod.common.FlansMod;
import com.flansmod.common.actions.stats.IStatCalculatorContext;
import com.flansmod.common.types.abilities.elements.EAccumulationSource;
import com.flansmod.util.formulae.FloatFormula;
import javax.annotation.Nonnull;

public class StatFormula
extends FloatFormula<EAccumulationSource> {
    public StatFormula AtLevel(int level) {
        this.BakeInput(EAccumulationSource.PerLevel, (float)level);
        return this;
    }

    public StatFormula WithStacks(int stackCount) {
        this.BakeInput(EAccumulationSource.PerStacks, (float)stackCount);
        return this;
    }

    public float Evaluate(@Nonnull IStatCalculatorContext ctx) {
        return this.Evaluate((Integer statIndex) -> {
            switch (EAccumulationSource.values()[statIndex]) {
                case PerLevel: 
                case PerStacks: {
                    FlansMod.LOGGER.error("Too late to bake in trait level or stack count");
                    return Float.valueOf(1.0f);
                }
                case PerAttachment: {
                    return Float.valueOf(ctx.GetNumAttachments());
                }
                case PerMagFullness: {
                    return Float.valueOf(ctx.GetMagFullness());
                }
                case PerMagEmptiness: {
                    return Float.valueOf(1.0f - ctx.GetMagFullness());
                }
            }
            FlansMod.LOGGER.error("I don't know what this input is");
            return Float.valueOf(0.0f);
        });
    }
}

