/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.actions.nodes;

import com.flansmod.common.FlansMod;
import com.flansmod.common.actions.ActionGroupInstance;
import com.flansmod.common.actions.ActionInstance;
import com.flansmod.common.actions.ActionStack;
import com.flansmod.common.actions.contexts.ActionGroupContext;
import com.flansmod.common.types.attachments.AttachmentDefinition;
import com.flansmod.common.types.guns.elements.ActionDefinition;
import com.flansmod.common.types.guns.elements.HandlerDefinition;
import com.flansmod.common.types.guns.elements.HandlerNodeDefinition;
import com.flansmod.common.types.guns.elements.ModeDefinition;
import javax.annotation.Nonnull;

public class SwitchModeAction
extends ActionInstance {
    public SwitchModeAction(@Nonnull ActionGroupInstance group, @Nonnull ActionDefinition def) {
        super(group, def);
    }

    @Override
    public void OnTriggerClient(int triggerIndex) {
        this.Trigger();
    }

    @Override
    public void OnTriggerServer(int triggerIndex) {
        this.Trigger();
    }

    private void Trigger() {
        String key = this.ModeKey();
        ModeDefinition modeDef = this.Group.Context.Gun.GetModeDef(key);
        if (modeDef != null) {
            if (this.CycleModes()) {
                String currentValue = this.Group.Context.Gun.GetModeValue(key);
                int currentIndex = -1;
                for (int i = 0; i < modeDef.values.length; ++i) {
                    if (!modeDef.values[i].equals(currentValue)) continue;
                    currentIndex = i;
                }
                int newModeIndex = currentIndex + 1;
                if (newModeIndex >= modeDef.values.length) {
                    newModeIndex = 0;
                }
                this.SelectMode(key, modeDef.values[newModeIndex]);
            } else {
                String selectMode = this.SelectValue();
                this.SelectMode(key, selectMode);
            }
        } else {
            FlansMod.LOGGER.error("Could not find mode " + key + " on gun " + this.Group.Context.Gun);
        }
    }

    private void SelectMode(String modeKey, String modeValue) {
        ActionStack actionStack = this.Group.Context.Gun.GetActionStack();
        for (HandlerDefinition handler : this.Group.Context.Gun.Def.inputHandlers) {
            for (HandlerNodeDefinition node : handler.nodes) {
                ActionGroupContext actionGroupContext;
                ActionGroupInstance actionGroupInstance;
                AttachmentDefinition attachmentDef;
                String modalCheckValue;
                if (!node.modalCheck.startsWith(modeKey)) continue;
                String string = modalCheckValue = node.modalCheck.contains(":") ? node.modalCheck.split(":")[1] : "on";
                if (modeValue.equals(modalCheckValue)) continue;
                String actionGroupPath = node.actionGroupToTrigger;
                if (node.deferToAttachment && (attachmentDef = this.Group.Context.Gun.GetAttachmentDefinition(node.attachmentType, node.attachmentIndex)).IsValid()) {
                    HandlerDefinition attachmentInputHandler = attachmentDef.GetInputHandler(handler.inputType);
                    for (HandlerNodeDefinition attachmentInputNode : attachmentInputHandler.nodes) {
                        actionGroupPath = ActionGroupContext.CreateGroupPath(node.attachmentType, node.attachmentIndex, attachmentInputNode.actionGroupToTrigger);
                    }
                }
                if ((actionGroupInstance = actionStack.TryGetGroupInstance(actionGroupContext = this.Group.Context.Gun.GetActionGroupContext(actionGroupPath))) == null) continue;
                actionGroupInstance.SetFinished();
            }
        }
        this.Group.Context.Gun.SetModeValue(modeKey, modeValue);
    }

    public String ModeKey() {
        return this.Group.Context.ModifyString("mode", "mode");
    }

    public String SelectValue() {
        return this.Group.Context.ModifyString("set_value", "");
    }

    public boolean CycleModes() {
        return this.SelectValue().isEmpty();
    }
}

