/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.actions.contexts;

import com.flansmod.common.actions.contexts.ActionGroupContext;
import com.flansmod.common.actions.contexts.GunContext;
import com.flansmod.common.actions.contexts.ShooterContext;
import com.flansmod.common.types.abilities.elements.AbilityTargetDefinition;
import com.flansmod.common.types.abilities.elements.EAbilityTarget;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class TriggerContext {
    @Nullable
    public final Entity Shooter;
    @Nullable
    public final Entity Owner;
    @Nullable
    public final HitResult Hit;
    @Nullable
    public final String ActionGroupPath;
    @Nullable
    public final Collection<Entity> SplashedEntities;

    private TriggerContext() {
        this.Shooter = null;
        this.Owner = null;
        this.Hit = null;
        this.SplashedEntities = null;
        this.ActionGroupPath = null;
    }

    private TriggerContext(@Nullable Entity owner, @Nullable Entity shooter, @Nullable HitResult hit, @Nullable Collection<Entity> splashes, @Nullable String actionGroupPath) {
        this.Shooter = shooter;
        this.Owner = owner;
        this.Hit = hit;
        this.SplashedEntities = splashes;
        this.ActionGroupPath = actionGroupPath;
    }

    public static TriggerContext empty() {
        return new TriggerContext(null, null, null, null, null);
    }

    public static TriggerContext self(@Nonnull ActionGroupContext actionGroup) {
        return new TriggerContext(actionGroup.Gun.GetShooter().Owner(), actionGroup.Gun.GetShooter().Entity(), null, null, actionGroup.GroupPath);
    }

    public static TriggerContext self(@Nonnull GunContext gun) {
        return new TriggerContext(gun.GetShooter().Owner(), gun.GetShooter().Entity(), null, null, null);
    }

    public static TriggerContext self(@Nonnull ShooterContext shooter) {
        return new TriggerContext(shooter.Owner(), shooter.Entity(), null, null, null);
    }

    public static TriggerContext self(@Nonnull Entity entity) {
        return new TriggerContext(entity, entity, null, null, null);
    }

    public static TriggerContext hit(@Nonnull ShooterContext from, @Nonnull HitResult hit) {
        return new TriggerContext(from.Owner(), from.Entity(), hit, null, null);
    }

    public static TriggerContext hitWithSplash(@Nonnull ActionGroupContext from, @Nonnull HitResult hit, @Nonnull Collection<Entity> splashes) {
        return new TriggerContext(from.Gun.GetShooter().Owner(), from.Gun.GetShooter().Entity(), hit, splashes, from.GroupPath);
    }

    public static TriggerContext hitWithSplash(@Nonnull GunContext from, @Nonnull HitResult hit, @Nonnull Collection<Entity> splashes) {
        return new TriggerContext(from.GetShooter().Owner(), from.GetShooter().Entity(), hit, splashes, null);
    }

    public static TriggerContext hitWithSplash(@Nonnull ShooterContext from, @Nonnull HitResult hit, @Nonnull Collection<Entity> splashes) {
        return new TriggerContext(from.Owner(), from.Entity(), hit, splashes, null);
    }

    public boolean CanTriggerFor(@Nonnull EAbilityTarget targetType) {
        switch (targetType) {
            case Shooter: {
                return this.Shooter != null;
            }
            case Owner: {
                return this.Owner != null;
            }
            case ShotEntity: {
                return this.Hit != null && this.Hit.m_6662_() == HitResult.Type.ENTITY;
            }
            case ShotBlock: {
                return this.Hit != null && this.Hit.m_6662_() == HitResult.Type.BLOCK;
            }
            case ShotPosition: {
                return this.Hit != null;
            }
            case SplashedEntities: {
                return this.SplashedEntities != null && this.SplashedEntities.size() > 0;
            }
        }
        return true;
    }

    public boolean CanTriggerFor(@Nonnull AbilityTargetDefinition[] targetTypes) {
        block8: for (AbilityTargetDefinition targetDef : targetTypes) {
            switch (targetDef.targetType) {
                case Shooter: {
                    if (this.Shooter == null) continue block8;
                    return true;
                }
                case Owner: {
                    if (this.Owner == null) continue block8;
                    return true;
                }
                case ShotEntity: {
                    if (this.Hit == null || this.Hit.m_6662_() != HitResult.Type.ENTITY) continue block8;
                    return true;
                }
                case ShotBlock: {
                    if (this.Hit == null || this.Hit.m_6662_() != HitResult.Type.BLOCK) continue block8;
                    return true;
                }
                case ShotPosition: {
                    if (this.Hit == null) continue block8;
                    return true;
                }
                case SplashedEntities: {
                    if (this.SplashedEntities == null || this.SplashedEntities.size() <= 0) continue block8;
                    return true;
                }
            }
        }
        return false;
    }

    public void TriggerOnEntities(@Nonnull AbilityTargetDefinition[] targetTypes, @Nonnull Consumer<Entity> func) {
        if (AbilityTargetDefinition.Matches(targetTypes, EAbilityTarget.Shooter, this) && this.Shooter != null) {
            func.accept(this.Shooter);
        }
        if (AbilityTargetDefinition.Matches(targetTypes, EAbilityTarget.Owner, this) && this.Owner != null) {
            func.accept(this.Owner);
        }
        if (AbilityTargetDefinition.Matches(targetTypes, EAbilityTarget.ShotEntity, this) && this.Hit != null && this.Hit.m_6662_() == HitResult.Type.ENTITY) {
            func.accept(((EntityHitResult)this.Hit).m_82443_());
        }
        if (AbilityTargetDefinition.Matches(targetTypes, EAbilityTarget.SplashedEntities, this) && this.SplashedEntities != null) {
            for (Entity ent : this.SplashedEntities) {
                func.accept(ent);
            }
        }
    }

    public void TriggerOnBlocks(@Nonnull AbilityTargetDefinition[] targetTypes, @Nonnull BiConsumer<BlockPos, BlockState> func) {
        HitResult hitResult;
        if (AbilityTargetDefinition.Matches(targetTypes, EAbilityTarget.ShotBlock, this) && this.Hit != null && (hitResult = this.Hit) instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            if (this.Shooter != null) {
                func.accept(blockHitResult.m_82425_(), this.Shooter.m_9236_().m_8055_(blockHitResult.m_82425_()));
            }
        }
    }

    public void TriggerOnPositions(@Nonnull AbilityTargetDefinition[] targetTypes, @Nonnull Consumer<Vec3> func) {
        if (AbilityTargetDefinition.Matches(targetTypes, EAbilityTarget.Shooter, this) && this.Shooter != null) {
            func.accept(this.Shooter.m_20182_());
        }
        if (AbilityTargetDefinition.Matches(targetTypes, EAbilityTarget.Owner, this) && this.Owner != null) {
            func.accept(this.Owner.m_20182_());
        }
        if (this.Hit != null && (AbilityTargetDefinition.Matches(targetTypes, EAbilityTarget.ShotEntity, this) || AbilityTargetDefinition.Matches(targetTypes, EAbilityTarget.ShotBlock, this) || AbilityTargetDefinition.Matches(targetTypes, EAbilityTarget.ShotPosition, this))) {
            func.accept(this.Hit.m_82450_());
        }
        if (AbilityTargetDefinition.Matches(targetTypes, EAbilityTarget.SplashedEntities, this) && this.SplashedEntities != null) {
            for (Entity ent : this.SplashedEntities) {
                func.accept(ent.m_20182_());
            }
        }
    }
}

