/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.actions.contexts;

import com.flansmod.common.actions.contexts.GunContext;
import com.flansmod.common.actions.contexts.ShooterContext;
import com.flansmod.common.actions.contexts.TriggerContext;
import com.flansmod.common.types.abilities.elements.EAbilityTarget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class TargetsContext {
    @Nonnull
    public final Map<BlockPos, BlockState> BlockTargets = new HashMap<BlockPos, BlockState>();
    @Nonnull
    public final List<Entity> EntityTargets = new ArrayList<Entity>();
    @Nonnull
    public final List<Vec3> PositionTargets = new ArrayList<Vec3>();

    @Nonnull
    public static TargetsContext of(@Nonnull TriggerContext triggerContext, @Nonnull EAbilityTarget targetType) {
        TargetsContext targetsContext = new TargetsContext();
        switch (targetType) {
            case Owner: {
                targetsContext.Add(triggerContext.Owner);
                break;
            }
            case Shooter: {
                targetsContext.Add(triggerContext.Shooter);
                break;
            }
            case ShotEntity: {
                HitResult hitResult = triggerContext.Hit;
                if (!(hitResult instanceof EntityHitResult)) break;
                EntityHitResult entHitResult = (EntityHitResult)hitResult;
                targetsContext.Add(entHitResult.m_82443_());
                break;
            }
            case ShotBlock: {
                HitResult hitResult;
                Level level;
                Level level2 = level = triggerContext.Shooter != null ? triggerContext.Shooter.m_9236_() : null;
                if (level == null || !((hitResult = triggerContext.Hit) instanceof BlockHitResult)) break;
                BlockHitResult blockHitResult = (BlockHitResult)hitResult;
                targetsContext.Add(blockHitResult.m_82425_(), level.m_8055_(blockHitResult.m_82425_()));
                break;
            }
            case ShotPosition: {
                if (triggerContext.Hit == null) break;
                targetsContext.Add(triggerContext.Hit.m_82450_());
                break;
            }
            case SplashedEntities: {
                if (triggerContext.SplashedEntities == null) break;
                for (Entity entity : triggerContext.SplashedEntities) {
                    targetsContext.Add(entity);
                }
                break;
            }
        }
        return targetsContext;
    }

    public boolean IsEmpty() {
        return this.BlockTargets.isEmpty() && this.EntityTargets.isEmpty() && this.PositionTargets.isEmpty();
    }

    public TargetsContext With(@Nullable Entity entity) {
        this.Add(entity);
        return this;
    }

    public TargetsContext With(@Nullable Vec3 pos) {
        this.Add(pos);
        return this;
    }

    public TargetsContext With(@Nullable BlockPos pos, @Nullable BlockState state) {
        this.Add(pos, state);
        return this;
    }

    public TargetsContext Add(@Nullable Entity entity) {
        if (entity != null && !this.EntityTargets.contains(entity)) {
            this.EntityTargets.add(entity);
        }
        return this;
    }

    public TargetsContext Add(@Nullable Vec3 pos) {
        if (pos != null) {
            this.PositionTargets.add(pos);
        }
        return this;
    }

    public TargetsContext Add(@Nullable BlockPos pos, @Nullable BlockState state) {
        if (pos != null && state != null && !this.BlockTargets.containsKey(pos)) {
            this.BlockTargets.put(pos, state);
        }
        return this;
    }

    public void ForEachShooter(@Nonnull Consumer<ShooterContext> func) {
        for (Entity entity : this.EntityTargets) {
            ShooterContext shooterContext = ShooterContext.of(entity);
            if (!shooterContext.IsValid()) continue;
            func.accept(shooterContext);
        }
    }

    public void ForEachGun(@Nonnull Consumer<GunContext> func) {
        for (Entity entity : this.EntityTargets) {
            ShooterContext shooterContext = ShooterContext.of(entity);
            if (!shooterContext.IsValid()) continue;
            for (GunContext gunContext : shooterContext.GetAllGunContexts()) {
                func.accept(gunContext);
            }
        }
    }

    public void ForEachEntity(@Nonnull Consumer<Entity> func) {
        for (Entity entity : this.EntityTargets) {
            func.accept(entity);
        }
    }

    public void ForEachBlock(@Nonnull BiConsumer<BlockPos, BlockState> func) {
        for (Map.Entry<BlockPos, BlockState> kvp : this.BlockTargets.entrySet()) {
            func.accept(kvp.getKey(), kvp.getValue());
        }
    }

    public void ForOnePosition(@Nonnull Consumer<Vec3> func) {
        Iterator<Object> iterator = this.EntityTargets.iterator();
        if (iterator.hasNext()) {
            Entity entity = iterator.next();
            func.accept(entity.m_20182_());
            return;
        }
        iterator = this.BlockTargets.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry kvp = (Map.Entry)iterator.next();
            func.accept(((BlockPos)kvp.getKey()).m_252807_());
            return;
        }
        iterator = this.PositionTargets.iterator();
        if (iterator.hasNext()) {
            Vec3 pos = (Vec3)iterator.next();
            func.accept(pos);
            return;
        }
    }

    public void ForEachPosition(@Nonnull Consumer<Vec3> func) {
        for (Entity entity : this.EntityTargets) {
            func.accept(entity.m_20182_());
        }
        for (Map.Entry entry : this.BlockTargets.entrySet()) {
            func.accept(((BlockPos)entry.getKey()).m_252807_());
        }
        for (Vec3 vec3 : this.PositionTargets) {
            func.accept(vec3);
        }
    }
}

