/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.actions.contexts;

import com.flansmod.common.abilities.AbilityStack;
import com.flansmod.common.actions.contexts.GunContext;
import com.flansmod.common.actions.contexts.GunContextLiving;
import com.flansmod.common.actions.contexts.ShooterContext;
import com.flansmod.common.actions.stats.IModifierBaker;
import com.flansmod.common.effects.FlansMobEffect;
import com.flansmod.common.item.FlanItem;
import com.flansmod.common.types.abilities.elements.AbilityEffectDefinition;
import com.flansmod.common.types.elements.ModifierDefinition;
import com.flansmod.common.types.guns.elements.AbilityDefinition;
import com.flansmod.physics.common.util.Transform;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ShooterContextLiving
extends ShooterContext
implements Container {
    @Nonnull
    protected final LivingEntity Shooter;

    public ShooterContextLiving(@Nonnull LivingEntity living) {
        this.Shooter = living;
    }

    @Override
    public int GetNumValidContexts() {
        return (this.GetMainHandGunID() != FlanItem.InvalidGunUUID ? 1 : 0) + (this.GetOffHandGunID() != FlanItem.InvalidGunUUID ? 1 : 0);
    }

    @Nonnull
    public GunContext GetGunContextForSlot(InteractionHand hand, boolean client) {
        UUID gunID = this.GetGunID(hand);
        if (gunID != FlanItem.InvalidGunUUID) {
            return GunContext.of((ShooterContext)this, gunID);
        }
        return GunContext.INVALID;
    }

    @Override
    @Nonnull
    public UUID ShooterID() {
        return this.EntityUUID();
    }

    @Override
    @Nonnull
    public UUID[] GetAllGunIDs() {
        return new UUID[]{this.GetMainHandGunID(), this.GetOffHandGunID()};
    }

    @Override
    @Nonnull
    public UUID GetGunIDForSlot(int gunSlotIndex) {
        return this.GetGunID(gunSlotIndex == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
    }

    @Nonnull
    public UUID GetMainHandGunID() {
        return this.GetGunID(InteractionHand.MAIN_HAND);
    }

    @Nonnull
    public UUID GetOffHandGunID() {
        return this.GetGunID(InteractionHand.OFF_HAND);
    }

    @Nonnull
    public UUID GetGunID(@Nonnull InteractionHand hand) {
        ItemStack handStack = this.Shooter.m_21120_(hand);
        return FlanItem.GetGunID(handStack);
    }

    @Override
    @Nonnull
    public GunContext CreateContext(@Nonnull UUID gunID) {
        if (gunID.equals(this.GetMainHandGunID())) {
            return new GunContextLiving(this, InteractionHand.MAIN_HAND);
        }
        if (gunID.equals(this.GetOffHandGunID())) {
            return new GunContextLiving(this, InteractionHand.OFF_HAND);
        }
        return GunContext.INVALID;
    }

    public boolean CanPerformTwoHandedAction() {
        return this.Shooter.m_21120_(InteractionHand.MAIN_HAND).m_41619_() != this.Shooter.m_21120_(InteractionHand.OFF_HAND).m_41619_();
    }

    @Override
    @Nonnull
    public Transform GetShootOrigin(float deltaTick) {
        return Transform.fromPosAndEuler(this.Shooter.m_20299_(deltaTick), this.Shooter.m_5686_(deltaTick), 180.0f + this.Shooter.m_5675_(deltaTick), 0.0f);
    }

    @Override
    public boolean IsValid() {
        return !this.Shooter.m_213877_();
    }

    @Override
    public boolean IsCreative() {
        return false;
    }

    @Override
    public Container GetAttachedInventory() {
        return this;
    }

    @Override
    public Entity Entity() {
        return this.Shooter;
    }

    @Override
    public Entity Owner() {
        return this.Shooter;
    }

    @Override
    public void BakeModifiers(@Nonnull IModifierBaker baker) {
        this.CacheSlot(EquipmentSlot.HEAD);
        this.CacheSlot(EquipmentSlot.CHEST);
        this.CacheSlot(EquipmentSlot.LEGS);
        this.CacheSlot(EquipmentSlot.FEET);
        this.BakeMobEffects(baker);
    }

    private void CacheSlot(EquipmentSlot slot) {
        Item item = this.Shooter.m_6844_(EquipmentSlot.HEAD).m_41720_();
        if (item instanceof FlanItem) {
            FlanItem flanItem = (FlanItem)item;
        }
    }

    private void BakeMobEffects(@Nonnull IModifierBaker baker) {
        for (MobEffectInstance effect : this.Shooter.m_21220_()) {
            AbilityDefinition[] abilityDefinitionArray = effect.m_19544_();
            if (!(abilityDefinitionArray instanceof FlansMobEffect)) continue;
            FlansMobEffect flansEffect = (FlansMobEffect)abilityDefinitionArray;
            for (AbilityDefinition abilityDef : flansEffect.Def().abilities) {
                for (AbilityEffectDefinition effectDef : abilityDef.effects) {
                    for (ModifierDefinition modifierDef : effectDef.modifiers) {
                        int traitLevel = 1;
                        int stackCount = 0;
                        if (abilityDef.IsStackable()) {
                            for (GunContext gunContext : this.GetAllGunContexts()) {
                                AbilityStack stacks = gunContext.GetActionStack().GetStacks(abilityDef.stacking);
                                if (stacks == null) continue;
                                traitLevel = stacks.Level;
                                stackCount = stacks.GetStackCount();
                            }
                        }
                        baker.Bake(modifierDef, traitLevel, stackCount);
                    }
                }
            }
        }
    }

    public int m_6643_() {
        return 6;
    }

    public boolean m_7983_() {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (this.Shooter.m_6844_(slot).m_41619_()) continue;
            return false;
        }
        return true;
    }

    private EquipmentSlot GetSlot(int slotIndex) {
        if (slotIndex >= 2) {
            return EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)(slotIndex - 2));
        }
        return EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.HAND, (int)slotIndex);
    }

    @Nonnull
    public ItemStack m_8020_(int slotIndex) {
        return this.Shooter.m_6844_(this.GetSlot(slotIndex));
    }

    @Nonnull
    public ItemStack m_7407_(int slotIndex, int count) {
        ItemStack stack = this.Shooter.m_6844_(this.GetSlot(slotIndex));
        stack.m_41764_(stack.m_41613_() - count);
        return stack.m_255036_(count);
    }

    @Nonnull
    public ItemStack m_8016_(int slotIndex) {
        ItemStack stack = this.Shooter.m_6844_(this.GetSlot(slotIndex));
        this.Shooter.m_8061_(this.GetSlot(slotIndex), ItemStack.f_41583_);
        return stack;
    }

    public void m_6836_(int slotIndex, @Nonnull ItemStack stack) {
        this.Shooter.m_8061_(this.GetSlot(slotIndex), stack);
    }

    public void m_6596_() {
    }

    public boolean m_6542_(@Nonnull Player player) {
        return true;
    }

    public void m_6211_() {
    }

    @Override
    public String toString() {
        return "Living:'" + this.Shooter.m_7755_().getString() + "'['" + this.Dimension().m_135782_().m_135815_() + "']";
    }
}

