/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.actions.contexts;

import com.flansmod.common.actions.contexts.ContextHistory;
import com.flansmod.common.actions.contexts.ShooterBlockEntity;
import com.flansmod.common.actions.contexts.ShooterContext;
import com.flansmod.common.actions.contexts.ShooterContextBlockEntity;
import com.flansmod.common.actions.contexts.ShooterContextLiving;
import com.flansmod.common.actions.contexts.ShooterContextPlayer;
import com.flansmod.common.actions.contexts.ShooterContextUnresolvedEntity;
import com.flansmod.common.actions.contexts.ShooterContextVehicleRoot;
import com.flansmod.common.entity.vehicle.VehicleEntity;
import com.flansmod.physics.common.util.MinecraftHelpers;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.NonNullSupplier;

public class ShooterContextHistory
extends ContextHistory<ShooterContext> {
    public static final ShooterContextHistory INVALID = new ShooterContextHistory(ShooterContext.INVALID.EntityUUID()){

        @Override
        @Nonnull
        public ShooterContext GetOrCreate(@Nonnull Function<ShooterContext, Boolean> validatorFunc, @Nonnull NonNullSupplier<ShooterContext> creatorFunc, @Nonnull NonNullSupplier<Long> timeFunc) {
            return ShooterContext.INVALID;
        }
    };

    public ShooterContextHistory(@Nonnull UUID id) {
        super(id);
    }

    @Nonnull
    public ShooterContext ContextualizeWith(@Nonnull UUID ownerUUID, @Nonnull UUID shooterUUID, @Nullable Level checkLevel, @Nonnull Function<UUID, Entity> entityResolveFunc, @Nonnull Function<UUID, Optional<ShooterBlockEntity>> blockEntityResolveFunc) {
        return this.GetOrCreate(check -> check.ShooterID().equals(shooterUUID) && check.OwnerUUID().equals(ownerUUID) && (checkLevel == null || check.Level() == checkLevel), () -> this.CreateFor(ownerUUID, shooterUUID, entityResolveFunc, blockEntityResolveFunc), (NonNullSupplier<Long>)((NonNullSupplier)MinecraftHelpers::getTick));
    }

    @Nonnull
    public ShooterContext ContextualizeWith(@Nonnull UUID ownerUUID, @Nonnull UUID shooterUUID, @Nullable Level checkLevel) {
        return this.GetOrCreate(check -> check.ShooterID().equals(shooterUUID) && check.OwnerUUID().equals(ownerUUID) && (checkLevel == null || check.Level() == checkLevel), () -> new ShooterContextUnresolvedEntity(ownerUUID, shooterUUID, MinecraftHelpers.getLogicalSide()), (NonNullSupplier<Long>)((NonNullSupplier)MinecraftHelpers::getTick));
    }

    @Nonnull
    public ShooterContext ContextualizeWith(@Nonnull Entity entityShooter) {
        if (entityShooter instanceof LivingEntity) {
            LivingEntity livingShooter = (LivingEntity)entityShooter;
            if (entityShooter instanceof Player) {
                Player playerShooter = (Player)entityShooter;
                return this.ContextualizeWith(playerShooter);
            }
            return this.ContextualizeWith(livingShooter);
        }
        return this.ContextualizeWith(entityShooter.m_20148_(), entityShooter.m_20148_(), entityShooter.m_9236_());
    }

    @Nonnull
    public ShooterContext ContextualizeWith(@Nonnull LivingEntity livingShooter) {
        return this.GetOrCreate(check -> check.Entity() == livingShooter, () -> new ShooterContextLiving(livingShooter), (NonNullSupplier<Long>)((NonNullSupplier)MinecraftHelpers::getTick));
    }

    @Nonnull
    public ShooterContext ContextualizeWith(@Nonnull ShooterBlockEntity blockShooter) {
        return this.GetOrCreate(check -> {
            ShooterContextBlockEntity shooterBE;
            return check instanceof ShooterContextBlockEntity && (shooterBE = (ShooterContextBlockEntity)check).GetBlockEntity().equals(Optional.of(blockShooter));
        }, () -> new ShooterContextBlockEntity(blockShooter), (NonNullSupplier<Long>)((NonNullSupplier)MinecraftHelpers::getTick));
    }

    @Nonnull
    public ShooterContext ContextualizeWith(@Nonnull Player playerShooter) {
        return this.GetOrCreate(check -> check.Entity() == playerShooter, () -> new ShooterContextPlayer(playerShooter), (NonNullSupplier<Long>)((NonNullSupplier)MinecraftHelpers::getTick));
    }

    @Nonnull
    private ShooterContext CreateFor(@Nonnull UUID ownerUUID, @Nonnull UUID shooterUUID, @Nonnull Function<UUID, Entity> entityResolveFunc, @Nonnull Function<UUID, Optional<ShooterBlockEntity>> blockEntityResolveFunc) {
        Optional<ShooterBlockEntity> blockEntity;
        Entity shooter = entityResolveFunc.apply(shooterUUID);
        if (shooter != null) {
            if (shooter instanceof Player) {
                Player player = (Player)shooter;
                return new ShooterContextPlayer(player);
            }
            if (shooter instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)shooter;
                return new ShooterContextLiving(living);
            }
            if (shooter instanceof VehicleEntity) {
                VehicleEntity vehicle = (VehicleEntity)shooter;
                return new ShooterContextVehicleRoot(vehicle);
            }
        }
        if ((blockEntity = blockEntityResolveFunc.apply(shooterUUID)).isPresent()) {
            return new ShooterContextBlockEntity(blockEntity.get());
        }
        return new ShooterContextUnresolvedEntity(ownerUUID, shooterUUID, MinecraftHelpers.getLogicalSide());
    }

    @Override
    protected boolean BasicValidation(@Nonnull ShooterContext check) {
        return check.IsValid();
    }

    @Override
    @Nonnull
    protected ShooterContext GetInvalidContext() {
        return ShooterContext.INVALID;
    }

    @Override
    protected void MarkContextAsOld(@Nonnull ShooterContext oldContext) {
        oldContext.MarkAsOld();
    }
}

