/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.actions.contexts;

import com.flansmod.common.actions.contexts.ContextHistory;
import com.flansmod.common.actions.contexts.GunContext;
import com.flansmod.common.actions.contexts.GunContextInventoryItem;
import com.flansmod.common.actions.contexts.GunContextItem;
import com.flansmod.common.actions.contexts.GunContextItemEntity;
import com.flansmod.common.actions.contexts.GunContextTileEntity;
import com.flansmod.common.actions.contexts.ShooterBlockEntity;
import com.flansmod.common.actions.contexts.ShooterContext;
import com.flansmod.common.actions.contexts.ShooterContextBlockEntity;
import com.flansmod.common.item.FlanItem;
import com.flansmod.physics.common.util.MinecraftHelpers;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.NonNullSupplier;

public class GunContextHistory
extends ContextHistory<GunContext> {
    public static final GunContextHistory INVALID = new GunContextHistory(GunContext.INVALID.GetUUID()){

        @Override
        @Nonnull
        public GunContext GetOrCreate(@Nonnull Function<GunContext, Boolean> validatorFunc, @Nonnull NonNullSupplier<GunContext> creatorFunc, @Nonnull NonNullSupplier<Long> timeFunc) {
            return GunContext.INVALID;
        }
    };

    public GunContextHistory(@Nonnull UUID id) {
        super(id);
    }

    @Nonnull
    public GunContext ContextualizeWith(@Nonnull ShooterContext shooter, int slotIndex) {
        GunContext gunContext = this.GetOrCreate(check -> check.GetShooter() == shooter && check.GetInventorySlotIndex() == slotIndex, () -> shooter.CreateContext(this.ID), (NonNullSupplier<Long>)((NonNullSupplier)MinecraftHelpers::getTick));
        gunContext.UpdateFromItemStack();
        return gunContext;
    }

    @Nonnull
    public GunContext ContextualizeWith(@Nonnull ShooterContext shooter) {
        GunContext gunContext = this.GetOrCreate(check -> check.GetShooter() == shooter && this.IsGunStillPresentIn((GunContext)check, shooter), () -> shooter.CreateContext(this.ID), (NonNullSupplier<Long>)((NonNullSupplier)MinecraftHelpers::getTick));
        gunContext.UpdateFromItemStack();
        return gunContext;
    }

    @Nonnull
    public GunContext ContextualizeWith(@Nonnull ItemEntity itemEntity) {
        return this.GetOrCreate(check -> {
            boolean bl;
            if (check instanceof GunContextItemEntity) {
                GunContextItemEntity checkItemEntity = (GunContextItemEntity)check;
                if (checkItemEntity.Holder == itemEntity) {
                    bl = true;
                    return bl;
                }
            }
            bl = false;
            return bl;
        }, () -> new GunContextItemEntity(itemEntity), (NonNullSupplier<Long>)((NonNullSupplier)MinecraftHelpers::getTick));
    }

    @Nonnull
    public GunContext ContextualizeWith(@Nonnull BlockEntity blockEntity, @Nonnull Container container, int slot) {
        return this.GetOrCreate(check -> {
            boolean bl;
            if (check instanceof GunContextTileEntity) {
                GunContextTileEntity teContext = (GunContextTileEntity)check;
                if (teContext.ShooterContext.Dimension == blockEntity.m_58904_().m_46472_() && teContext.ShooterContext.Pos == blockEntity.m_58899_() && check.GetInventorySlotIndex() == slot) {
                    bl = true;
                    return bl;
                }
            }
            bl = false;
            return bl;
        }, () -> {
            ShooterBlockEntity shooterBlockEntity;
            ShooterContext shooterContext;
            if (blockEntity instanceof ShooterBlockEntity && (shooterContext = ShooterContext.of(shooterBlockEntity = (ShooterBlockEntity)blockEntity)).IsValid() && shooterContext instanceof ShooterContextBlockEntity) {
                ShooterContextBlockEntity shooterContextBlockEntity = (ShooterContextBlockEntity)shooterContext;
                return new GunContextTileEntity(shooterContextBlockEntity, slot);
            }
            return GunContext.INVALID;
        }, (NonNullSupplier<Long>)((NonNullSupplier)MinecraftHelpers::getTick));
    }

    @Nonnull
    public GunContext ContextualizeWith(@Nonnull Container container, int slot) {
        int slotIndex = slot;
        return this.GetOrCreate(check -> check.GetAttachedInventory() == container && check.GetInventorySlotIndex() == slotIndex, () -> new GunContextInventoryItem(container, slotIndex), (NonNullSupplier<Long>)((NonNullSupplier)MinecraftHelpers::getTick));
    }

    @Nonnull
    public GunContext ContextualizeWith(@Nonnull ItemStack stack) {
        return this.GetOrCreate(check -> FlanItem.GetGunID(check.Stack).equals(this.ID), () -> new GunContextItem(stack), (NonNullSupplier<Long>)((NonNullSupplier)MinecraftHelpers::getTick));
    }

    @Nonnull
    public GunContext WithoutContext() {
        GunContext mostRecent = (GunContext)this.GetMostRecentContext();
        return mostRecent == null ? GunContext.INVALID : mostRecent;
    }

    @Override
    protected boolean BasicValidation(@Nonnull GunContext check) {
        return check.IsValid();
    }

    @Override
    protected void MarkContextAsOld(@Nonnull GunContext oldContext) {
    }

    @Override
    @Nonnull
    protected GunContext GetInvalidContext() {
        return GunContext.INVALID;
    }

    private boolean IsGunStillPresentIn(@Nonnull GunContext gun, @Nonnull ShooterContext in) {
        int expectedSlot = gun.GetInventorySlotIndex();
        Container inContainer = in.GetAttachedInventory();
        if (inContainer != null && 0 <= expectedSlot && expectedSlot < inContainer.m_6643_()) {
            ItemStack foundStack = inContainer.m_8020_(expectedSlot);
            return GunContext.CompareGunStacks(foundStack, gun.Stack).IsValid();
        }
        return false;
    }
}

