/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.actions.contexts;

import com.flansmod.common.FlansMod;
import com.flansmod.common.actions.contexts.GunContext;
import com.flansmod.common.actions.stats.IModifierBaker;
import com.flansmod.common.actions.stats.ModifierCache;
import com.flansmod.common.actions.stats.StatAccumulator;
import com.flansmod.common.item.BulletItem;
import com.flansmod.common.item.GunItem;
import com.flansmod.common.types.attachments.AttachmentDefinition;
import com.flansmod.common.types.attachments.EAttachmentType;
import com.flansmod.common.types.elements.ModifierDefinition;
import com.flansmod.common.types.guns.elements.ActionDefinition;
import com.flansmod.common.types.guns.elements.ActionGroupDefinition;
import com.flansmod.common.types.guns.elements.EActionType;
import com.flansmod.common.types.guns.elements.ERepeatMode;
import com.flansmod.common.types.guns.elements.ESpreadPattern;
import com.flansmod.common.types.guns.elements.ReloadDefinition;
import com.flansmod.common.types.magazines.EAmmoConsumeMode;
import com.flansmod.common.types.magazines.EAmmoLoadMode;
import com.flansmod.common.types.magazines.MagazineDefinition;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.util.formulae.FloatAccumulation;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ActionGroupContext {
    public static final ActionGroupContext INVALID = new ActionGroupContext(GunContext.INVALID, "");
    @Nonnull
    public final GunContext Gun;
    @Nonnull
    public final String GroupPath;
    @Nonnull
    public final ActionGroupDefinition Def;
    @Nonnull
    private final ModifierCache ModCache;
    public static final int INVALID_FIRE_INDEX = -1;
    public static final int ALL_SPECIAL_FIRE_INDEX = -2;

    public boolean IsAttachment() {
        return this.GroupPath.contains("/");
    }

    public boolean IsValid() {
        return this.Gun.IsValid() && !this.GroupPath.isEmpty();
    }

    public static ActionGroupContext CreateFrom(GunContext gunContext, String groupPath) {
        if (gunContext.IsValid()) {
            return gunContext.GetActionGroupContext(groupPath);
        }
        return INVALID;
    }

    protected ActionGroupContext(@Nonnull GunContext gun, @Nonnull String groupPath) {
        this.Gun = gun;
        this.GroupPath = groupPath;
        this.Def = this.CacheGroupDef();
        this.ModCache = new ModifierCache(this::BakeModifiers);
    }

    @Nonnull
    public String GetSibling(@Nonnull String actionGroupOrAP) {
        return ActionGroupContext.GetSibling(this.GroupPath, actionGroupOrAP);
    }

    @Nonnull
    public static String CreateGroupPath(@Nonnull String actionGroupKey) {
        return actionGroupKey;
    }

    @Nonnull
    public static String CreateGroupPath(@Nonnull EAttachmentType attachmentType, @Nonnull String actionGroupKey) {
        return attachmentType + "/" + actionGroupKey;
    }

    @Nonnull
    public static String CreateGroupPath(@Nonnull EAttachmentType attachmentType, int attachmentIndex, @Nonnull String actionGroupKey) {
        if (attachmentIndex >= 0) {
            return attachmentType + "/" + attachmentIndex + "/" + actionGroupKey;
        }
        return actionGroupKey;
    }

    @Nonnull
    public static String GetSibling(@Nonnull String fullPath, @Nonnull String actionGroupOrAP) {
        String[] components = fullPath.split("/");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < components.length - 1; ++i) {
            sb.append(components[i]).append('/');
        }
        sb.append(actionGroupOrAP);
        return sb.toString();
    }

    @Nonnull
    public static EAttachmentType GetAttachmentType(String actionGroupPath) {
        String[] components = actionGroupPath.split("/");
        switch (components.length) {
            case 2: 
            case 3: {
                return EAttachmentType.Parse(components[0]);
            }
        }
        return EAttachmentType.Generic;
    }

    public static int GetAttachmentIndex(String actionGroupPath) {
        String[] components = actionGroupPath.split("/");
        switch (components.length) {
            case 2: {
                return 0;
            }
            case 3: {
                return Integer.parseInt(components[1]);
            }
        }
        return -1;
    }

    @Nonnull
    public static String GetActionGroupKey(String actionGroupPath) {
        String[] components = actionGroupPath.split("/");
        if (components.length == 0) {
            return "";
        }
        return components[components.length - 1];
    }

    @Nonnull
    public EAttachmentType GetAttachmentType() {
        return ActionGroupContext.GetAttachmentType(this.GroupPath);
    }

    public int GetAttachmentIndex() {
        return ActionGroupContext.GetAttachmentIndex(this.GroupPath);
    }

    @Nonnull
    public String GetActionGroupKey() {
        return ActionGroupContext.GetActionGroupKey(this.GroupPath);
    }

    @Nonnull
    private ActionGroupDefinition CacheGroupDef() {
        if (this.IsAttachment()) {
            AttachmentDefinition attachment;
            String[] components = this.GroupPath.split("/");
            EAttachmentType attachmentType = EAttachmentType.Parse(components[0]);
            int index = 0;
            String subPath = components[1];
            if (components.length >= 3) {
                index = Integer.parseInt(components[1]);
                subPath = components[2];
            }
            if ((attachment = this.Gun.GetAttachmentDefinition(attachmentType, index)).IsValid()) {
                return attachment.GetActionGroup(subPath);
            }
        }
        return this.Gun.CacheGunDefinition().GetActionGroup(this.GroupPath);
    }

    @Nonnull
    protected String GetRootTagKey() {
        ReloadDefinition reloadDef = this.Gun.GetReloadDefinitionContaining(this);
        return reloadDef != null ? reloadDef.key : this.GroupPath;
    }

    @Nonnull
    protected CompoundTag GetRootTag() {
        return this.Gun.GetTags(this.GetRootTagKey());
    }

    protected void SetRootTag(CompoundTag tags) {
        this.Gun.SetTags(this.GetRootTagKey(), tags);
    }

    @Nonnull
    protected CompoundTag GetMagTag(int magIndex) {
        Item item = this.Gun.GetItemStack().m_41720_();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            return gunItem.GetMagTag(this.Gun.GetItemStack(), this.GroupPath, magIndex);
        }
        return new CompoundTag();
    }

    protected void SetMagTag(int magIndex, CompoundTag tags) {
        CompoundTag updatedTags = this.GetRootTag().m_6426_();
        updatedTags.m_128365_("mag_" + magIndex, (Tag)tags);
        this.SetRootTag(updatedTags);
    }

    @Nonnull
    public MagazineDefinition GetMagazineType(int magIndex) {
        Item item = this.Gun.GetItemStack().m_41720_();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            return gunItem.GetMagazineType(this.Gun.GetItemStack(), this.GroupPath, magIndex);
        }
        return MagazineDefinition.INVALID;
    }

    public int GetMagazineSize(int magIndex) {
        return this.GetMagazineType((int)magIndex).numRounds;
    }

    public void SetMagazineType(int magIndex, @Nonnull MagazineDefinition magDef) {
        int newMagSize = magDef.numRounds;
        Item[] bulletsInMag = this.ExtractCompactStacks(magIndex);
        Item[] resultingBulletsInMag = new Item[newMagSize];
        ArrayList<ItemStack> expelBullets = new ArrayList<ItemStack>();
        CompoundTag updatedTags = this.GetMagTag(magIndex).m_6426_();
        updatedTags.m_128359_("type", magDef.GetLocationString());
        this.SetMagTag(magIndex, updatedTags);
        int bulletCount = 0;
        for (int i = 0; i < bulletsInMag.length; ++i) {
            if (bulletsInMag[i] == Items.f_42410_) continue;
            if (bulletCount < newMagSize) {
                resultingBulletsInMag[bulletCount] = bulletsInMag[i];
            } else {
                expelBullets.add(new ItemStack((ItemLike)bulletsInMag[i], 1));
            }
            ++bulletCount;
        }
        this.CompactStacks(magIndex, resultingBulletsInMag);
        this.Gun.ExpelItems(expelBullets);
    }

    public float GetMagFullnessRatio(int magIndex) {
        int magSize = this.GetMagazineSize(magIndex);
        int bulletCount = this.GetNumBulletsInMag(magIndex);
        return magSize == 0 ? 0.0f : (float)bulletCount / (float)magSize;
    }

    @Nonnull
    public ItemStack[] GetCombinedBulletStacks(int magIndex) {
        Item item = this.Gun.GetItemStack().m_41720_();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            return gunItem.GetCombinedBulletStacks(this.Gun.GetItemStack(), this.GroupPath, magIndex);
        }
        return new ItemStack[0];
    }

    @Nonnull
    public ItemStack GetBulletAtIndex(int magIndex, int bulletIndex) {
        Item item = this.Gun.GetItemStack().m_41720_();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            return gunItem.GetBulletAtIndex(this.Gun.GetItemStack(), this.GroupPath, magIndex, bulletIndex);
        }
        return ItemStack.f_41583_;
    }

    public int GetNumBulletsInMag(int magIndex) {
        Item item = this.Gun.GetItemStack().m_41720_();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            return gunItem.GetNumBulletsInMag(this.Gun.GetItemStack(), this.GroupPath, magIndex);
        }
        return 0;
    }

    @Nonnull
    public ItemStack ConsumeBulletAtIndex(int magIndex, int bulletIndex) {
        MagazineDefinition magDef = this.GetMagazineType(magIndex);
        if (0 <= bulletIndex && bulletIndex < magDef.numRounds) {
            Item[] items = this.ExtractCompactStacks(magIndex);
            ItemStack returnStack = new ItemStack((ItemLike)items[bulletIndex], 1);
            items[bulletIndex] = Items.f_42410_;
            this.CompactStacks(magIndex, items);
            return returnStack;
        }
        FlansMod.LOGGER.warn("Failed to consume bullet " + bulletIndex + " from mag " + magIndex + " in " + this);
        return ItemStack.f_41583_;
    }

    @Nonnull
    public Pair<ItemStack, Integer> ConsumeOneBullet(int magIndex) {
        int indexToFire = this.GetNextIndexToFire(magIndex);
        switch (indexToFire) {
            case -1: {
                break;
            }
            default: {
                return Pair.of((Object)this.ConsumeBulletAtIndex(magIndex, indexToFire), (Object)indexToFire);
            }
        }
        return Pair.of((Object)ItemStack.f_41583_, (Object)-1);
    }

    @Nonnull
    public ItemStack LoadOneBulletIntoSlot(int magIndex, int bulletIndex, ItemStack bulletStack, boolean isClient) {
        boolean isCreative = this.Gun.GetShooter().IsCreative();
        Item item = bulletStack.m_41720_();
        if (item instanceof BulletItem) {
            BulletItem bulletItem = (BulletItem)item;
            Item[] items = this.ExtractCompactStacks(magIndex);
            items[bulletIndex] = bulletStack.m_41720_();
            this.CompactStacks(magIndex, items);
            if (!isCreative && !isClient) {
                bulletStack.m_41764_(bulletStack.m_41613_() - 1);
            }
        }
        return bulletStack;
    }

    @Nonnull
    public ItemStack LoadBullets(int magIndex, ItemStack bulletStack, boolean isClient) {
        boolean isCreative = this.Gun.GetShooter().IsCreative();
        Item item = bulletStack.m_41720_();
        if (item instanceof BulletItem) {
            BulletItem bulletItem = (BulletItem)item;
            Item[] items = this.ExtractCompactStacks(magIndex);
            MagazineDefinition magDef = this.GetMagazineType(magIndex);
            for (int i = 0; i < magDef.numRounds; ++i) {
                if (items[i] == null || items[i] == Items.f_42410_) {
                    items[i] = bulletStack.m_41720_();
                    if (!isCreative && !isClient) {
                        bulletStack.m_41764_(bulletStack.m_41613_() - 1);
                    }
                }
                if (bulletStack.m_41619_()) break;
            }
            this.CompactStacks(magIndex, items);
        }
        return bulletStack;
    }

    @Nonnull
    private Item[] ExtractCompactStacks(int magIndex) {
        Item item = this.Gun.GetItemStack().m_41720_();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            return gunItem.ExtractCompactStacks(this.Gun.GetItemStack(), this.GroupPath, magIndex);
        }
        return new Item[0];
    }

    private void CompactStacks(int magIndex, @Nonnull Item[] items) {
        if (items.length == 0) {
            return;
        }
        CompoundTag bulletsTag = new CompoundTag();
        int sameSinceIndex = 0;
        Item currentlyParsing = items[0];
        for (int i = 0; i < items.length; ++i) {
            Item compareAgainst;
            Item item = compareAgainst = i < items.length - 1 ? items[i + 1] : null;
            if (compareAgainst == currentlyParsing) continue;
            ItemStack previousLump = new ItemStack((ItemLike)(currentlyParsing == Items.f_41852_ ? Items.f_42410_ : currentlyParsing), i - sameSinceIndex + 1);
            CompoundTag stackTag = new CompoundTag();
            previousLump.m_41739_(stackTag);
            bulletsTag.m_128365_(Integer.toString(sameSinceIndex), (Tag)stackTag);
            sameSinceIndex = i + 1;
            currentlyParsing = compareAgainst;
        }
        CompoundTag updatedMagTags = this.GetMagTag(magIndex).m_6426_();
        updatedMagTags.m_128365_("bullets", (Tag)bulletsTag);
        this.SetMagTag(magIndex, updatedMagTags);
    }

    @Nonnull
    public ItemStack GetNextBulletToBeFired(int magIndex) {
        return this.GetBulletAtIndex(magIndex, this.GetNextIndexToFire(magIndex));
    }

    public boolean ContainsAnyBullets(int magIndex) {
        CompoundTag magTags = this.GetMagTag(magIndex);
        if (magTags.m_128441_("bullets")) {
            CompoundTag bulletTags = magTags.m_128469_("bullets");
            for (String key : bulletTags.m_128431_()) {
                ItemStack stack = ItemStack.m_41712_((CompoundTag)bulletTags.m_128469_(key));
                if (stack.m_41619_() || stack.m_41720_() == Items.f_42410_) continue;
                return true;
            }
        }
        return false;
    }

    public int GetNextIndexToFire(int magIndex) {
        CompoundTag magTags = this.GetMagTag(magIndex);
        MagazineDefinition magDef = this.GetMagazineType(magIndex);
        int fireIndex = -1;
        block0 : switch (magDef.ammoConsumeMode) {
            case RoundRobin: {
                fireIndex = this.GetCurrentChamber();
                break;
            }
            case LastNonEmpty: 
            case FirstNonEmpty: {
                if (!magTags.m_128441_("bullets")) break;
                CompoundTag bulletTags = magTags.m_128469_("bullets");
                for (String key : bulletTags.m_128431_()) {
                    int startIndex = Integer.parseInt(key);
                    ItemStack stack = ItemStack.m_41712_((CompoundTag)bulletTags.m_128469_(key));
                    int endIndex = startIndex + stack.m_41613_();
                    if (stack.m_41619_() || stack.m_41720_() == Items.f_42410_) continue;
                    if (magDef.ammoConsumeMode == EAmmoConsumeMode.LastNonEmpty) {
                        fireIndex = endIndex - 1;
                        continue;
                    }
                    fireIndex = startIndex;
                    break block0;
                }
                break;
            }
            case Simultaneous: {
                fireIndex = -2;
            }
        }
        return fireIndex;
    }

    public int GetNextIndexToLoad(int magIndex) {
        CompoundTag magTags = this.GetMagTag(magIndex);
        MagazineDefinition magDef = this.GetMagazineType(magIndex);
        switch (magDef.ammoLoadMode) {
            case FullMag: {
                return -2;
            }
            case OneBulletAtATime: {
                if (magTags.m_128441_("bullets")) {
                    CompoundTag bulletTags = magTags.m_128469_("bullets");
                    for (String key : bulletTags.m_128431_()) {
                        ItemStack stack = ItemStack.m_41712_((CompoundTag)bulletTags.m_128469_(key));
                        if (stack.m_41720_() != Items.f_42410_) continue;
                        return Integer.parseInt(key);
                    }
                }
                return 0;
            }
            case OneBulletAtATime_Revolver: {
                return this.GetCurrentChamber();
            }
        }
        return -1;
    }

    public int GetCurrentChamber() {
        return 0;
    }

    public void SetCurrentChamber(int chamber) {
    }

    public void AdvanceChamber() {
        int chamber = this.GetCurrentChamber();
        if (++chamber >= this.GetMagazineSize(0)) {
            chamber = 0;
        }
        this.SetCurrentChamber(chamber);
    }

    public boolean IsReloadInProgress() {
        return this.Gun.GetActionStack().IsReloading();
    }

    public boolean CanBeReloaded(int magIndex) {
        for (int i = 0; i < this.GetMagazineSize(magIndex); ++i) {
            if (!this.GetBulletAtIndex(magIndex, i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    public boolean CanPerformReloadFromAttachedInventory(int magIndex) {
        if (!this.CanBeReloaded(magIndex)) {
            return false;
        }
        if (this.Gun.GetShooter().GetAttachedInventory() != null) {
            int matchSlot = this.FindSlotWithMatchingAmmo(magIndex, this.Gun.GetShooter().GetAttachedInventory());
            return matchSlot != -1;
        }
        return false;
    }

    public int FindSlotWithMatchingAmmo(int magIndex, Container inventory) {
        MagazineDefinition magDef = this.GetMagazineType(magIndex);
        if (magDef.IsValid()) {
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                Item item;
                ItemStack stack = inventory.m_8020_(i);
                if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof BulletItem)) continue;
                BulletItem bullet = (BulletItem)item;
                if (!magDef.GetMatchingBullets().contains(bullet.Def())) continue;
                return i;
            }
        }
        return -1;
    }

    public void LoadOne(int magIndex, Container inventory, boolean isClient) {
        MagazineDefinition magDef;
        if (inventory != null && (magDef = this.GetMagazineType(magIndex)).IsValid()) {
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                Item item;
                ItemStack stack = inventory.m_8020_(i);
                if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof BulletItem)) continue;
                BulletItem bullet = (BulletItem)item;
                if (!magDef.GetMatchingBullets().contains(bullet.Def())) continue;
                if (magDef.ammoLoadMode == EAmmoLoadMode.FullMag) {
                    stack = this.LoadBullets(magIndex, stack, isClient);
                    if (!isClient) {
                        inventory.m_6836_(i, stack);
                        inventory.m_6596_();
                        continue;
                    }
                    inventory.m_6596_();
                    continue;
                }
                int bulletIndex = this.GetNextIndexToLoad(magIndex);
                if (bulletIndex == -1) break;
                stack = this.LoadOneBulletIntoSlot(magIndex, bulletIndex, stack, isClient);
                if (!isClient) {
                    inventory.m_6836_(i, stack);
                    inventory.m_6596_();
                    break;
                }
                inventory.m_6596_();
                break;
            }
        }
    }

    public boolean IsShootAction() {
        return this.GetShootActionDefinition().IsValid();
    }

    public ActionDefinition GetShootActionDefinition() {
        for (ActionDefinition def : this.Def.actions) {
            if (def.actionType != EActionType.Shoot) continue;
            return def;
        }
        return ActionDefinition.Invalid;
    }

    public boolean CanShoot(int magIndex) {
        return this.ContainsAnyBullets(magIndex);
    }

    public void BakeModifiers(@Nonnull IModifierBaker baker) {
        for (ModifierDefinition modDef : this.Def.modifiers) {
            baker.Bake(modDef);
        }
    }

    @Nonnull
    protected StatAccumulator GetModifierFormula(@Nonnull String stat) {
        return this.ModCache.GetModifierFormula(stat);
    }

    @Nonnull
    protected Optional<String> GetStringOverride(@Nonnull String stat) {
        return this.ModCache.GetStringOverride(stat);
    }

    @Nonnull
    public FloatAccumulation ModifyFloat(@Nonnull String stat) {
        return FloatAccumulation.compose(this.GetModifierFormula(stat).Calculate(this.Gun), this.Gun.GetModifierFormula(stat).Calculate(this.Gun), this.Gun.GetShooter().GetModifierFormula(stat).Calculate(this.Gun));
    }

    @Nonnull
    public String ModifyString(@Nonnull String stat, @Nonnull String defaultValue) {
        return this.Gun.GetShooter().GetStringOverride(stat).orElse(this.Gun.GetStringOverride(stat).orElse(this.GetStringOverride(stat).orElse(defaultValue)));
    }

    @Nonnull
    public <T extends Enum<T>> Enum<T> ModifyEnum(@Nonnull String stat, @Nonnull T defaultValue, @Nonnull Class<T> clazz) {
        return Enum.valueOf(clazz, this.ModifyString(stat, defaultValue.toString()));
    }

    public boolean GetBoolean(@Nonnull String stat) {
        return Boolean.parseBoolean(this.ModifyString(stat, "false"));
    }

    public boolean ModifyBoolean(@Nonnull String stat, boolean defaultValue) {
        return Boolean.parseBoolean(this.ModifyString(stat, Boolean.toString(defaultValue)));
    }

    @Nonnull
    public ERepeatMode RepeatMode() {
        return (ERepeatMode)this.ModifyEnum("repeat_mode", this.Def.repeatMode, ERepeatMode.class);
    }

    public float RepeatDelaySeconds() {
        return this.ModifyFloat("repeat_delay").apply(this.Def.repeatDelay);
    }

    public int RepeatCount() {
        return Maths.ceil(this.ModifyFloat("repeat_count").apply(this.Def.repeatCount));
    }

    public float SpinUpDuration() {
        return this.ModifyFloat("spin_up_duration").apply(this.Def.spinUpDuration);
    }

    public float Loudness() {
        return this.ModifyFloat("loudness").apply(this.Def.loudness);
    }

    public float Volume() {
        return this.ModifyFloat("loudness").apply(1.0f);
    }

    public float Pitch() {
        return this.ModifyFloat("pitch").apply(1.0f);
    }

    public float VerticalRecoil() {
        return this.ModifyFloat("vertical_recoil").get();
    }

    public float HorizontalRecoil() {
        return this.ModifyFloat("horizontal_recoil").get();
    }

    public float Spread() {
        return this.ModifyFloat("spread").get();
    }

    public ESpreadPattern SpreadPattern() {
        return (ESpreadPattern)this.ModifyEnum("spread_pattern", ESpreadPattern.FilledCircle, ESpreadPattern.class);
    }

    public int RepeatDelayTicks() {
        return Maths.ceil(this.RepeatDelaySeconds() * 20.0f);
    }

    public int RoundsPerMinute() {
        return this.RepeatDelaySeconds() <= 1.0E-5f ? 0 : Maths.ceil(60.0f / this.RepeatDelaySeconds());
    }

    public float GetSpread(ActionDefinition def) {
        return this.ModifyFloat("spread" + def.id).get();
    }

    public String toString() {
        return this.Gun + ":" + this.GroupPath;
    }

    public void Save(CompoundTag tags) {
        CompoundTag gunTags = new CompoundTag();
        this.Gun.Save(gunTags);
        tags.m_128365_("gun", (Tag)gunTags);
        tags.m_128405_("groupHash", this.GroupPath.hashCode());
    }

    public static ActionGroupContext Load(CompoundTag tags, boolean client) {
        int groupPathHash = tags.m_128451_("groupHash");
        GunContext gunContext = GunContext.Load(tags.m_128469_("gun"), client);
        if (gunContext.IsValid()) {
            return gunContext.GetActionGroupContextByHash(groupPathHash);
        }
        return INVALID;
    }
}

