/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.abilities;

import com.flansmod.common.abilities.AbilityStack;
import com.flansmod.common.actions.contexts.ActionGroupContext;
import com.flansmod.common.actions.contexts.GunContext;
import com.flansmod.common.actions.contexts.TargetsContext;
import com.flansmod.common.actions.contexts.TriggerContext;
import com.flansmod.common.actions.stats.StatAccumulator;
import com.flansmod.common.types.abilities.elements.AbilityEffectDefinition;
import com.flansmod.common.types.elements.ModifierDefinition;
import com.flansmod.util.formulae.FloatAccumulation;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IAbilityEffect {
    public static final ModifierDefinition[] NO_MODS = new ModifierDefinition[0];

    default public void TriggerClient(@Nonnull ActionGroupContext gun, @Nonnull TriggerContext trigger, @Nonnull TargetsContext targets, @Nullable AbilityStack stacks) {
    }

    default public void TriggerServer(@Nonnull ActionGroupContext gun, @Nonnull TriggerContext trigger, @Nonnull TargetsContext targets, @Nullable AbilityStack stacks) {
    }

    default public boolean CanBeContinuous() {
        return false;
    }

    default public void EndClient(@Nonnull GunContext gun, @Nullable AbilityStack stacks) {
    }

    default public void EndServer(@Nonnull GunContext gun, @Nullable AbilityStack stacks) {
    }

    @Nonnull
    default public ModifierDefinition[] GetActiveModifiers() {
        return NO_MODS;
    }

    public static class StatHolder {
        private final String Stat;
        private final StatAccumulator Base;

        public StatHolder(@Nonnull String statId, @Nonnull AbilityEffectDefinition def) {
            this.Stat = statId;
            this.Base = new StatAccumulator().Stack(def.MatchModifiers(statId));
        }

        public float Get(@Nonnull ActionGroupContext actionGroup, @Nullable AbilityStack stacks) {
            if (stacks != null) {
                return FloatAccumulation.compose(this.Base.CopyWithLevelAndStacks(stacks.Level, stacks.GetStackCount()).Calculate(actionGroup.Gun), actionGroup.ModifyFloat(this.Stat)).get();
            }
            return FloatAccumulation.compose(this.Base.Calculate(actionGroup.Gun), actionGroup.ModifyFloat(this.Stat)).get();
        }
    }
}

