/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.abilities;

import com.flansmod.common.abilities.AbilityStack;
import com.flansmod.common.abilities.IAbilityEffect;
import com.flansmod.common.actions.contexts.ActionGroupContext;
import com.flansmod.common.actions.contexts.GunContext;
import com.flansmod.common.actions.contexts.TargetsContext;
import com.flansmod.common.actions.contexts.TriggerContext;
import com.flansmod.common.types.abilities.elements.AbilityEffectDefinition;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class AbilityEffectApplyAttribute
implements IAbilityEffect {
    public final Attribute Attrib;
    public final UUID IdentifyingKey;
    @Nonnull
    private final IAbilityEffect.StatHolder AttributeMultiplier;

    public AbilityEffectApplyAttribute(@Nonnull AbilityEffectDefinition def) {
        this.Attrib = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(def.ModifyString("attribute_id", "")));
        this.IdentifyingKey = UUID.randomUUID();
        this.AttributeMultiplier = new IAbilityEffect.StatHolder("attribute_multiplier", def);
    }

    @Override
    public void TriggerServer(@Nonnull ActionGroupContext gun, @Nonnull TriggerContext trigger, @Nonnull TargetsContext targets, @Nullable AbilityStack stacks) {
        targets.ForEachEntity(entity -> {
            LivingEntity living;
            AttributeInstance instance;
            if (entity instanceof LivingEntity && (instance = (living = (LivingEntity)entity).m_21051_(this.Attrib)) != null) {
                instance.m_22120_(this.IdentifyingKey);
                instance.m_22118_(new AttributeModifier(this.IdentifyingKey, "Flan's Ability Effect", (double)this.AttributeMultiplier.Get(gun, stacks), AttributeModifier.Operation.ADDITION));
            }
        });
    }

    @Override
    public boolean CanBeContinuous() {
        return true;
    }

    @Override
    public void EndServer(@Nonnull GunContext gun, @Nullable AbilityStack stacks) {
    }
}

