/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.sound;

import com.flansmod.common.types.elements.SoundDefinition;
import com.flansmod.common.types.elements.SoundLODDefinition;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.Transform;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class SoundLODManager {
    public static void PlaySound(@Nonnull SoundDefinition soundDef, @Nonnull Entity onEntity) {
        SoundLODManager.PlaySound(soundDef, onEntity, 1.0f, 1.0f);
    }

    public static void PlaySound(@Nonnull SoundDefinition soundDef, @Nonnull Entity onEntity, float volumeMulti, float pitchMulti) {
        SoundLODManager.PlaySound(soundDef, onEntity.m_20182_(), volumeMulti, pitchMulti);
    }

    public static void PlaySound(@Nonnull SoundDefinition soundDef, @Nonnull Transform transform, float volumeMulti, float pitchMulti) {
        SoundLODManager.PlaySound(soundDef, transform.positionVec3(), volumeMulti, pitchMulti);
    }

    public static void PlaySound(@Nonnull SoundDefinition soundDef, @Nonnull Vec3 position, float volumeMulti, float pitchMulti) {
        Entity camera = Minecraft.m_91087_().f_91075_;
        if (camera != null) {
            double distance = Maths.sqrt(camera.m_20238_(position));
            double bestLOD = 0.0;
            ResourceLocation soundToPlay = soundDef.GetSoundLocation();
            for (SoundLODDefinition lodDefinition : soundDef.LODs) {
                if (!(distance >= (double)lodDefinition.minDistance) || !((double)lodDefinition.minDistance > bestLOD)) continue;
                bestLOD = lodDefinition.minDistance;
                ResourceLocation lodSoundToPlay = lodDefinition.GetSoundLocation();
                if (lodSoundToPlay == null) continue;
                soundToPlay = lodSoundToPlay;
            }
            if (soundToPlay != null) {
                Minecraft.m_91087_().f_91073_.m_7785_(position.f_82479_, position.f_82480_, position.f_82481_, SoundEvent.m_262856_((ResourceLocation)soundToPlay, (float)soundDef.maxRange), SoundSource.HOSTILE, volumeMulti * soundDef.PickRangedVolume((float)distance), pitchMulti * soundDef.PickRandomPitch(Minecraft.m_91087_().f_91073_.f_46441_), true);
            }
        }
    }
}

