/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.render.models.baked;

import com.flansmod.client.render.RenderContext;
import com.flansmod.client.render.animation.ESmoothSetting;
import com.flansmod.client.render.animation.FlanimationDefinition;
import com.flansmod.client.render.animation.PoseCache;
import com.flansmod.client.render.animation.elements.KeyframeDefinition;
import com.flansmod.client.render.animation.elements.SequenceDefinition;
import com.flansmod.client.render.animation.elements.SequenceEntryDefinition;
import com.flansmod.client.render.models.ETurboRenderMaterial;
import com.flansmod.client.render.models.TurboRenderUtility;
import com.flansmod.client.render.models.baked.BakedAttachPoint;
import com.flansmod.client.render.models.baked.BakedTurboSection;
import com.flansmod.common.FlansMod;
import com.flansmod.common.actions.ActionGroupInstance;
import com.flansmod.common.actions.ActionInstance;
import com.flansmod.common.actions.ActionStack;
import com.flansmod.common.actions.nodes.AnimationAction;
import com.flansmod.common.types.attachments.EAttachmentType;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.Transform;
import com.flansmod.physics.common.util.TransformStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.textures.UnitTextureAtlasSprite;

public record BakedTurboRig(@Nonnull Map<String, BakedModel> iconModels, @Nonnull Map<String, BakedTurboSection> sections, @Nonnull Map<String, BakedAttachPoint> attachPoints, @Nonnull Map<String, ResourceLocation> textures, @Nonnull Map<String, Float> floatParameters, @Nonnull ItemTransforms transforms) implements BakedModel
{
    public static final String AP_CORE = "body";

    @Nonnull
    public BakedAttachPoint getRootAP() {
        return this.attachPoints.get(AP_CORE);
    }

    @Nonnull
    public BakedAttachPoint getAP(@Nonnull String apName) {
        return this.attachPoints.getOrDefault(apName, BakedAttachPoint.invalid);
    }

    @Nonnull
    public BakedAttachPoint getAP(@Nonnull EAttachmentType attachmentType, int index) {
        if (index == 0 && this.attachPoints.containsKey(attachmentType.unindexedName(index))) {
            return this.attachPoints.get(attachmentType.unindexedName(index));
        }
        if (this.attachPoints.containsKey(attachmentType.indexedName(index))) {
            return this.attachPoints.get(attachmentType.indexedName(index));
        }
        return BakedAttachPoint.invalid;
    }

    @Nonnull
    public String getAPKey(@Nonnull EAttachmentType attachmentType, int index) {
        String unindexedName;
        if (index == 0 && this.attachPoints.containsKey(unindexedName = attachmentType.unindexedName(index))) {
            return unindexedName;
        }
        return attachmentType.indexedName(index);
    }

    @Nullable
    public BakedTurboSection getSection(@Nonnull String sectionName) {
        return this.sections.get(sectionName);
    }

    public boolean hasSection(@Nonnull String sectionName) {
        return this.sections.containsKey(sectionName);
    }

    @Nullable
    public BakedModel getIconModel(@Nonnull String key) {
        return this.iconModels.get(key);
    }

    @Nullable
    public ResourceLocation getSkin(@Nonnull String key) {
        return this.textures.get(key);
    }

    @Nonnull
    public Transform getTransform(@Nonnull ItemDisplayContext transformType) {
        return Transform.fromItem(this.transforms.m_269404_(transformType));
    }

    public boolean m_7541_() {
        return false;
    }

    public boolean m_7539_() {
        return true;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return true;
    }

    @Nonnull
    public TextureAtlasSprite m_6160_() {
        return UnitTextureAtlasSprite.INSTANCE;
    }

    @Nonnull
    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    @Nonnull
    public List<BakedQuad> m_213637_(@Nullable BlockState blockState, @Nullable Direction direction, RandomSource randomSource) {
        return Collections.emptyList();
    }

    public void render(@Nonnull VertexConsumer vc, @Nonnull TransformStack transformStack, int light, int overlay, float scale) {
        for (BakedTurboSection section : this.sections.values()) {
            section.render(vc, transformStack, light, overlay, scale);
        }
    }

    @Nonnull
    private VertexConsumer selectVertexConsumer(@Nonnull ResourceLocation texture, @Nonnull ETurboRenderMaterial turboMaterial, @Nonnull MultiBufferSource buffers) {
        return buffers.m_6299_(TurboRenderUtility.flanItemRenderType(texture, turboMaterial));
    }

    public void forEachChild(@Nonnull String partName, @Nonnull Consumer<String> childFunc) {
        for (Map.Entry<String, BakedAttachPoint> kvp : this.attachPoints.entrySet()) {
            if (!partName.equals(kvp.getValue().parent())) continue;
            childFunc.accept(kvp.getKey());
        }
    }

    public void forEachChild(@Nonnull String partName, @Nonnull BiConsumer<String, BakedAttachPoint> childFunc) {
        for (Map.Entry<String, BakedAttachPoint> kvp : this.attachPoints.entrySet()) {
            if (!partName.equals(kvp.getValue().parent())) continue;
            childFunc.accept(kvp.getKey(), kvp.getValue());
        }
    }

    public void renderSection(@Nonnull String sectionName, @Nonnull Function<String, ResourceLocation> textureFunc, @Nonnull RenderContext renderContext) {
        BakedTurboSection section = this.getSection(sectionName);
        if (section != null) {
            ResourceLocation textureForSection = textureFunc.apply(sectionName);
            VertexConsumer vc = this.selectVertexConsumer(textureForSection, section.material(), renderContext.Buffers);
            section.render(vc, renderContext.Transforms, renderContext.Light, renderContext.Overlay, 0.0625f);
        }
    }

    public void renderSectionIteratively(@Nonnull RenderContext renderContext, @Nonnull String partName, @Nonnull Function<String, ResourceLocation> textureFunc, @Nonnull BiFunction<String, RenderContext, Boolean> preRenderFunc, @Nonnull BiConsumer<String, RenderContext> postRenderFunc) {
        renderContext.Transforms.push();
        boolean shouldRender = preRenderFunc.apply(partName, renderContext);
        if (shouldRender) {
            this.renderSection(partName, textureFunc, renderContext);
            this.forEachChild(partName, (String childName, BakedAttachPoint childAP) -> {
                renderContext.Transforms.push();
                renderContext.Transforms.add(childAP.offset());
                this.renderSectionIteratively(renderContext, (String)childName, textureFunc, preRenderFunc, postRenderFunc);
                renderContext.Transforms.pop();
            });
        }
        postRenderFunc.accept(partName, renderContext);
        renderContext.Transforms.pop();
    }

    @Nonnull
    public Transform getPose(@Nonnull String partName, @Nonnull ResourceLocation modelLocation, @Nonnull FlanimationDefinition animationSet, @Nullable ActionStack actionStack) {
        if (actionStack != null) {
            if (!animationSet.IsValid()) {
                return Transform.error("Missing animation set");
            }
            ArrayList<AnimationAction> animActions = new ArrayList<AnimationAction>();
            for (ActionGroupInstance actionGroupInstance : actionStack.GetActiveActionGroups()) {
                for (ActionInstance action : actionGroupInstance.GetActions()) {
                    if (!(action instanceof AnimationAction)) continue;
                    AnimationAction animAction = (AnimationAction)action;
                    animActions.add(animAction);
                }
            }
            ArrayList<Transform> poses = new ArrayList<Transform>();
            for (AnimationAction animAction : animActions) {
                SequenceDefinition sequence = animationSet.GetSequence(animAction.Def.anim);
                if (sequence == null) {
                    FlansMod.LOGGER.warn("Could not find animation sequence " + animAction.Def.anim + " in anim set " + animationSet.Location);
                    continue;
                }
                float progress = (float)animAction.AnimFrame + Minecraft.m_91087_().getPartialTick();
                float animMultiplier = sequence.Duration() / (animAction.Def.duration * 20.0f);
                SequenceEntryDefinition[] segment = sequence.GetSegment(progress *= animMultiplier);
                float segmentDuration = segment[1].tick - segment[0].tick;
                if (!(segmentDuration >= 0.0f)) continue;
                KeyframeDefinition from = animationSet.GetKeyframe(segment[0]);
                KeyframeDefinition to = animationSet.GetKeyframe(segment[1]);
                if (from == null || to == null) continue;
                float linearParameter = (progress - (float)segment[0].tick) / segmentDuration;
                float outputParameter = linearParameter = Maths.clamp(linearParameter, 0.0f, 1.0f);
                if (segment[0].exit == ESmoothSetting.instant) {
                    outputParameter = 1.0f;
                }
                if (segment[1].entry == ESmoothSetting.instant) {
                    outputParameter = 0.0f;
                }
                if (segment[0].exit == ESmoothSetting.smooth && linearParameter < 0.5f) {
                    outputParameter = linearParameter * linearParameter * (3.0f - 2.0f * linearParameter);
                }
                if (segment[1].entry == ESmoothSetting.smooth && linearParameter > 0.5f) {
                    outputParameter = linearParameter * linearParameter * (3.0f - 2.0f * linearParameter);
                }
                poses.add(PoseCache.Lerp(modelLocation, animationSet.Location, from.name, to.name, partName, outputParameter));
            }
            Transform transform = poses.size() > 0 ? Transform.interpolate(poses) : Transform.identity();
            return transform;
        }
        return Transform.identity();
    }
}

