/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.render.guns;

import com.flansmod.client.FlansModClient;
import com.flansmod.client.render.FlanItemModelRenderer;
import com.flansmod.client.render.RenderContext;
import com.flansmod.client.render.animation.FlanimationDefinition;
import com.flansmod.client.render.guns.AttachmentItemRenderer;
import com.flansmod.client.render.models.FlansModelRegistry;
import com.flansmod.client.render.models.ITurboRenderer;
import com.flansmod.common.actions.ActionGroupInstance;
import com.flansmod.common.actions.ActionInstance;
import com.flansmod.common.actions.ActionStack;
import com.flansmod.common.actions.contexts.ActionGroupContext;
import com.flansmod.common.actions.contexts.GunContext;
import com.flansmod.common.actions.contexts.ShooterContext;
import com.flansmod.common.item.GunItem;
import com.flansmod.common.types.attachments.AttachmentDefinition;
import com.flansmod.common.types.attachments.EAttachmentType;
import com.flansmod.common.types.guns.elements.AttachmentSettingsDefinition;
import com.flansmod.common.types.magazines.EAmmoLoadMode;
import com.flansmod.common.types.magazines.MagazineDefinition;
import com.flansmod.physics.common.util.EContextSide;
import com.flansmod.physics.common.util.MinecraftHelpers;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;

public class GunItemRenderer
extends FlanItemModelRenderer {
    public GunItemRenderer(@Nullable GunItem gunItem) {
        super(gunItem, true);
    }

    @Override
    protected void doRender(@Nullable Entity heldByEntity, @Nullable ItemStack stack, @Nonnull RenderContext renderContext) {
        GunContext gunContext;
        if (stack == null) {
            return;
        }
        ShooterContext shooterContext = ShooterContext.of(heldByEntity);
        GunContext gunContext2 = gunContext = shooterContext.IsValid() ? GunContext.of(shooterContext, MinecraftHelpers.getHand(renderContext.TransformType)) : GunContext.of(stack, EContextSide.Client);
        if (gunContext.IsValid()) {
            ActionStack actionStack = gunContext.GetActionStack();
            if (heldByEntity instanceof LocalPlayer) {
                for (ActionGroupInstance group : actionStack.GetActiveActionGroups()) {
                    for (ActionInstance action : group.GetActions()) {
                        if (action.ShouldRender(gunContext)) continue;
                        return;
                    }
                }
            }
            FlanimationDefinition animationSet = (FlanimationDefinition)FlansModClient.ANIMATIONS.Get(new ResourceLocation(gunContext.CacheGunDefinition().animationSet));
            ResourceLocation skin = this.getSkin(stack);
            this.renderSectionIteratively(renderContext, "body", partName -> skin, (partName, innerRenderContext) -> {
                ActionGroupContext primaryContext;
                innerRenderContext.Transforms.push();
                this.applyAnimations((RenderContext)innerRenderContext, animationSet, actionStack, (String)partName);
                if (partName.startsWith("grip") || partName.startsWith("barrel") || partName.startsWith("stock") || partName.startsWith("sights")) {
                    EAttachmentType attachmentType = EAttachmentType.Generic;
                    int attachmentIndex = -1;
                    if (partName.contains("_")) {
                        attachmentType = EAttachmentType.Parse(partName.split("_")[0]);
                        attachmentIndex = Integer.parseInt(partName.split("_")[1]);
                    } else {
                        attachmentType = EAttachmentType.Parse(partName);
                        attachmentIndex = 0;
                    }
                    return this.RenderAttachmentPoint(gunContext, (RenderContext)innerRenderContext, (String)partName, attachmentType, attachmentIndex);
                }
                if (partName.startsWith("ammo_") && (primaryContext = ActionGroupContext.CreateFrom(gunContext, "primary_fire")).IsValid()) {
                    String indexString = partName.substring("ammo_".length());
                    int magIndex = 0;
                    int bulletIndex = 0;
                    try {
                        if (indexString.contains("_")) {
                            String[] parts = indexString.split("_");
                            if (parts.length == 2) {
                                magIndex = Integer.parseInt(parts[0]);
                                bulletIndex = Integer.parseInt(parts[1]);
                            }
                        } else {
                            bulletIndex = Integer.parseInt(indexString);
                        }
                    }
                    catch (Exception parts) {
                        // empty catch block
                    }
                    MagazineDefinition magDef = primaryContext.GetMagazineType(magIndex);
                    if (magDef.ammoLoadMode == EAmmoLoadMode.OneBulletAtATime_Revolver) {
                        return !primaryContext.GetBulletAtIndex(magIndex, bulletIndex).m_41619_();
                    }
                    return true;
                }
                return true;
            }, (partName, innerRenderContext) -> innerRenderContext.Transforms.pop());
        }
    }

    private boolean RenderAttachmentPoint(GunContext gunContext, RenderContext renderContext, String partName, EAttachmentType attachmentType, int attachmentIndex) {
        AttachmentSettingsDefinition attachmentSettings = gunContext.CacheGunDefinition().GetAttachmentSettings(attachmentType);
        boolean anyAttachmentsPresent = false;
        ItemStack attachmentStack = gunContext.GetAttachmentStack(attachmentType, attachmentIndex);
        AttachmentDefinition attachment = gunContext.GetAttachmentDefinition(attachmentType, attachmentIndex);
        if (attachment != AttachmentDefinition.INVALID) {
            anyAttachmentsPresent = true;
            ITurboRenderer attachmentRenderer = FlansModelRegistry.GetItemRenderer(attachmentStack);
            if (attachmentRenderer instanceof AttachmentItemRenderer) {
                AttachmentItemRenderer attachmentItemRenderer = (AttachmentItemRenderer)attachmentRenderer;
                renderContext.Transforms.push();
                attachmentItemRenderer.RenderAsAttachment(renderContext, gunContext, attachmentType, attachmentIndex);
                renderContext.Transforms.pop();
            }
        }
        return !anyAttachmentsPresent || !attachmentSettings.hideDefaultMesh;
    }
}

