/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.gui.crafting;

import com.flansmod.client.gui.crafting.WorkbenchScreenTab;
import com.flansmod.common.FlansMod;
import com.flansmod.common.actions.contexts.GunContext;
import com.flansmod.common.crafting.ingredients.IExtraIngredientTooltip;
import com.flansmod.common.crafting.ingredients.TieredPartIngredient;
import com.flansmod.common.crafting.menus.WorkbenchMenuGunCrafting;
import com.flansmod.common.crafting.recipes.GunFabricationRecipe;
import com.flansmod.common.types.crafting.EMaterialType;
import com.flansmod.physics.common.util.Maths;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;

public class WorkbenchScreenTabGunCrafting
extends WorkbenchScreenTab<WorkbenchMenuGunCrafting> {
    private static final ResourceLocation GUN_FABRICATION_BG = new ResourceLocation("flansmod", "textures/gui/gun_fabrication.png");
    private static final int FAB_W = 512;
    private static final int FAB_H = 256;
    private final List<Pair<Integer, GunFabricationRecipe>> FilteredGunsList = new ArrayList<Pair<Integer, GunFabricationRecipe>>();
    private float gunSelectorScrollOffset = 0.0f;
    private static final int GUN_SELECTOR_X_ORIGIN = 5;
    private static final int GUN_SELECTOR_Y_ORIGIN = 16;
    private static final int GUN_SELECTOR_COLUMNS = 9;
    private static final int GUN_SELECTOR_ROWS = 2;
    private Button[] GunSelectionButtons;
    private float ShowPotentialMatchTicker = 0.0f;
    private static final int GUN_STATS_X_ORIGIN = 160;
    private static final int GUN_STATS_Y_ORIGIN = 17;
    private static final String DISALLOWED_TAG = "crafting.disallowed_tag";
    private static final String REQUIRED_TAG = "crafting.required_tag";
    private float recipeSelectorScrollOffset = 0.0f;
    private static final int GUN_RECIPE_VIEWER_X_ORIGIN = 4;
    private static final int GUN_RECIPE_VIEWER_Y_ORIGIN = 64;
    private static final int GUN_RECIPE_VIEWER_COLUMNS = 6;
    private static final int GUN_RECIPE_VIEWER_ROWS = 1;
    private Button[] GoToPartCraftingButtons;
    private Button[] AutoFillCraftingButtons;

    public WorkbenchScreenTabGunCrafting(@Nonnull WorkbenchMenuGunCrafting menu, @Nonnull Inventory inventory, @Nonnull Component title) {
        super(menu, inventory, title);
    }

    @Override
    protected boolean IsTabPresent() {
        return ((WorkbenchMenuGunCrafting)this.Workbench).Def.gunCrafting.isActive;
    }

    @Override
    @Nonnull
    protected Component GetTitle() {
        return Component.m_237115_((String)"workbench.tab_gun_crafting");
    }

    @Override
    protected void InitTab() {
        int index;
        int i;
        int j;
        this.GunSelectionButtons = new Button[18];
        for (j = 0; j < 2; ++j) {
            for (i = 0; i < 9; ++i) {
                index = j * 9 + i;
                this.GunSelectionButtons[index] = Button.m_253074_((Component)Component.m_237119_(), t -> this.SelectRecipe(index)).m_252987_(this.xOrigin + 5 + i * 18, this.yOrigin + 16 + j * 18, 18, 18).m_253136_();
                this.m_7787_((GuiEventListener)this.GunSelectionButtons[index]);
            }
        }
        this.GoToPartCraftingButtons = new Button[6];
        this.AutoFillCraftingButtons = new Button[6];
        for (j = 0; j < 1; ++j) {
            for (i = 0; i < 6; ++i) {
                index = j * 6 + i;
                this.GoToPartCraftingButtons[index] = Button.m_253074_((Component)Component.m_237119_(), t -> this.GoToPartCrafting(index)).m_252987_(this.xOrigin + 4 + 11 + 22 * i, this.yOrigin + 64 + 36 + 30 * j, 9, 9).m_253136_();
                this.m_7787_((GuiEventListener)this.GoToPartCraftingButtons[index]);
                this.AutoFillCraftingButtons[index] = Button.m_253074_((Component)Component.m_237119_(), t -> this.AutoFillCraftingSlot(index)).m_252987_(this.xOrigin + 4 + 2 + 22 * i, this.yOrigin + 64 + 36 + 30 * j, 9, 9).m_253136_();
                this.m_7787_((GuiEventListener)this.AutoFillCraftingButtons[index]);
            }
        }
    }

    @Override
    protected void OnTabSelected(boolean selected) {
        this.RefreshGunCraftingFilters();
        this.UpdateActiveGunSelectionButtons();
        this.UpdateActiveRecipeButtons();
    }

    @Override
    protected void UpdateTab(boolean selected) {
        this.ShowPotentialMatchTicker += 0.05f;
        this.UpdateActiveGunSelectionButtons();
        this.UpdateActiveRecipeButtons();
    }

    @Override
    protected boolean OnMouseScroll(int xMouse, int yMouse, double scroll) {
        ClientLevel level;
        if (WorkbenchScreenTabGunCrafting.InBox(xMouse, yMouse, this.xOrigin + 5, 168, this.yOrigin + 16, 36)) {
            int numRows = Maths.max(this.FilteredGunsList.size() / 9 - 2 + 1, 0);
            this.gunSelectorScrollOffset = (float)((double)this.gunSelectorScrollOffset - scroll);
            this.gunSelectorScrollOffset = Maths.clamp(this.gunSelectorScrollOffset, 0.0f, (float)numRows);
            this.UpdateActiveGunSelectionButtons();
            return true;
        }
        if (WorkbenchScreenTabGunCrafting.InBox(xMouse, yMouse, this.xOrigin + 4, 126, this.yOrigin + 64, 30) && (level = Minecraft.m_91087_().f_91073_) != null) {
            GunFabricationRecipe gunFabRecipe = ((WorkbenchMenuGunCrafting)this.Workbench).Workbench.GetSelectedGunRecipe((Level)level);
            int numSlots = gunFabRecipe != null ? gunFabRecipe.InputIngredients.size() : 0;
            int numRows = Maths.max(numSlots / 6 - 1 + 1, 0);
            this.recipeSelectorScrollOffset = (float)((double)this.recipeSelectorScrollOffset - scroll);
            this.recipeSelectorScrollOffset = Maths.clamp(this.recipeSelectorScrollOffset, 0.0f, (float)numRows);
            this.UpdateActiveRecipeButtons();
            this.NetworkedButtonPress(4096 + Maths.floor(this.recipeSelectorScrollOffset));
            return true;
        }
        return false;
    }

    @Override
    protected boolean RenderTooltip(@Nonnull GuiGraphics graphics, int xMouse, int yMouse) {
        ItemStack stack;
        GunContext context;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return false;
        }
        GunFabricationRecipe gunFabRecipe = ((WorkbenchMenuGunCrafting)this.Workbench).Workbench.GetSelectedGunRecipe((Level)level);
        int numSlots = gunFabRecipe != null ? gunFabRecipe.InputIngredients.size() : 0;
        int firstRow = Maths.floor(this.recipeSelectorScrollOffset);
        for (int j = 0; j < 1; ++j) {
            for (int i = 0; i < 6; ++i) {
                Ingredient ingredient;
                int index = j * 6 + i;
                if (gunFabRecipe == null || index >= numSlots || !((ingredient = (Ingredient)gunFabRecipe.InputIngredients.get(index)) instanceof IExtraIngredientTooltip)) continue;
                IExtraIngredientTooltip partIngredient = (IExtraIngredientTooltip)ingredient;
                if (ingredient instanceof TieredPartIngredient) {
                    TieredPartIngredient tiered = (TieredPartIngredient)ingredient;
                    if (WorkbenchScreenTabGunCrafting.InBox(xMouse, yMouse, this.xOrigin + 4 + 22 * i, 22, this.yOrigin + 64 + 30 * j, 5)) {
                        graphics.m_280557_(this.font, (Component)Component.m_237110_((String)"crafting.match_tiers_above", (Object[])new Object[]{tiered.MaterialTierMin}), xMouse, yMouse);
                        return true;
                    }
                }
                if (WorkbenchScreenTabGunCrafting.InBox(xMouse, yMouse, this.xOrigin + 4 + 22 * i, 22, this.yOrigin + 64 + 5 + 30 * j, 20)) {
                    ArrayList<Component> lines = new ArrayList<Component>();
                    partIngredient.GenerateTooltip(lines, false);
                    graphics.m_280677_(this.font, lines, Optional.empty(), xMouse, yMouse);
                    return true;
                }
                if (WorkbenchScreenTabGunCrafting.InBox(xMouse, yMouse, this.xOrigin + 4 + 2 + 22 * i, 9, this.yOrigin + 64 + 36 + 30 * j, 9)) {
                    if (Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_7500_()) {
                        graphics.m_280557_(this.font, (Component)Component.m_237115_((String)"crafting.auto_cycle_parts_creative"), xMouse, yMouse);
                    } else {
                        graphics.m_280557_(this.font, (Component)Component.m_237115_((String)"crafting.auto_add_best_parts"), xMouse, yMouse);
                    }
                    return true;
                }
                if (!((WorkbenchMenuGunCrafting)this.Workbench).Def.partCrafting.isActive || !WorkbenchScreenTabGunCrafting.InBox(xMouse, yMouse, this.xOrigin + 4 + 11 + 22 * i, 9, this.yOrigin + 64 + 36 + 30 * j, 9)) continue;
                graphics.m_280557_(this.font, (Component)Component.m_237115_((String)"crafting.switch_to_part_crafting"), xMouse, yMouse);
                return true;
            }
        }
        List<GunFabricationRecipe> matchingGunRecipes = ((WorkbenchMenuGunCrafting)this.Workbench).Workbench.GetMatchingGunRecipes((Level)level);
        firstRow = Maths.floor(this.gunSelectorScrollOffset);
        for (int row = 0; row < 2; ++row) {
            int firstIndexInRow = (firstRow + row) * 9;
            for (int col = 0; col < 9; ++col) {
                int index = firstIndexInRow + col;
                if (index >= this.FilteredGunsList.size() || !WorkbenchScreenTabGunCrafting.InBox(xMouse, yMouse, this.xOrigin + 5 + 18 * col, 18, this.yOrigin + 16 + 18 * row, 18)) continue;
                GunFabricationRecipe entry = (GunFabricationRecipe)this.FilteredGunsList.get(index).getSecond();
                if (matchingGunRecipes.contains(entry)) {
                    graphics.m_280557_(this.font, (Component)Component.m_237110_((String)"tooltip.gun_fab.craftable", (Object[])new Object[]{entry.Result.m_41786_()}), xMouse, yMouse);
                } else {
                    graphics.m_280557_(this.font, entry.Result.m_41786_(), xMouse, yMouse);
                }
                return true;
            }
        }
        if (gunFabRecipe != null && (context = GunContext.of(stack = gunFabRecipe.Result)).IsValid()) {
            int statBoxX = this.xOrigin + 160;
            int statBoxY = this.yOrigin + 17 + 10;
            if (this.RenderTooltipForStatComparison(graphics, "spread", context, xMouse, yMouse, statBoxX, statBoxY)) {
                return true;
            }
            if (this.RenderTooltipForStatComparison(graphics, "impact_damage", context, xMouse, yMouse, statBoxX, statBoxY + 10)) {
                return true;
            }
            if (this.RenderTooltipForStatComparison(graphics, "speed", context, xMouse, yMouse, statBoxX + 32, statBoxY)) {
                return true;
            }
            if (this.RenderTooltipForStatComparison(graphics, "knockback", context, xMouse, yMouse, statBoxX + 32, statBoxY + 10)) {
                return true;
            }
            if (this.RenderTooltipForStatComparison(graphics, "bullet_count", context, xMouse, yMouse, statBoxX + 64, statBoxY)) {
                return true;
            }
            if (this.RenderTooltipForStatComparison(graphics, "vertical_recoil", context, xMouse, yMouse, statBoxX + 64, statBoxY + 10)) {
                return true;
            }
        }
        return false;
    }

    private boolean RenderTooltipForStatComparison(@Nonnull GuiGraphics graphics, @Nonnull String stat, @Nonnull GunContext context, int xMouse, int yMouse, int boxX, int boxY) {
        if (WorkbenchScreenTabGunCrafting.InBox(xMouse, yMouse, boxX, 30, boxY, 9)) {
            float value = context.ModifyFloat(stat).get();
            graphics.m_280557_(this.font, (Component)Component.m_237110_((String)("tooltip.format." + stat + ".advanced"), (Object[])new Object[]{Float.valueOf(value)}), xMouse, yMouse);
            return true;
        }
        return false;
    }

    public void DrawMaterialTypeBox(@Nonnull TieredPartIngredient tiered, @Nonnull EMaterialType materialType, @Nonnull GuiGraphics graphics, int x, int y, int iconX, int iconY, int mouseX, int mouseY) {
        if (tiered.IsMatchingMaterialType(materialType)) {
            graphics.m_280163_(GUN_FABRICATION_BG, x, y, (float)iconX, (float)iconY, 5, 4, 512, 256);
            if (WorkbenchScreenTabGunCrafting.InBox(mouseX, mouseY, x, 5, y, 4)) {
                graphics.m_280557_(Minecraft.m_91087_().f_91062_, materialType.ToComponent(), Maths.floor(mouseX), Maths.floor(mouseY));
            }
        }
    }

    @Override
    protected void RenderBG(@Nonnull GuiGraphics graphics, int xMouse, int yMouse) {
        graphics.m_280163_(GUN_FABRICATION_BG, this.xOrigin, this.yOrigin, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 512, 256);
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        GunFabricationRecipe gunFabRecipe = null;
        if (level != null && (gunFabRecipe = ((WorkbenchMenuGunCrafting)this.Workbench).Workbench.GetSelectedGunRecipe((Level)level)) != null) {
            ItemStack stack = gunFabRecipe.Result;
            this.Render3DGun(graphics, this.xOrigin + this.f_97726_ + 64, this.yOrigin + 64, (float)Minecraft.m_91087_().f_91073_.m_46467_() * 0.01f, -45.0f, stack);
        }
        graphics.m_280163_(GUN_FABRICATION_BG, this.xOrigin, this.yOrigin, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 512, 256);
        if (level != null) {
            int firstRow;
            if (gunFabRecipe != null) {
                int index;
                int numSlots = gunFabRecipe.InputIngredients.size();
                firstRow = Maths.floor(this.recipeSelectorScrollOffset);
                int lastRow = firstRow + 1 - 1;
                for (int y = 0; y < 1; ++y) {
                    for (int x = 0; x < 6; ++x) {
                        index = y * 6 + x;
                        if (index < numSlots) {
                            Ingredient ingredient = (Ingredient)gunFabRecipe.InputIngredients.get(index);
                            int slotX = this.xOrigin + 4 + x * 22;
                            int slotY = this.yOrigin + 64 + y * 30;
                            if (ingredient instanceof TieredPartIngredient) {
                                boolean mouseOverAutoAdd;
                                TieredPartIngredient tiered = (TieredPartIngredient)ingredient;
                                graphics.m_280163_(GUN_FABRICATION_BG, slotX, slotY, (float)(257 + 22 * tiered.MaterialTierMin), 95.0f, 22, 47, 512, 256);
                                PartBackgroundType backgroundType = PartBackgroundType.GetFromTag(tiered.MatchTag);
                                if (backgroundType != PartBackgroundType.Unknown) {
                                    graphics.m_280163_(GUN_FABRICATION_BG, slotX + 3, slotY + 8, (float)backgroundType.texX, (float)backgroundType.texY, 16, 16, 512, 256);
                                }
                                this.DrawMaterialTypeBox(tiered, EMaterialType.Wood, graphics, slotX + 3, slotY + 26, 259, 145, xMouse, yMouse);
                                this.DrawMaterialTypeBox(tiered, EMaterialType.Glass, graphics, slotX + 9, slotY + 26, 265, 145, xMouse, yMouse);
                                this.DrawMaterialTypeBox(tiered, EMaterialType.Metal, graphics, slotX + 15, slotY + 26, 271, 145, xMouse, yMouse);
                                this.DrawMaterialTypeBox(tiered, EMaterialType.Composite, graphics, slotX + 3, slotY + 31, 259, 150, xMouse, yMouse);
                                this.DrawMaterialTypeBox(tiered, EMaterialType.Electronic, graphics, slotX + 9, slotY + 31, 265, 150, xMouse, yMouse);
                                this.DrawMaterialTypeBox(tiered, EMaterialType.Fabric, graphics, slotX + 15, slotY + 31, 271, 150, xMouse, yMouse);
                                if (((WorkbenchMenuGunCrafting)this.Workbench).Def.partCrafting.isActive) {
                                    boolean mouseOverPartCrafting = WorkbenchScreenTabGunCrafting.InBox(xMouse, yMouse, slotX + 11, 9, slotY + 36, 9);
                                    graphics.m_280163_(GUN_FABRICATION_BG, slotX + 11, slotY + 36, mouseOverPartCrafting ? 325.0f : 312.0f, 152.0f, 9, 9, 512, 256);
                                }
                                graphics.m_280163_(GUN_FABRICATION_BG, slotX + 2, slotY + 36, (mouseOverAutoAdd = WorkbenchScreenTabGunCrafting.InBox(xMouse, yMouse, slotX + 2, 9, slotY + 36, 9)) ? 325.0f : 303.0f, 143.0f, 9, 9, 512, 256);
                                continue;
                            }
                            graphics.m_280163_(GUN_FABRICATION_BG, slotX, slotY, 257.0f, 95.0f, 22, 47, 512, 256);
                            if (ingredient.m_43908_().length <= 0) continue;
                            int potentialMatch = Maths.floor(this.ShowPotentialMatchTicker) % ingredient.m_43908_().length;
                            graphics.m_280480_(ingredient.m_43908_()[potentialMatch], slotX + 3, slotY + 28);
                            continue;
                        }
                        if (index >= ((WorkbenchMenuGunCrafting)this.Workbench).GunCraftingInputContainer.m_6643_() || ((WorkbenchMenuGunCrafting)this.Workbench).GunCraftingInputContainer.m_8020_(index).m_41619_()) continue;
                        int slotX = this.xOrigin + 4 + x * 22;
                        int slotY = this.yOrigin + 64 + y * 30;
                        graphics.m_280163_(GUN_FABRICATION_BG, slotX + 1, slotY + 6, 172.0f, 144.0f, 20, 20, 512, 256);
                    }
                }
                int numRecipeRows = gunFabRecipe.InputIngredients.size() / 6 - 1 + 1;
                this.RenderScrollbar(graphics, this.xOrigin + 4 + 120, this.yOrigin + 64, 6, 30, this.recipeSelectorScrollOffset, 0.0f, numRecipeRows);
                int statBoxX = this.xOrigin + 160;
                index = this.yOrigin + 17 + 10;
            }
            List<GunFabricationRecipe> matchingGunRecipes = ((WorkbenchMenuGunCrafting)this.Workbench).Workbench.GetMatchingGunRecipes((Level)level);
            firstRow = Maths.floor(this.gunSelectorScrollOffset);
            for (int row = 0; row < 2; ++row) {
                int firstIndexInRow = (firstRow + row) * 9;
                int numEntriesInRow = Maths.min(9, this.FilteredGunsList.size() - firstIndexInRow);
                graphics.m_280163_(GUN_FABRICATION_BG, this.xOrigin + 5, this.yOrigin + 16 + row * 18, 172.0f, 0.0f, 18 * numEntriesInRow, 18, 512, 256);
                for (int i = 0; i < numEntriesInRow; ++i) {
                    int selectedIndex = (Integer)this.FilteredGunsList.get(firstIndexInRow + i).getFirst();
                    GunFabricationRecipe recipe = (GunFabricationRecipe)this.FilteredGunsList.get(firstIndexInRow + i).getSecond();
                    if (selectedIndex == ((WorkbenchMenuGunCrafting)this.Workbench).Workbench.PlayerSelectedCraftingGun) {
                        graphics.m_280163_(GUN_FABRICATION_BG, this.xOrigin + 5 + i * 18, this.yOrigin + 16 + row * 18, 173.0f, 145.0f, 18, 18, 512, 256);
                    }
                    if (!matchingGunRecipes.contains(recipe)) continue;
                    graphics.m_280163_(GUN_FABRICATION_BG, this.xOrigin + 5 + 1 + i * 18, this.yOrigin + 16 + 1 + row * 18, 234.0f, 126.0f, 16, 16, 512, 256);
                }
            }
        }
        int numRows = this.FilteredGunsList.size() / 9 - 2 + 1;
        this.RenderScrollbar(graphics, this.xOrigin + 5 + 162, this.yOrigin + 16, 6, 90, this.gunSelectorScrollOffset, 0.0f, numRows);
    }

    @Override
    protected void RenderFG(@Nonnull GuiGraphics graphics, int xMouse, int yMouse) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            int firstRow;
            GunFabricationRecipe gunFabRecipe = ((WorkbenchMenuGunCrafting)this.Workbench).Workbench.GetSelectedGunRecipe((Level)level);
            if (gunFabRecipe != null) {
                graphics.m_280614_(this.font, gunFabRecipe.Result.m_41786_(), 6, 53, 0x404040, false);
            } else {
                graphics.m_280614_(this.font, (Component)Component.m_237115_((String)"crafting.select_a_recipe"), 6, 53, 0x404040, false);
            }
            if (gunFabRecipe != null) {
                firstRow = Maths.floor(this.recipeSelectorScrollOffset);
                for (int y = 0; y < 1; ++y) {
                    for (int x = 0; x < 6; ++x) {
                        int index = (firstRow + y) * 6 + x;
                        if (index >= gunFabRecipe.InputIngredients.size()) continue;
                    }
                }
            }
            firstRow = Maths.floor(this.gunSelectorScrollOffset);
            for (int row = 0; row < 2; ++row) {
                int firstIndexInRow = (firstRow + row) * 9;
                for (int col = 0; col < 9; ++col) {
                    GunFabricationRecipe entry;
                    int index = firstIndexInRow + col;
                    if (index >= this.FilteredGunsList.size() || (entry = (GunFabricationRecipe)this.FilteredGunsList.get(index).getSecond()) == null) continue;
                    ItemStack stack = entry.Result;
                    this.RenderGUIItem(graphics, 6 + 18 * col, 17 + 18 * row, stack, true);
                }
            }
        }
    }

    private void UpdateActiveGunSelectionButtons() {
        if (this.GunSelectionButtons != null) {
            for (int j = 0; j < 2; ++j) {
                for (int i = 0; i < 9; ++i) {
                    int firstIndex = Maths.floor(this.gunSelectorScrollOffset) * 9;
                    int relativeIndex = i + 9 * j;
                    this.GunSelectionButtons[relativeIndex].f_93623_ = this.IsActive && firstIndex + relativeIndex < this.FilteredGunsList.size();
                }
            }
        }
    }

    private void UpdateActiveRecipeButtons() {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            int firstIndex = Maths.floor(this.recipeSelectorScrollOffset) * 6;
            GunFabricationRecipe gunFabRecipe = ((WorkbenchMenuGunCrafting)this.Workbench).Workbench.GetSelectedGunRecipe((Level)level);
            int numSlots = gunFabRecipe != null ? gunFabRecipe.InputIngredients.size() : 0;
            for (int j = 0; j < 1; ++j) {
                for (int i = 0; i < 6; ++i) {
                    int relativeIndex = i + 6 * j;
                    if (this.GoToPartCraftingButtons != null) {
                        boolean bl = this.GoToPartCraftingButtons[relativeIndex].f_93623_ = this.IsActive && ((WorkbenchMenuGunCrafting)this.Workbench).Def.partCrafting.isActive && firstIndex + relativeIndex < numSlots;
                    }
                    if (this.AutoFillCraftingButtons == null) continue;
                    this.AutoFillCraftingButtons[relativeIndex].f_93623_ = this.IsActive && firstIndex + relativeIndex < numSlots;
                }
            }
        }
    }

    private void RefreshGunCraftingFilters() {
        this.FilteredGunsList.clear();
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            List<GunFabricationRecipe> allRecipes = ((WorkbenchMenuGunCrafting)this.Workbench).Workbench.GetAllGunRecipes((Level)level);
            for (int i = 0; i < allRecipes.size(); ++i) {
                this.FilteredGunsList.add((Pair<Integer, GunFabricationRecipe>)Pair.of((Object)i, (Object)allRecipes.get(i)));
            }
        }
    }

    private void SelectRecipe(int relativeIndex) {
        int filteredIndex = Maths.floor(this.gunSelectorScrollOffset) * 9 + relativeIndex;
        if (filteredIndex < this.FilteredGunsList.size()) {
            int absoluteIndex = (Integer)this.FilteredGunsList.get(filteredIndex).getFirst();
            this.NetworkedButtonPress(0 + absoluteIndex);
        } else {
            FlansMod.LOGGER.warn("Tried to select invalid (filtered) Gun recipe " + filteredIndex + "/" + this.FilteredGunsList.size());
        }
    }

    private void AutoFillCraftingSlot(int relativeIndex) {
        this.NetworkedButtonPress(128 + relativeIndex + Maths.floor(this.recipeSelectorScrollOffset));
    }

    private void GoToPartCrafting(int relativeIndex) {
        int partIndex = Maths.floor(this.recipeSelectorScrollOffset) + relativeIndex;
    }

    private static enum PartBackgroundType {
        Barrel(0, 0),
        UpperReceiver(1, 0),
        LowerReciever(2, 0),
        Stock(3, 0),
        Grip(4, 0),
        Handguard(11, 0),
        BoltAction(12, 0),
        RevolverAction(13, 0),
        Scope(5, 0),
        Armour(6, 0),
        Seat(7, 0),
        Wheel(8, 0),
        Canvas(9, 0),
        Fabric(10, 0),
        Unknown(2, 1),
        Powder(3, 1),
        Ingot(4, 1),
        Plate(5, 1),
        Circuitry(7, 1),
        Engine(8, 1),
        StructuralParts(9, 1),
        Propeller(10, 1),
        MechanicalParts(11, 1);

        public final int texX;
        public final int texY;

        public static PartBackgroundType GetFromTag(ResourceLocation tag) {
            switch (tag.toString()) {
                case "flansmod:barrel": {
                    return Barrel;
                }
                case "flansmod:upper_receiver": {
                    return UpperReceiver;
                }
                case "flansmod:lower_receiver": {
                    return LowerReciever;
                }
                case "flansmod:stock": {
                    return Stock;
                }
                case "flansmod:grip": {
                    return Grip;
                }
                case "flansmod:handguard": {
                    return Handguard;
                }
                case "flansmod:bolt_action": {
                    return BoltAction;
                }
                case "flansmod:revolver_action": {
                    return RevolverAction;
                }
                case "flansmod:scope": {
                    return Scope;
                }
                case "flansmod:armour": {
                    return Armour;
                }
                case "flansmod:seat": {
                    return Seat;
                }
                case "flansmod:wheel": {
                    return Wheel;
                }
                case "flansmod:canvas": {
                    return Canvas;
                }
                case "flansmod:fabric": {
                    return Fabric;
                }
                case "flansmod:circuitry": {
                    return Circuitry;
                }
                case "flansmod:engine": {
                    return Engine;
                }
                case "flansmod:structural_parts": {
                    return StructuralParts;
                }
                case "flansmod:propeller": {
                    return Propeller;
                }
                case "flansmod:mechanical_parts": {
                    return MechanicalParts;
                }
            }
            return Unknown;
        }

        private PartBackgroundType(int x, int y) {
            this.texX = 2 + x * 18;
            this.texY = 220 + y * 18;
        }
    }
}

