/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.gui.crafting;

import com.flansmod.client.gui.FMScreen;
import com.flansmod.client.render.RenderContext;
import com.flansmod.client.render.models.FlansModelRegistry;
import com.flansmod.client.render.models.ITurboRenderer;
import com.flansmod.common.crafting.menus.WorkbenchMenu;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.MinecraftHelpers;
import com.flansmod.physics.common.util.TransformStack;
import com.mojang.blaze3d.platform.Lighting;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Quaternionf;

public abstract class WorkbenchScreenTab<T extends WorkbenchMenu>
extends FMScreen<T> {
    @Nonnull
    protected final T Workbench;
    @Nonnull
    protected final Font font;
    protected boolean IsActive;
    public int xOrigin;
    public int yOrigin;
    private final ResourceLocation FM_SHARED_GUI = new ResourceLocation("flansmod", "textures/gui/workbench_shared.png");
    private final int SHARED_W = 256;
    private final int SHARED_H = 256;

    public WorkbenchScreenTab(@Nonnull T menu, @Nonnull Inventory inventory, @Nonnull Component title) {
        super(menu, inventory, title);
        this.font = Minecraft.m_91087_().f_91062_;
        this.Workbench = menu;
        this.IsActive = true;
        this.f_97726_ = 172;
        this.f_97727_ = 218;
        this.f_97729_ = -1000;
        this.f_97730_ = 6;
        this.f_97731_ = 124;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.xOrigin = this.f_96543_ / 2 - this.f_97726_ / 2;
        this.yOrigin = this.f_96544_ / 2 - this.f_97727_ / 2;
        if (this.IsTabPresent()) {
            this.InitTab();
            this.OnTabSelected(true);
        } else {
            Minecraft.m_91087_().m_91152_(null);
        }
    }

    protected void m_181908_() {
        this.UpdateTab(true);
    }

    public boolean m_6050_(double x, double y, double scroll) {
        return this.OnMouseScroll(Maths.floor(x), Maths.floor(y), scroll);
    }

    protected void m_7286_(@Nonnull GuiGraphics graphics, float f, int xMouse, int yMouse) {
        graphics.m_280168_().m_85836_();
        this.RenderBG(graphics, xMouse, yMouse);
        graphics.m_280168_().m_85849_();
    }

    public void m_88315_(@Nonnull GuiGraphics graphics, int xMouse, int yMouse, float f) {
        super.m_88315_(graphics, xMouse, yMouse, f);
        if (((WorkbenchMenu)this.f_97732_).m_142621_().m_41619_() && this.f_97734_ != null && this.f_97734_.m_6657_()) {
            super.m_280072_(graphics, xMouse, yMouse);
            return;
        }
        this.RenderTooltip(graphics, xMouse, yMouse);
    }

    protected void m_280003_(@Nonnull GuiGraphics graphics, int x, int y) {
        super.m_280003_(graphics, x, y);
        graphics.m_280168_().m_85836_();
        graphics.m_280614_(this.font, this.GetTitle(), this.f_97728_, 5, 0x505050, false);
        this.RenderFG(graphics, x, y);
        graphics.m_280168_().m_85849_();
    }

    @Nonnull
    protected abstract Component GetTitle();

    protected abstract boolean IsTabPresent();

    protected abstract void InitTab();

    protected abstract void OnTabSelected(boolean var1);

    protected abstract void UpdateTab(boolean var1);

    protected abstract boolean OnMouseScroll(int var1, int var2, double var3);

    protected int GetWidth() {
        return 172;
    }

    protected int GetHeight() {
        return 217;
    }

    protected abstract boolean RenderTooltip(@Nonnull GuiGraphics var1, int var2, int var3);

    protected abstract void RenderBG(@Nonnull GuiGraphics var1, int var2, int var3);

    protected abstract void RenderFG(@Nonnull GuiGraphics var1, int var2, int var3);

    public void RenderPowerBarBG(@Nonnull GuiGraphics graphics, int x, int y, int fe, int feMax) {
        graphics.m_280163_(this.FM_SHARED_GUI, x, y, 76.0f, 0.0f, 51, 12, 256, 256);
        int px = (int)(51.0f * (float)fe / (float)feMax);
        graphics.m_280163_(this.FM_SHARED_GUI, x, y, 76.0f, 13.0f, px, 12, 256, 256);
    }

    public void RenderPowerBarFG(@Nonnull GuiGraphics graphics, int x, int y, int fe, int feMax) {
        String storedEnergyAmount = MinecraftHelpers.getFEString(fe) + " / " + MinecraftHelpers.getFEString(feMax);
        graphics.m_280056_(this.font, storedEnergyAmount, Maths.floor((float)x - (float)this.font.m_92895_(storedEnergyAmount) / 2.0f), y, 0x505050, false);
    }

    protected void RenderGUIItem(@Nonnull GuiGraphics graphics, int x, int y, @Nonnull ItemStack stack, boolean withText) {
        graphics.m_280480_(stack, x, y);
        if (withText) {
            graphics.m_280370_(this.font, stack, x, y);
        }
    }

    protected void Render3DGun(@Nonnull GuiGraphics graphics, int x, int y, float yaw, float pitch, @Nonnull ItemStack stack) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)x, (float)y, 0.0f);
        graphics.m_280168_().m_85841_(32.0f, 32.0f, 32.0f);
        graphics.m_280168_().m_252781_(new Quaternionf().rotateLocalX(pitch * ((float)Math.PI / 180)).rotateLocalY(yaw * ((float)Math.PI / 180)));
        ITurboRenderer gunRenderer = FlansModelRegistry.GetItemRenderer(stack);
        if (gunRenderer != null) {
            graphics.m_280168_().m_85836_();
            Lighting.m_166384_();
            MultiBufferSource.BufferSource buffers = Minecraft.m_91087_().m_91269_().m_110104_();
            graphics.m_280168_().m_252781_(new Quaternionf().rotateLocalX((float)Math.PI));
            graphics.m_280168_().m_252781_(new Quaternionf().rotateLocalY((float)Math.PI));
            TransformStack transformStack = TransformStack.of(graphics.m_280168_());
            gunRenderer.renderDirect(null, stack, new RenderContext((MultiBufferSource)buffers, ItemDisplayContext.FIXED, transformStack, 0xF000F0, 655360));
            buffers.m_109911_();
            Lighting.m_84931_();
            graphics.m_280168_().m_85849_();
        }
        graphics.m_280168_().m_85849_();
    }

    protected void RenderStatComparisonBar(@Nonnull GuiGraphics graphics, int x, int y, float value, float compareTo, float minValue, float maxValue, int icon) {
        graphics.m_280163_(this.FM_SHARED_GUI, x, y, 220.0f, (float)(18 + icon * 9), 8, 8, 256, 256);
        graphics.m_280163_(this.FM_SHARED_GUI, x + 8, y, 173.0f, 108.0f, 22, 9, 256, 256);
        float valueParam = (value - minValue) / (maxValue - minValue);
        float compareToParam = (compareTo - minValue) / (maxValue - minValue);
        int valuePx = Maths.floor(20.0f * Maths.clamp(valueParam, 0.0f, 1.0f));
        int compareToPx = Maths.floor(20.0f * Maths.clamp(compareToParam, 0.0f, 1.0f));
        if (!(value > compareTo) && !(value < compareTo)) {
            graphics.m_280163_(this.FM_SHARED_GUI, x + 9, y + 2, 174.0f, 119.0f, valuePx, 5, 256, 256);
        }
    }

    protected void RenderScrollbar(@Nonnull GuiGraphics graphics, int x, int y, int scrollbarPxWidth, int scrollbarPxHeight, float value, float min, float max) {
        if (max < 0.0f || Maths.approx(min, max)) {
            return;
        }
        graphics.m_280163_(this.FM_SHARED_GUI, x, y, 214.0f, 18.0f, scrollbarPxWidth, 8, 256, 256);
        for (int i = 8; i < scrollbarPxHeight; i += 32) {
            int tileMin = i;
            int tileMax = Maths.min(i + 32, scrollbarPxHeight - 8);
            graphics.m_280163_(this.FM_SHARED_GUI, x, y + tileMin, 214.0f, 26.0f, scrollbarPxWidth, tileMax - tileMin, 256, 256);
        }
        graphics.m_280163_(this.FM_SHARED_GUI, x, y + scrollbarPxHeight - 8, 214.0f, 82.0f, scrollbarPxWidth, 8, 256, 256);
        int scrollbarMinSize = 16;
        float parametric = value / (max - min);
        float scrollbarPxSize = Maths.max((float)scrollbarPxHeight / (max - min), (float)scrollbarMinSize);
        float minPx = Maths.lerpF(0.0f, (float)scrollbarPxHeight - scrollbarPxSize, parametric);
        float maxPx = Maths.lerpF(scrollbarPxSize, scrollbarPxHeight, parametric);
        graphics.m_280163_(this.FM_SHARED_GUI, x, y + Maths.floor(minPx), 208.0f, 18.0f, scrollbarPxWidth, Maths.floor(scrollbarPxSize) - 8, 256, 256);
        graphics.m_280163_(this.FM_SHARED_GUI, x, y + Maths.floor(maxPx) - 8, 208.0f, 82.0f, scrollbarPxWidth, 8, 256, 256);
    }

    protected boolean NetworkedButtonPress(int buttonID) {
        if (Minecraft.m_91087_().f_91072_ == null || Minecraft.m_91087_().f_91074_ == null) {
            return false;
        }
        this.Workbench.m_6366_((Player)Minecraft.m_91087_().f_91074_, buttonID);
        Minecraft.m_91087_().f_91072_.m_105208_(((WorkbenchMenu)((Object)this.Workbench)).f_38840_, buttonID);
        return true;
    }
}

