/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client;

import com.flansmod.client.ClientActionManager;
import com.flansmod.client.ClientContextCache;
import com.flansmod.client.ClientInventoryManager;
import com.flansmod.client.ClientLongDistanceEntitySystem;
import com.flansmod.client.RecoilManager;
import com.flansmod.client.gui.crafting.WorkbenchScreenTabGunCrafting;
import com.flansmod.client.gui.crafting.WorkbenchScreenTabMaterials;
import com.flansmod.client.gui.crafting.WorkbenchScreenTabModification;
import com.flansmod.client.gui.crafting.WorkbenchScreenTabPainting;
import com.flansmod.client.gui.crafting.WorkbenchScreenTabPartCrafting;
import com.flansmod.client.gui.crafting.WorkbenchScreenTabPower;
import com.flansmod.client.gui.turret.TurretScreen;
import com.flansmod.client.input.ClientInputHooks;
import com.flansmod.client.render.ClientRenderHooks;
import com.flansmod.client.render.FirstPersonManager;
import com.flansmod.client.render.MagazineTextureAtlas;
import com.flansmod.client.render.animation.FlanimationDefinitions;
import com.flansmod.client.render.bullets.BulletEntityRenderer;
import com.flansmod.client.render.bullets.CasingEntityItemRenderer;
import com.flansmod.client.render.bullets.CasingEntityRenderer;
import com.flansmod.client.render.bullets.CasingRenderer;
import com.flansmod.client.render.bullets.ShotRenderer;
import com.flansmod.client.render.effects.DecalRenderer;
import com.flansmod.client.render.effects.EffectRenderer;
import com.flansmod.client.render.effects.FlashEffectRenderer;
import com.flansmod.client.render.effects.LaserRenderer;
import com.flansmod.client.render.models.FlansModelRegistry;
import com.flansmod.client.render.models.ITurboRenderer;
import com.flansmod.client.render.vehicles.VehicleDebugRenderer;
import com.flansmod.common.FlansMod;
import com.flansmod.common.actions.contexts.ActionGroupContext;
import com.flansmod.common.actions.contexts.ContextCache;
import com.flansmod.common.actions.contexts.GunContext;
import com.flansmod.common.actions.contexts.GunContextPlayer;
import com.flansmod.common.actions.contexts.GunshotContext;
import com.flansmod.common.actions.contexts.ShooterContext;
import com.flansmod.common.actions.nodes.SpawnParticleAction;
import com.flansmod.common.gunshots.Raytracer;
import com.flansmod.common.types.guns.elements.ESpreadPattern;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.MinecraftHelpers;
import com.flansmod.physics.common.util.Transform;
import com.flansmod.physics.common.util.TransformStack;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.ItemModelShaper;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD, modid="flansmod")
public class FlansModClient {
    public static final ClientInventoryManager INVENTORY_MANAGER = new ClientInventoryManager();
    public static final VehicleDebugRenderer VEHICLE_DEBUG_RENDERER = new VehicleDebugRenderer();
    public static final ShotRenderer SHOT_RENDERER = new ShotRenderer();
    public static final LaserRenderer LASER_RENDERER = new LaserRenderer();
    public static final FlashEffectRenderer FLASH_RENDERER = new FlashEffectRenderer();
    public static final CasingEntityItemRenderer CASING_RENDERER = new CasingEntityItemRenderer();
    public static final ClientInputHooks CLIENT_INPUT_HOOKS = new ClientInputHooks();
    public static final ClientRenderHooks CLIENT_OVERLAY_HOOKS = new ClientRenderHooks();
    public static final FlansModelRegistry MODEL_REGISTRATION = new FlansModelRegistry();
    public static final FlanimationDefinitions ANIMATIONS = new FlanimationDefinitions();
    public static final DecalRenderer DECAL_RENDERER = new DecalRenderer();
    public static final MagazineTextureAtlas MAGAZINE_ATLAS = new MagazineTextureAtlas();
    public static final RecoilManager RECOIL = new RecoilManager();
    public static final ClientActionManager ACTIONS_CLIENT = new ClientActionManager();
    public static final ContextCache CONTEXT_CACHE = new ClientContextCache();
    public static final ClientLongDistanceEntitySystem CLIENT_LONG_DISTANCE = new ClientLongDistanceEntitySystem();
    public static long PREV_FRAME_NS = 0L;
    public static long THIS_FRAME_NS = 0L;
    @Nullable
    private static ShaderInstance GUN_SOLID;
    @Nullable
    private static ShaderInstance GUN_CUTOUT;
    @Nullable
    private static ShaderInstance GUN_EMISSIVE;
    @Nullable
    private static ShaderInstance GUN_TRANSPARENT;
    private static final Field MINECRAFT_MISS_TIME;
    private static final Field ITEM_IN_HAND_RENDERER_MAIN_HAND_HEIGHT;
    private static final Field ITEM_IN_HAND_RENDERER_O_MAIN_HAND_HEIGHT;
    private static final Field ITEM_IN_HAND_RENDERER_OFF_HAND_HEIGHT;
    private static final Field ITEM_IN_HAND_RENDERER_O_OFF_HAND_HEIGHT;
    private static final Method GET_FOV;

    public static float FrameDeltaSeconds() {
        return (float)(THIS_FRAME_NS - PREV_FRAME_NS) / 1.0E9f;
    }

    public static float FrameAbsoluteSeconds() {
        return (float)THIS_FRAME_NS / 1.0E9f;
    }

    @SubscribeEvent
    public static void ClientInit(FMLClientSetupEvent event) {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ACTIONS_CLIENT.HookClient(modEventBus);
        MODEL_REGISTRATION.Hook(modEventBus);
        modEventBus.register((Object)ANIMATIONS);
        MAGAZINE_ATLAS.Init();
        FlansModClient.InitReflection();
        MenuScreens.m_96206_((MenuType)((MenuType)FlansMod.WORKBENCH_MENU_GUN_CRAFTING.get()), WorkbenchScreenTabGunCrafting::new);
        MenuScreens.m_96206_((MenuType)((MenuType)FlansMod.WORKBENCH_MENU_MODIFICATION.get()), WorkbenchScreenTabModification::new);
        MenuScreens.m_96206_((MenuType)((MenuType)FlansMod.WORKBENCH_MENU_PAINTING.get()), WorkbenchScreenTabPainting::new);
        MenuScreens.m_96206_((MenuType)((MenuType)FlansMod.WORKBENCH_MENU_PART_CRAFTING.get()), WorkbenchScreenTabPartCrafting::new);
        MenuScreens.m_96206_((MenuType)((MenuType)FlansMod.WORKBENCH_MENU_POWER.get()), WorkbenchScreenTabPower::new);
        MenuScreens.m_96206_((MenuType)((MenuType)FlansMod.WORKBENCH_MENU_MATERIALS.get()), WorkbenchScreenTabMaterials::new);
        MenuScreens.m_96206_((MenuType)((MenuType)FlansMod.TURRET_MENU.get()), TurretScreen::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)FlansMod.ENT_TYPE_BULLET.get()), BulletEntityRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)FlansMod.ENT_TYPE_CASING.get()), CasingEntityRenderer::new);
        MinecraftForge.EVENT_BUS.addListener(FlansModClient::RenderTick);
        MinecraftForge.EVENT_BUS.addListener(FlansModClient::OnLevelLoad);
    }

    public static void OnLevelLoad(LevelEvent.Load event) {
        if (event.getLevel().m_5776_()) {
            new Raytracer(event.getLevel()).hook();
        }
    }

    public static void OnLevelUnload(LevelEvent.Unload event) {
        if (event.getLevel().m_5776_()) {
            CONTEXT_CACHE.OnLevelUnloaded(ACTIONS_CLIENT);
        }
    }

    @SubscribeEvent
    public static void OnRegisterGeometryLoaders(ModelEvent.RegisterGeometryLoaders event) {
        MODEL_REGISTRATION.OnRegisterGeometryLoaders(event);
    }

    @SubscribeEvent
    public static void ModelRegistryEvent(ModelEvent.RegisterAdditional event) {
        ItemModelShaper shaper = Minecraft.m_91087_().m_91291_().m_115103_();
        for (RegistryObject entry : FlansMod.ITEMS.getEntries()) {
            event.register((ResourceLocation)new ModelResourceLocation(entry.getId(), "inventory"));
            shaper.m_109396_((Item)entry.get(), new ModelResourceLocation(entry.getId(), "inventory"));
        }
        for (ResourceLocation resourceLocation : FlansMod.GUNS.getIds()) {
        }
    }

    @Nullable
    public static ShaderInstance GetGunSolidShader() {
        return GUN_SOLID;
    }

    @Nullable
    public static ShaderInstance GetGunCutoutShader() {
        return GUN_CUTOUT;
    }

    @Nullable
    public static ShaderInstance GetGunEmissiveShader() {
        return GUN_EMISSIVE;
    }

    @Nullable
    public static ShaderInstance GetGunTransparentShader() {
        return GUN_TRANSPARENT;
    }

    @SubscribeEvent
    public static void ShaderRegistryEvent(RegisterShadersEvent event) {
        try {
            event.registerShader(new ShaderInstance(event.getResourceProvider(), "flansmod:rendertype_flans_gun_solid", DefaultVertexFormat.f_85811_), shader -> {
                GUN_SOLID = shader;
            });
            event.registerShader(new ShaderInstance(event.getResourceProvider(), "flansmod:rendertype_flans_gun_cutout", DefaultVertexFormat.f_85811_), shader -> {
                GUN_CUTOUT = shader;
            });
            event.registerShader(new ShaderInstance(event.getResourceProvider(), "flansmod:rendertype_flans_gun_emissive", DefaultVertexFormat.f_85811_), shader -> {
                GUN_EMISSIVE = shader;
            });
            event.registerShader(new ShaderInstance(event.getResourceProvider(), "flansmod:rendertype_flans_gun_transparent", DefaultVertexFormat.f_85811_), shader -> {
                GUN_TRANSPARENT = shader;
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void RenderTick(TickEvent.RenderTickEvent event) {
        PREV_FRAME_NS = THIS_FRAME_NS;
        THIS_FRAME_NS = Util.m_137569_();
        FirstPersonManager.RenderTick();
    }

    @SubscribeEvent
    public static void RegisterClientReloadListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)MAGAZINE_ATLAS);
        event.registerReloadListener((PreparableReloadListener)ANIMATIONS);
        FlansMod.RegisterCommonReloadListeners(arg_0 -> ((RegisterClientReloadListenersEvent)event).registerReloadListener(arg_0));
    }

    private static void InitReflection() {
        MINECRAFT_MISS_TIME.setAccessible(true);
        ITEM_IN_HAND_RENDERER_MAIN_HAND_HEIGHT.setAccessible(true);
        ITEM_IN_HAND_RENDERER_O_MAIN_HAND_HEIGHT.setAccessible(true);
        ITEM_IN_HAND_RENDERER_OFF_HAND_HEIGHT.setAccessible(true);
        ITEM_IN_HAND_RENDERER_O_OFF_HAND_HEIGHT.setAccessible(true);
        GET_FOV.setAccessible(true);
    }

    public static double GetFOV(Camera camera, float dt, boolean applyFOVSetting) {
        try {
            return (Double)GET_FOV.invoke((Object)Minecraft.m_91087_().f_91063_, camera, Float.valueOf(dt), applyFOVSetting);
        }
        catch (Exception e) {
            FlansMod.LOGGER.error("Failed to GetFOV due to " + e);
            return 1.0;
        }
    }

    public static float GetHandHeight(InteractionHand hand, float dt) {
        try {
            ItemInHandRenderer iihr = Minecraft.m_91087_().f_91063_.f_109055_;
            switch (hand) {
                case MAIN_HAND: {
                    return Maths.lerpF(((Float)ITEM_IN_HAND_RENDERER_O_MAIN_HAND_HEIGHT.get(iihr)).floatValue(), ((Float)ITEM_IN_HAND_RENDERER_MAIN_HAND_HEIGHT.get(iihr)).floatValue(), dt);
                }
                case OFF_HAND: {
                    return Maths.lerpF(((Float)ITEM_IN_HAND_RENDERER_O_OFF_HAND_HEIGHT.get(iihr)).floatValue(), ((Float)ITEM_IN_HAND_RENDERER_OFF_HAND_HEIGHT.get(iihr)).floatValue(), dt);
                }
            }
        }
        catch (Exception e) {
            FlansMod.LOGGER.error("Failed to GetHandHeight due to " + e);
        }
        return 0.0f;
    }

    public static void SetMissTime(int missTime) {
        try {
            MINECRAFT_MISS_TIME.set(Minecraft.m_91087_(), missTime);
        }
        catch (Exception e) {
            FlansMod.LOGGER.error("Failed to SetMissTime due to " + e);
        }
    }

    public static void SpawnLocalMuzzleParticles(Vec3 origin, GunshotContext gunshotContext, int count) {
        GunContext gunContext;
        if (Minecraft.m_91087_().f_91074_ != null && (gunContext = gunshotContext.ActionGroup.Gun) instanceof GunContextPlayer) {
            GunContextPlayer playerGunContext = (GunContextPlayer)gunContext;
            for (int i = 0; i < gunshotContext.ActionGroup.Gun.Def.particleCount; ++i) {
                if (playerGunContext.GetShooter() == ShooterContext.INVALID) continue;
                GunContext gunContext2 = gunshotContext.ActionGroup.Gun;
                ItemDisplayContext transformType = ItemDisplayContext.FIRST_PERSON_RIGHT_HAND;
                Transform eyeOrigin = gunContext2.GetShootOrigin(Minecraft.m_91087_().getPartialTick());
                transformType = !Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() || !gunContext2.GetShooter().IsLocalPlayerOwner() ? MinecraftHelpers.getThirdPersonTransformType(gunContext2.GetShooter().IsLocalPlayerOwner(), playerGunContext.GetHand()) : MinecraftHelpers.getFirstPersonTransformType(playerGunContext.GetHand());
                Transform shootOrigin = FirstPersonManager.GetWorldSpaceAPTransform(gunContext2, transformType, ActionGroupContext.CreateGroupPath("shoot_origin"));
                Vec3 look = playerGunContext.GetShooter().Entity().m_20154_();
                if (count > 1) {
                    Minecraft.m_91087_().f_91073_.m_7106_((ParticleOptions)ParticleTypes.f_123759_, shootOrigin.positionVec3().m_7096_() + look.f_82479_ * (double)0.1f, shootOrigin.positionVec3().m_7098_() + look.f_82480_ * (double)0.1f, shootOrigin.positionVec3().m_7094_() + look.f_82481_ * (double)0.1f, look.m_7096_() * 0.3 + (double)FlansModClient.random(count), look.m_7098_() * 0.3 + (double)FlansModClient.random(count), look.m_7094_() * 0.3 + (double)FlansModClient.random(count));
                } else {
                    Minecraft.m_91087_().f_91073_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, shootOrigin.positionVec3().m_7096_() + look.f_82479_ * (double)0.1f, shootOrigin.positionVec3().m_7098_() + look.f_82480_ * (double)0.1f, shootOrigin.positionVec3().m_7094_() + look.f_82481_ * (double)0.1f, look.m_7096_() * 0.3 + (double)FlansModClient.random(count), look.m_7098_() * 0.3 + (double)FlansModClient.random(count), look.m_7094_() * 0.3 + (double)FlansModClient.random(count));
                }
                if (i != 1) continue;
                Minecraft.m_91087_().f_91073_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, shootOrigin.positionVec3().m_7096_(), shootOrigin.positionVec3().m_7098_(), shootOrigin.positionVec3().m_7094_(), look.f_82479_, look.f_82480_, look.f_82481_);
            }
        }
    }

    public static void SpawnMuzzleParticles(Vec3 origin, GunshotContext gunshotContext, int count) {
        for (int i = 0; i < count; ++i) {
            if (gunshotContext.ActionGroup.Gun.GetShooter() == ShooterContext.INVALID) continue;
            GunContext gunContext = gunshotContext.ActionGroup.Gun;
            ItemDisplayContext transformType = ItemDisplayContext.FIRST_PERSON_RIGHT_HAND;
            Transform eyeOrigin = gunContext.GetShootOrigin(Minecraft.m_91087_().getPartialTick());
            if (gunContext instanceof GunContextPlayer) {
                GunContextPlayer playerGunContext = (GunContextPlayer)gunContext;
                transformType = !Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() || !gunContext.GetShooter().IsLocalPlayerOwner() ? MinecraftHelpers.getThirdPersonTransformType(gunContext.GetShooter().IsLocalPlayerOwner(), playerGunContext.GetHand()) : MinecraftHelpers.getFirstPersonTransformType(playerGunContext.GetHand());
            }
            Transform laserOrigin = FirstPersonManager.GetWorldSpaceAPTransform(gunContext, transformType, ActionGroupContext.CreateGroupPath("shoot_origin"));
            origin = laserOrigin.positionVec3();
            Vec3 look = gunshotContext.ActionGroup.Gun.GetShooter().GetShootOrigin(0.0f).forward();
            if (count > 1) {
                Minecraft.m_91087_().f_91073_.m_7106_((ParticleOptions)ParticleTypes.f_123759_, origin.m_7096_() + look.f_82479_ * (double)0.1f, origin.m_7098_() + look.f_82480_ * (double)0.1f, origin.m_7094_() + look.f_82481_ * (double)0.1f, look.m_7096_() * 0.3 + (double)FlansModClient.random(count), look.m_7098_() * 0.3 + (double)FlansModClient.random(count), look.m_7094_() * 0.3 + (double)FlansModClient.random(count));
            } else {
                Minecraft.m_91087_().f_91073_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, origin.m_7096_() + look.f_82479_ * (double)0.1f, origin.m_7098_() + look.f_82480_ * (double)0.1f, origin.m_7094_() + look.f_82481_ * (double)0.1f, look.m_7096_() * 0.3 + (double)FlansModClient.random(count), look.m_7098_() * 0.3 + (double)FlansModClient.random(count), look.m_7094_() * 0.3 + (double)FlansModClient.random(count));
            }
            if (i != 1) continue;
            Minecraft.m_91087_().f_91073_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, origin.m_7096_(), origin.m_7098_(), origin.m_7094_(), look.f_82479_, look.f_82480_, look.f_82481_);
        }
    }

    public static void SpawnLocalParticles(SpawnParticleAction action) {
        GunContext gunContext;
        if (Minecraft.m_91087_().f_91074_ != null && (gunContext = action.Group.Context.Gun) instanceof GunContextPlayer) {
            GunContextPlayer playerGunContext = (GunContextPlayer)gunContext;
            GunContext gunContext2 = action.Group.Context.Gun;
            ItemDisplayContext transformType = !Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() || !gunContext2.GetShooter().IsLocalPlayerOwner() ? MinecraftHelpers.getThirdPersonTransformType(gunContext2.GetShooter().IsLocalPlayerOwner(), playerGunContext.GetHand()) : MinecraftHelpers.getFirstPersonTransformType(playerGunContext.GetHand());
            Transform shootOrigin = FirstPersonManager.GetWorldSpaceAPTransform(gunContext2, transformType, ActionGroupContext.CreateGroupPath(action.AttachPoint()));
            ParticleOptions particle = (ParticleOptions)ForgeRegistries.PARTICLE_TYPES.getValue(action.ParticleType());
            for (int i = 0; i < action.ParticleCount(); ++i) {
                if (action.Group.Context.Gun.GetShooter() == ShooterContext.INVALID) continue;
                RandomSource rand = action.Group.Context.Gun.GetShooter().Level().f_46441_;
                TransformStack transformStack = TransformStack.empty();
                transformStack.add(shootOrigin);
                FlansModClient.RandomizeVectorDirection(transformStack, rand, action.ParticleSpread(), action.SpreadPattern());
                Transform randomizedDirection = transformStack.top();
                Vec3 position = randomizedDirection.positionVec3();
                Vec3 look = randomizedDirection.forward();
                float speed = action.ParticleSpeed() - action.ParticleSpeedDispersion() + rand.m_188501_() * (action.ParticleSpeedDispersion() * 2.0f);
                if (particle == null) continue;
                assert (Minecraft.m_91087_().f_91073_ != null);
                Minecraft.m_91087_().f_91073_.m_7106_(particle, position.m_7096_(), position.m_7098_(), position.m_7094_(), look.m_7096_() * (double)speed, look.m_7098_() * (double)speed, look.m_7094_() * (double)speed);
            }
        }
    }

    public static void SpawnParticles(SpawnParticleAction action) {
        int count = action.ParticleCount();
        for (int i = 0; i < count; ++i) {
            if (action.Group.Context.Gun.GetShooter() == ShooterContext.INVALID) continue;
            GunContext gunContext = action.Group.Context.Gun;
            ItemDisplayContext transformType = ItemDisplayContext.FIRST_PERSON_RIGHT_HAND;
            if (gunContext instanceof GunContextPlayer) {
                GunContextPlayer playerGunContext = (GunContextPlayer)gunContext;
                transformType = !Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() || !gunContext.GetShooter().IsLocalPlayerOwner() ? MinecraftHelpers.getThirdPersonTransformType(gunContext.GetShooter().IsLocalPlayerOwner(), playerGunContext.GetHand()) : MinecraftHelpers.getFirstPersonTransformType(playerGunContext.GetHand());
            }
            Transform shootOrigin = FirstPersonManager.GetWorldSpaceAPTransform(gunContext, transformType, ActionGroupContext.CreateGroupPath(action.AttachPoint()));
            Vec3 direction = shootOrigin.forward();
            float spread = action.ParticleSpread();
            ParticleOptions particle = (ParticleOptions)ForgeRegistries.PARTICLE_TYPES.getValue(action.ParticleType());
            if (particle == null) continue;
            Minecraft.m_91087_().f_91073_.m_7106_(particle, shootOrigin.positionVec3().m_7096_() + direction.f_82479_ * (double)spread == 0.0 ? 0.0 : (double)0.1f, shootOrigin.positionVec3().m_7098_() + direction.f_82480_ * (double)spread == 0.0 ? 0.0 : (double)0.1f, shootOrigin.positionVec3().m_7094_() + direction.f_82481_ * (double)spread == 0.0 ? 0.0 : (double)0.1f, direction.m_7096_() * 0.3 + (double)FlansModClient.random(spread), direction.m_7098_() * 0.3 + (double)FlansModClient.random(spread), direction.m_7094_() * 0.3 + (double)FlansModClient.random(spread));
        }
    }

    private static float random(float strength) {
        return ((float)Math.random() * 0.6f - 0.3f) * strength / 20.0f;
    }

    private static void RandomizeVectorDirection(@Nonnull TransformStack transformStack, @Nonnull RandomSource rand, float spread, @Nonnull ESpreadPattern spreadPattern) {
        float yComponent;
        float xComponent;
        switch (spreadPattern) {
            case Circle: 
            case FilledCircle: {
                float theta = rand.m_188501_() * ((float)Math.PI * 2);
                float radius = (spreadPattern == ESpreadPattern.Circle ? 1.0f : rand.m_188501_()) * spread;
                xComponent = radius * Maths.sinF(theta);
                yComponent = radius * Maths.cosF(theta);
                break;
            }
            case Horizontal: {
                xComponent = spread * (rand.m_188501_() * 2.0f - 1.0f);
                yComponent = 0.0f;
                break;
            }
            case Vertical: {
                xComponent = 0.0f;
                yComponent = spread * (rand.m_188501_() * 2.0f - 1.0f);
                break;
            }
            case Triangle: {
                xComponent = rand.m_188501_() * 2.0f - 1.0f;
                yComponent = rand.m_188501_() * 2.0f - 1.0f;
                if (xComponent > 0.0f) {
                    if (!(yComponent > 1.0f - xComponent * 2.0f)) break;
                    yComponent = -yComponent;
                    xComponent = 1.0f - xComponent;
                    break;
                }
                if (!(yComponent > xComponent * 2.0f + 1.0f)) break;
                yComponent = -yComponent;
                xComponent = -1.0f - xComponent;
                break;
            }
            default: {
                xComponent = 0.0f;
                yComponent = 0.0f;
            }
        }
        float yaw = xComponent;
        float pitch = yComponent;
        transformStack.add(Transform.fromEuler(pitch, yaw, 0.0f));
    }

    static {
        ResourceLocation smallMuzzleFlash = new ResourceLocation("flansmod", "effects/muzzle_flash_small");
        ResourceLocation mediumMuzzleFlash = new ResourceLocation("flansmod", "effects/muzzle_flash_medium");
        ResourceLocation largeMuzzleFlash = new ResourceLocation("flansmod", "effects/muzzle_flash_large");
        FlansModelRegistry.PreRegisterRenderer(smallMuzzleFlash, (ITurboRenderer)new EffectRenderer(smallMuzzleFlash));
        FlansModelRegistry.PreRegisterRenderer(mediumMuzzleFlash, (ITurboRenderer)new EffectRenderer(mediumMuzzleFlash));
        FlansModelRegistry.PreRegisterRenderer(largeMuzzleFlash, (ITurboRenderer)new EffectRenderer(largeMuzzleFlash));
        ResourceLocation rifleCasing = new ResourceLocation("flansmod", "effects/casing_rifle");
        FlansModelRegistry.PreRegisterRenderer(rifleCasing, (ITurboRenderer)new CasingRenderer(rifleCasing));
        MINECRAFT_MISS_TIME = ObfuscationReflectionHelper.findField(Minecraft.class, (String)"f_91078_");
        ITEM_IN_HAND_RENDERER_MAIN_HAND_HEIGHT = ObfuscationReflectionHelper.findField(ItemInHandRenderer.class, (String)"f_109302_");
        ITEM_IN_HAND_RENDERER_O_MAIN_HAND_HEIGHT = ObfuscationReflectionHelper.findField(ItemInHandRenderer.class, (String)"f_109303_");
        ITEM_IN_HAND_RENDERER_OFF_HAND_HEIGHT = ObfuscationReflectionHelper.findField(ItemInHandRenderer.class, (String)"f_109304_");
        ITEM_IN_HAND_RENDERER_O_OFF_HAND_HEIGHT = ObfuscationReflectionHelper.findField(ItemInHandRenderer.class, (String)"f_109305_");
        GET_FOV = ObfuscationReflectionHelper.findMethod(GameRenderer.class, (String)"m_109141_", (Class[])new Class[]{Camera.class, Float.TYPE, Boolean.TYPE});
    }
}

