/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.armor.bone;

import mod.azure.azurelib.rewrite.model.AzBakedModel;
import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.render.armor.bone.AzArmorBoneProvider;
import mod.azure.azurelib.util.RenderUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.EquipmentSlot;
import org.jetbrains.annotations.Nullable;

public class AzArmorBoneContext {
    private AzBakedModel lastModel;
    protected AzBone head = null;
    protected AzBone body = null;
    protected AzBone rightArm = null;
    protected AzBone leftArm = null;
    protected AzBone rightLeg = null;
    protected AzBone leftLeg = null;
    protected AzBone rightBoot = null;
    protected AzBone leftBoot = null;

    public void setAllVisible(boolean pVisible) {
        this.setBoneVisible(this.head, pVisible);
        this.setBoneVisible(this.body, pVisible);
        this.setBoneVisible(this.rightArm, pVisible);
        this.setBoneVisible(this.leftArm, pVisible);
        this.setBoneVisible(this.rightLeg, pVisible);
        this.setBoneVisible(this.leftLeg, pVisible);
        this.setBoneVisible(this.rightBoot, pVisible);
        this.setBoneVisible(this.leftBoot, pVisible);
    }

    public void grabRelevantBones(AzBakedModel model, AzArmorBoneProvider boneProvider) {
        if (this.lastModel == model) {
            return;
        }
        this.lastModel = model;
        this.head = boneProvider.getHeadBone(model);
        this.body = boneProvider.getBodyBone(model);
        this.rightArm = boneProvider.getRightArmBone(model);
        this.leftArm = boneProvider.getLeftArmBone(model);
        this.rightLeg = boneProvider.getRightLegBone(model);
        this.leftLeg = boneProvider.getLeftLegBone(model);
        this.rightBoot = boneProvider.getRightBootBone(model);
        this.leftBoot = boneProvider.getLeftBootBone(model);
    }

    public void applyBaseTransformations(HumanoidModel<?> baseModel) {
        if (this.head != null) {
            ModelPart headPart = baseModel.f_102808_;
            RenderUtils.matchModelPartRot(headPart, this.head);
            this.head.updatePosition(headPart.f_104200_, -headPart.f_104201_, headPart.f_104202_);
        }
        if (this.body != null) {
            ModelPart bodyPart = baseModel.f_102810_;
            RenderUtils.matchModelPartRot(bodyPart, this.body);
            this.body.updatePosition(bodyPart.f_104200_, -bodyPart.f_104201_, bodyPart.f_104202_);
        }
        if (this.rightArm != null) {
            ModelPart rightArmPart = baseModel.f_102811_;
            RenderUtils.matchModelPartRot(rightArmPart, this.rightArm);
            this.rightArm.updatePosition(rightArmPart.f_104200_ + 5.0f, 2.0f - rightArmPart.f_104201_, rightArmPart.f_104202_);
        }
        if (this.leftArm != null) {
            ModelPart leftArmPart = baseModel.f_102812_;
            RenderUtils.matchModelPartRot(leftArmPart, this.leftArm);
            this.leftArm.updatePosition(leftArmPart.f_104200_ - 5.0f, 2.0f - leftArmPart.f_104201_, leftArmPart.f_104202_);
        }
        if (this.rightLeg != null) {
            ModelPart rightLegPart = baseModel.f_102813_;
            RenderUtils.matchModelPartRot(rightLegPart, this.rightLeg);
            this.rightLeg.updatePosition(rightLegPart.f_104200_ + 2.0f, 12.0f - rightLegPart.f_104201_, rightLegPart.f_104202_);
            if (this.rightBoot != null) {
                RenderUtils.matchModelPartRot(rightLegPart, this.rightBoot);
                this.rightBoot.updatePosition(rightLegPart.f_104200_ + 2.0f, 12.0f - rightLegPart.f_104201_, rightLegPart.f_104202_);
            }
        }
        if (this.leftLeg != null) {
            ModelPart leftLegPart = baseModel.f_102814_;
            RenderUtils.matchModelPartRot(leftLegPart, this.leftLeg);
            this.leftLeg.updatePosition(leftLegPart.f_104200_ - 2.0f, 12.0f - leftLegPart.f_104201_, leftLegPart.f_104202_);
            if (this.leftBoot != null) {
                RenderUtils.matchModelPartRot(leftLegPart, this.leftBoot);
                this.leftBoot.updatePosition(leftLegPart.f_104200_ - 2.0f, 12.0f - leftLegPart.f_104201_, leftLegPart.f_104202_);
            }
        }
    }

    public void applyBoneVisibilityByPart(EquipmentSlot currentSlot, ModelPart currentPart, HumanoidModel<?> model) {
        this.setAllVisible(false);
        currentPart.f_104207_ = true;
        AzBone bone = null;
        if (currentPart == model.f_102809_ || currentPart == model.f_102808_) {
            bone = this.head;
        } else if (currentPart == model.f_102810_) {
            bone = this.body;
        } else if (currentPart == model.f_102812_) {
            bone = this.leftArm;
        } else if (currentPart == model.f_102811_) {
            bone = this.rightArm;
        } else if (currentPart == model.f_102814_) {
            bone = currentSlot == EquipmentSlot.FEET ? this.leftBoot : this.leftLeg;
        } else if (currentPart == model.f_102813_) {
            AzBone azBone = bone = currentSlot == EquipmentSlot.FEET ? this.rightBoot : this.rightLeg;
        }
        if (bone != null) {
            bone.setHidden(false);
        }
    }

    public void applyBoneVisibilityBySlot(EquipmentSlot currentSlot) {
        this.setAllVisible(false);
        switch (currentSlot) {
            case HEAD: {
                this.setBoneVisible(this.head, true);
                break;
            }
            case CHEST: {
                this.setBoneVisible(this.body, true);
                this.setBoneVisible(this.rightArm, true);
                this.setBoneVisible(this.leftArm, true);
                break;
            }
            case LEGS: {
                this.setBoneVisible(this.rightLeg, true);
                this.setBoneVisible(this.leftLeg, true);
                break;
            }
            case FEET: {
                this.setBoneVisible(this.rightBoot, true);
                this.setBoneVisible(this.leftBoot, true);
                break;
            }
        }
    }

    protected void setBoneVisible(@Nullable AzBone bone, boolean visible) {
        if (bone == null) {
            return;
        }
        bone.setHidden(!visible);
    }
}

