/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.network.packet;

import mod.azure.azurelib.network.AbstractPacket;
import mod.azure.azurelib.platform.services.AzureLibNetwork;
import mod.azure.azurelib.rewrite.animation.AzAnimator;
import mod.azure.azurelib.rewrite.animation.AzAnimatorAccessor;
import mod.azure.azurelib.rewrite.animation.dispatch.AzDispatchSide;
import mod.azure.azurelib.rewrite.animation.dispatch.command.AzCommand;
import mod.azure.azurelib.util.ClientUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class AzEntityDispatchCommandPacket
extends AbstractPacket {
    private final int entityId;
    private final AzCommand dispatchCommand;

    public AzEntityDispatchCommandPacket(int entityId, AzCommand dispatchCommand) {
        this.entityId = entityId;
        this.dispatchCommand = dispatchCommand;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        AzCommand.ENCODER.accept(buf, this.dispatchCommand);
    }

    @Override
    public ResourceLocation getPacketID() {
        return AzureLibNetwork.AZ_ENTITY_DISPATCH_COMMAND_SYNC_PACKET_ID;
    }

    public static AzEntityDispatchCommandPacket receive(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        AzCommand dispatchCommand = AzCommand.DECODER.apply(buf);
        return new AzEntityDispatchCommandPacket(entityId, dispatchCommand);
    }

    @Override
    public void handle() {
        Entity entity = ClientUtils.getLevel().m_6815_(this.entityId);
        if (entity == null) {
            return;
        }
        AzAnimator<Entity> animator = AzAnimatorAccessor.getOrNull(entity);
        if (animator != null) {
            this.dispatchCommand.actions().forEach(action -> action.handle(AzDispatchSide.SERVER, animator));
        }
    }
}

