/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.savage_and_ravage.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ExecutionerModel
extends HumanoidModel<Vindicator> {
    public ModelPart closedArms;
    public ModelPart closedRightArm;
    public ModelPart closedLeftArm;
    public ModelPart nose;

    public ExecutionerModel(ModelPart root) {
        super(root);
        this.f_102809_.f_104207_ = false;
        this.closedArms = root.m_171324_("closed_arms");
        this.closedRightArm = this.closedArms.m_171324_("closed_right_arm");
        this.closedLeftArm = this.closedArms.m_171324_("closed_left_arm");
        this.nose = this.f_102808_.m_171324_("nose");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = HumanoidModel.m_170681_((CubeDeformation)CubeDeformation.f_171458_, (float)0.0f);
        PartDefinition root = meshdefinition.m_171576_();
        PartDefinition closedArms = root.m_171599_("closed_arms", CubeListBuilder.m_171558_().m_171514_(32, 40).m_171506_(-4.0f, 2.0f, -2.0f, 8.0f, 4.0f, 4.0f, false), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)-1.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition closedRightArm = closedArms.m_171599_("closed_right_arm", CubeListBuilder.m_171558_().m_171514_(48, 12).m_171506_(4.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, true).m_171514_(40, 0).m_171506_(4.0f, -3.0f, -2.5f, 6.0f, 7.0f, 5.0f, false), PartPose.f_171404_);
        PartDefinition closedLeftArm = closedArms.m_171599_("closed_left_arm", CubeListBuilder.m_171558_().m_171514_(48, 12).m_171506_(-8.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, false).m_171514_(40, 0).m_171506_(-10.0f, -3.0f, -2.5f, 6.0f, 7.0f, 5.0f, false), PartPose.f_171404_);
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171506_(-4.0f, 0.0f, -3.0f, 8.0f, 12.0f, 6.0f, false).m_171514_(0, 0).m_171488_(-4.5f, 0.0f, -3.0f, 9.0f, 18.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.f_171404_);
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 46).m_171506_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, false).m_171514_(32, 28).m_171488_(-4.0f, -4.0f, -4.0f, 8.0f, 4.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.f_171404_);
        PartDefinition nose = head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(24, 46).m_171506_(-1.0f, 0.0f, -2.0f, 2.0f, 4.0f, 2.0f, false), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftArm = root.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(48, 48).m_171506_(-0.5f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, false).m_171514_(40, 0).m_171506_(-1.5f, -2.5f, -2.5f, 6.0f, 7.0f, 5.0f, false), PartPose.m_171423_((float)-4.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0436f));
        PartDefinition rightArm = root.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(48, 48).m_171506_(-3.5f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, true).m_171514_(40, 0).m_171506_(-4.5f, -2.5f, -2.5f, 6.0f, 7.0f, 5.0f, false), PartPose.m_171423_((float)4.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0436f));
        PartDefinition leftLeg = root.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(32, 48).m_171506_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, false).m_171514_(30, 12).m_171506_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, false), PartPose.m_171423_((float)-1.9f, (float)12.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightLeg = root.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(32, 48).m_171506_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, true).m_171514_(30, 12).m_171506_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, false), PartPose.m_171423_((float)1.9f, (float)12.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    protected Iterable<ModelPart> m_5608_() {
        return Iterables.concat((Iterable)super.m_5608_(), (Iterable)ImmutableList.of((Object)this.closedArms));
    }

    public void m_7695_(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        super.m_7695_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    public void setupAnim(Vindicator entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean isCrossed;
        super.m_6973_((LivingEntity)entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        AbstractIllager.IllagerArmPose illagerArmPose = entityIn.m_6768_();
        if (illagerArmPose == AbstractIllager.IllagerArmPose.ATTACKING && !entityIn.m_21205_().m_41619_()) {
            AnimationUtils.m_102091_((ModelPart)this.f_102811_, (ModelPart)this.f_102812_, (Mob)entityIn, (float)this.f_102608_, (float)ageInTicks);
        }
        this.closedArms.f_104207_ = isCrossed = illagerArmPose == AbstractIllager.IllagerArmPose.CROSSED;
        this.f_102812_.f_104207_ = !isCrossed;
        this.f_102811_.f_104207_ = !isCrossed;
        this.f_102809_.f_104207_ = false;
    }

    public void setRotationAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.f_104203_ = x;
        modelRenderer.f_104204_ = y;
        modelRenderer.f_104205_ = z;
    }
}

