/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.fluids.pipes;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.decoration.bracket.BracketedBlockEntityBehaviour;
import com.simibubi.create.content.equipment.wrench.IWrenchableWithBracket;
import com.simibubi.create.content.fluids.FluidPropagator;
import com.simibubi.create.content.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.fluids.pipes.EncasedPipeBlock;
import com.simibubi.create.content.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.content.fluids.pipes.IAxisPipe;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.Map;
import java.util.Optional;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.TickPriority;

public class AxisPipeBlock
extends RotatedPillarBlock
implements IWrenchableWithBracket,
IAxisPipe {
    public AxisPipeBlock(BlockBehaviour.Properties p_i48339_1_) {
        super(p_i48339_1_);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        boolean blockTypeChanged;
        boolean bl = blockTypeChanged = state.m_60734_() != newState.m_60734_();
        if (blockTypeChanged && !world.f_46443_) {
            FluidPropagator.propagateChangedPipe((LevelAccessor)world, pos, state);
        }
        if (state != newState && !isMoving) {
            this.removeBracket((BlockGetter)world, pos, true).ifPresent(stack -> Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)stack));
        }
        if (state.m_155947_() && (blockTypeChanged || !newState.m_155947_())) {
            world.m_46747_(pos);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!AllBlocks.COPPER_CASING.isIn(player.m_21120_(hand))) {
            return InteractionResult.PASS;
        }
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockState newState = AllBlocks.ENCASED_FLUID_PIPE.getDefaultState();
        for (Direction d : Iterate.directionsInAxis((Direction.Axis)this.getAxis(state))) {
            newState = (BlockState)newState.m_61124_((Property)EncasedPipeBlock.FACING_TO_PROPERTY_MAP.get(d), (Comparable)Boolean.valueOf(true));
        }
        FluidTransportBehaviour.cacheFlows((LevelAccessor)world, pos);
        world.m_46597_(pos, newState);
        FluidTransportBehaviour.loadFlows((LevelAccessor)world, pos);
        return InteractionResult.SUCCESS;
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        AdvancementBehaviour.setPlacedBy(pLevel, pPos, pPlacer);
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (world.f_46443_) {
            return;
        }
        if (state != oldState) {
            world.m_186464_(pos, (Block)this, 1, TickPriority.HIGH);
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return AllBlocks.FLUID_PIPE.asStack();
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block otherBlock, BlockPos neighborPos, boolean isMoving) {
        DebugPackets.m_133708_((Level)world, (BlockPos)pos);
        Direction d = FluidPropagator.validateNeighbourChange(state, world, pos, otherBlock, neighborPos, isMoving);
        if (d == null) {
            return;
        }
        if (!AxisPipeBlock.isOpenAt(state, d)) {
            return;
        }
        world.m_186464_(pos, (Block)this, 1, TickPriority.HIGH);
    }

    public static boolean isOpenAt(BlockState state, Direction d) {
        return d.m_122434_() == state.m_61143_((Property)f_55923_);
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource r) {
        FluidPropagator.propagateChangedPipe((LevelAccessor)world, pos, state);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return AllShapes.EIGHT_VOXEL_POLE.get((Direction.Axis)state.m_61143_((Property)f_55923_));
    }

    public BlockState toRegularPipe(LevelAccessor world, BlockPos pos, BlockState state) {
        Direction side = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)((Direction.Axis)state.m_61143_((Property)f_55923_)));
        Map facingToPropertyMap = FluidPipeBlock.f_55154_;
        return ((FluidPipeBlock)AllBlocks.FLUID_PIPE.get()).updateBlockState((BlockState)((BlockState)AllBlocks.FLUID_PIPE.getDefaultState().m_61124_((Property)facingToPropertyMap.get(side), (Comparable)Boolean.valueOf(true))).m_61124_((Property)facingToPropertyMap.get(side.m_122424_()), (Comparable)Boolean.valueOf(true)), side, null, (BlockAndTintGetter)world, pos);
    }

    @Override
    public Direction.Axis getAxis(BlockState state) {
        return (Direction.Axis)state.m_61143_((Property)f_55923_);
    }

    @Override
    public Optional<ItemStack> removeBracket(BlockGetter world, BlockPos pos, boolean inOnReplacedContext) {
        BracketedBlockEntityBehaviour behaviour = BlockEntityBehaviour.get(world, pos, BracketedBlockEntityBehaviour.TYPE);
        if (behaviour == null) {
            return Optional.empty();
        }
        BlockState bracket = behaviour.removeBracket(inOnReplacedContext);
        if (bracket == null) {
            return Optional.empty();
        }
        return Optional.of(new ItemStack((ItemLike)bracket.m_60734_()));
    }
}

