/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.bearing;

import com.mojang.math.Axis;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.OrientedContraptionEntity;
import com.simibubi.create.content.contraptions.bearing.BearingVisual;
import com.simibubi.create.content.contraptions.bearing.StabilizedBearingVisual;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ActorVisual;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import javax.annotation.Nullable;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class StabilizedBearingMovementBehaviour
implements MovementBehaviour {
    @Override
    public ItemStack canBeDisabledVia(MovementContext context) {
        return null;
    }

    @Override
    public boolean disableBlockEntityRendering() {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffer) {
        if (VisualizationManager.supportsVisualization((LevelAccessor)context.world)) {
            return;
        }
        Direction facing = (Direction)context.state.m_61143_((Property)BlockStateProperties.f_61372_);
        PartialModel top = AllPartialModels.BEARING_TOP;
        SuperByteBuffer superBuffer = CachedBuffers.partial((PartialModel)top, (BlockState)context.state);
        float renderPartialTicks = AnimationTickHolder.getPartialTicks();
        Quaternionf orientation = BearingVisual.getBlockStateOrientation(facing);
        float angle = StabilizedBearingMovementBehaviour.getCounterRotationAngle(context, facing, renderPartialTicks) * (float)facing.m_122421_().m_122540_();
        Quaternionf rotation = Axis.m_253057_((Vector3f)facing.m_253071_()).m_252977_(angle);
        rotation.mul((Quaternionfc)orientation);
        orientation = rotation;
        superBuffer.transform(matrices.getModel());
        superBuffer.rotateCentered((Quaternionfc)orientation);
        superBuffer.light(LevelRenderer.m_109541_((BlockAndTintGetter)renderWorld, (BlockPos)context.localPos)).useLevelLight((BlockAndTintGetter)context.world, matrices.getWorld()).renderInto(matrices.getViewProjection(), buffer.m_6299_(RenderType.m_110451_()));
    }

    @Override
    @Nullable
    public ActorVisual createVisual(VisualizationContext visualizationContext, VirtualRenderWorld simulationWorld, MovementContext movementContext) {
        return new StabilizedBearingVisual(visualizationContext, simulationWorld, movementContext);
    }

    static float getCounterRotationAngle(MovementContext context, Direction facing, float renderPartialTicks) {
        if (!context.contraption.canBeStabilized(facing, context.localPos)) {
            return 0.0f;
        }
        float offset = 0.0f;
        Direction.Axis axis = facing.m_122434_();
        AbstractContraptionEntity entity = context.contraption.entity;
        if (entity instanceof ControlledContraptionEntity) {
            ControlledContraptionEntity controlledCE = (ControlledContraptionEntity)entity;
            if (context.contraption.canBeStabilized(facing, context.localPos)) {
                offset = -controlledCE.getAngle(renderPartialTicks);
            }
        } else if (entity instanceof OrientedContraptionEntity) {
            OrientedContraptionEntity orientedCE = (OrientedContraptionEntity)entity;
            if (axis.m_122478_()) {
                offset = -orientedCE.m_5675_(renderPartialTicks);
            } else if (orientedCE.isInitialOrientationPresent() && orientedCE.getInitialOrientation().m_122434_() == axis) {
                offset = -orientedCE.m_5686_(renderPartialTicks);
            }
        }
        return offset;
    }
}

