/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.overweightfarming.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.orcinus.overweightfarming.init.OFBlocks;
import net.orcinus.overweightfarming.init.OFItems;
import net.orcinus.overweightfarming.init.OFParticleTypes;

public class PeeledMelonBlock
extends Block {
    private final SeedState seedState;

    public PeeledMelonBlock(SeedState seedState, BlockBehaviour.Properties properties) {
        super(properties);
        this.seedState = seedState;
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        for (int i = 0; i < random.m_188503_(1) + 1; ++i) {
            this.trySpawnDripParticles(world, pos, state);
        }
    }

    private void trySpawnDripParticles(Level world, BlockPos pos, BlockState state) {
        VoxelShape voxelshape;
        double d0;
        if (state.m_60819_().m_76178_() && !(world.f_46441_.m_188501_() < 0.3f) && (d0 = (voxelshape = state.m_60812_((BlockGetter)world, pos)).m_83297_(Direction.Axis.Y)) >= 1.0 && !state.m_204336_(BlockTags.f_13049_)) {
            double d1 = voxelshape.m_83288_(Direction.Axis.Y);
            if (d1 > 0.0) {
                this.spawnParticle(world, pos, voxelshape, (double)pos.m_123342_() + d1 - 0.05);
            } else {
                BlockPos blockpos = pos.m_7495_();
                BlockState blockstate = world.m_8055_(blockpos);
                VoxelShape voxelshape1 = blockstate.m_60812_((BlockGetter)world, blockpos);
                double d2 = voxelshape1.m_83297_(Direction.Axis.Y);
                if ((d2 < 1.0 || !blockstate.m_60838_((BlockGetter)world, blockpos)) && blockstate.m_60819_().m_76178_()) {
                    this.spawnParticle(world, pos, voxelshape, (double)pos.m_123342_() - 0.05);
                }
            }
        }
    }

    private void spawnParticle(Level world, BlockPos pos, VoxelShape p_49615_, double y) {
        this.spawnFluidParticle(world, (double)pos.m_123341_() + p_49615_.m_83288_(Direction.Axis.X), (double)pos.m_123341_() + p_49615_.m_83297_(Direction.Axis.X), (double)pos.m_123343_() + p_49615_.m_83288_(Direction.Axis.Z), (double)pos.m_123343_() + p_49615_.m_83297_(Direction.Axis.Z), y);
    }

    private void spawnFluidParticle(Level world, double minX, double maxX, double minZ, double maxZ, double y) {
        world.m_7106_((ParticleOptions)OFParticleTypes.DRIPPING_MELON.get(), Mth.m_14139_((double)world.f_46441_.m_188500_(), (double)minX, (double)maxX), y, Mth.m_14139_((double)world.f_46441_.m_188500_(), (double)minZ, (double)maxZ), 0.0, 0.0, 0.0);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult p_60508_) {
        ItemStack stack = player.m_21120_(hand);
        if (this.seedState != SeedState.SEEDLESS) {
            Block finalBlock = this.seedState == SeedState.SEEDED ? (Block)OFBlocks.HALF_SEEDED_PEELED_MELON.get() : (Block)OFBlocks.SEEDLESS_PEELED_MELON.get();
            PeeledMelonBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.f_42578_));
            world.m_46597_(pos, finalBlock.m_49966_());
            world.m_5594_(null, pos, SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, 1.4f);
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        if (stack.m_41720_() == Items.f_42590_) {
            stack.m_41774_(1);
            if (stack.m_41619_()) {
                player.m_21008_(hand, new ItemStack((ItemLike)OFItems.MELON_JUICE.get()));
            } else if (!player.m_150109_().m_36054_(new ItemStack((ItemLike)OFItems.MELON_JUICE.get()))) {
                player.m_36176_(new ItemStack((ItemLike)OFItems.MELON_JUICE.get()), false);
            }
            world.m_142346_((Entity)player, GameEvent.f_157816_, pos);
            world.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11770_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            if (!world.m_5776_()) {
                if (world.m_213780_().m_188503_(7) == 0) {
                    world.m_46961_(pos, false);
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
            }
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        return super.m_6227_(state, world, pos, player, hand, p_60508_);
    }

    public static enum SeedState {
        SEEDED,
        HALF_SEEDED,
        SEEDLESS;

    }
}

