/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.caverns_and_chasms.common.block;

import com.teamabnormals.caverns_and_chasms.core.other.CCDamageTypes;
import com.teamabnormals.caverns_and_chasms.core.registry.CCParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LavaLampBlock
extends DirectionalBlock
implements SimpleWaterloggedBlock {
    private static final VoxelShape X_LAVA_SHAPE = LavaLampBlock.m_49796_((double)2.0, (double)4.0, (double)4.0, (double)14.0, (double)12.0, (double)12.0);
    private static final VoxelShape Y_LAVA_SHAPE = LavaLampBlock.m_49796_((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0);
    private static final VoxelShape Z_LAVA_SHAPE = LavaLampBlock.m_49796_((double)4.0, (double)4.0, (double)2.0, (double)12.0, (double)12.0, (double)14.0);
    private static final VoxelShape X_AXIS_SHAPE = Shapes.m_83124_((VoxelShape)LavaLampBlock.m_49796_((double)0.0, (double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0), (VoxelShape[])new VoxelShape[]{LavaLampBlock.m_49796_((double)14.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0), X_LAVA_SHAPE});
    private static final VoxelShape Y_AXIS_SHAPE = Shapes.m_83124_((VoxelShape)LavaLampBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0), (VoxelShape[])new VoxelShape[]{LavaLampBlock.m_49796_((double)2.0, (double)14.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), Y_LAVA_SHAPE});
    private static final VoxelShape Z_AXIS_SHAPE = Shapes.m_83124_((VoxelShape)LavaLampBlock.m_49796_((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)2.0), (VoxelShape[])new VoxelShape[]{LavaLampBlock.m_49796_((double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0, (double)16.0), Z_LAVA_SHAPE});
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public LavaLampBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_52588_, (Comparable)Direction.UP)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        switch (((Direction)state.m_61143_((Property)f_52588_)).m_122434_()) {
            default: {
                return X_AXIS_SHAPE;
            }
            case Y: {
                return Y_AXIS_SHAPE;
            }
            case Z: 
        }
        return Z_AXIS_SHAPE;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_43719_();
        BlockState blockstate = context.m_43725_().m_8055_(context.m_8083_().m_121945_(direction.m_122424_()));
        Direction facing = blockstate.m_60713_((Block)this) && ((Direction)blockstate.m_61143_((Property)f_52588_)).m_122434_() == direction.m_122434_() ? (Direction)blockstate.m_61143_((Property)f_52588_) : direction;
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)super.m_5573_(context).m_61124_((Property)f_52588_, (Comparable)facing)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_205070_(FluidTags.f_13131_) && fluidstate.m_76186_() == 8));
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (!level.m_5776_() && ((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            RandomSource random = level.f_46441_;
            level.m_5594_(null, pos, SoundEvents.f_12031_, SoundSource.BLOCKS, 0.5f, 2.6f + (random.m_188501_() - random.m_188501_()) * 0.8f);
        }
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (this.isEntityTouchingLava(state, pos, entity) && !entity.m_5825_()) {
            entity.m_20254_(15);
            if (entity.m_6469_(CCDamageTypes.lavaLamp(level), 2.0f)) {
                entity.m_5496_(SoundEvents.f_11909_, 0.4f, 2.0f + level.m_213780_().m_188501_() * 0.4f);
            }
        }
    }

    private boolean isEntityTouchingLava(BlockState state, BlockPos pos, Entity entity) {
        Direction.Axis axis = ((Direction)state.m_61143_((Property)f_52588_)).m_122434_();
        VoxelShape voxelshape = axis == Direction.Axis.X ? X_LAVA_SHAPE : (axis == Direction.Axis.Y ? Y_LAVA_SHAPE : Z_LAVA_SHAPE);
        VoxelShape voxelshape1 = voxelshape.m_83216_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        return entity.m_20191_().m_82381_(voxelshape1.m_83215_().m_82400_(1.0E-7));
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            Direction.Axis axis = ((Direction)state.m_61143_((Property)f_52588_)).m_122434_();
            for (int i = 0; i < 3; ++i) {
                double y;
                double d1;
                boolean side = random.m_188499_();
                double d0 = random.m_188500_() * 0.75 + 0.125;
                double d = !side ? random.m_188500_() * 0.75 + 0.125 : (d1 = random.m_188499_() ? 0.0 : 1.0);
                double d2 = side ? random.m_188500_() * 0.75 + 0.125 : (axis == Direction.Axis.Y && random.m_188499_() ? 0.0 : 1.0);
                double x = axis == Direction.Axis.X ? d0 : d1;
                double d3 = y = axis == Direction.Axis.Y ? d0 : d2;
                double z = axis == Direction.Axis.X ? d1 : (axis == Direction.Axis.Y ? d2 : d0);
                level.m_7106_((ParticleOptions)CCParticleTypes.LAVA_LAMP_SMOKE.get(), (double)pos.m_123341_() + x, (double)pos.m_123342_() + y, (double)pos.m_123343_() + z, 0.0, 0.0, 0.0);
            }
        }
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)f_52588_, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)f_52588_)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)f_52588_)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_52588_, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }
}

