/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.core.registry;

import java.util.function.Supplier;
import net.azurune.runiclib.common.publicized.PublicStairBlock;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.yirmiri.dungeonsdelight.common.block.CandleMonsterCakeBlock;
import net.yirmiri.dungeonsdelight.common.block.DungeonStoveBlock;
import net.yirmiri.dungeonsdelight.common.block.EmbeddedEggsBlock;
import net.yirmiri.dungeonsdelight.common.block.ExperiencePieBlock;
import net.yirmiri.dungeonsdelight.common.block.GlowBerryGelatinBlock;
import net.yirmiri.dungeonsdelight.common.block.GuardianAngelBlock;
import net.yirmiri.dungeonsdelight.common.block.GunkBlock;
import net.yirmiri.dungeonsdelight.common.block.LivingCampfireBlock;
import net.yirmiri.dungeonsdelight.common.block.LivingCandleBlock;
import net.yirmiri.dungeonsdelight.common.block.LivingFireBlock;
import net.yirmiri.dungeonsdelight.common.block.LivingTorchBlock;
import net.yirmiri.dungeonsdelight.common.block.MonsterCakeBlock;
import net.yirmiri.dungeonsdelight.common.block.MonsterPotBlock;
import net.yirmiri.dungeonsdelight.common.block.OssobucoBlock;
import net.yirmiri.dungeonsdelight.common.block.RotbulbCropBlock;
import net.yirmiri.dungeonsdelight.common.block.RotbulbPlantBlock;
import net.yirmiri.dungeonsdelight.common.block.RottenCropBlock;
import net.yirmiri.dungeonsdelight.common.block.RottenPotatoCropBlock;
import net.yirmiri.dungeonsdelight.common.block.RottenTomatoesBlock;
import net.yirmiri.dungeonsdelight.common.block.SilverfishAndChipsBlock;
import net.yirmiri.dungeonsdelight.common.block.SpiderDonutBlock;
import net.yirmiri.dungeonsdelight.common.block.StainedScrapGrateBlock;
import net.yirmiri.dungeonsdelight.common.block.WallLivingTorchBlock;
import net.yirmiri.dungeonsdelight.common.block.WormouthBlock;
import net.yirmiri.dungeonsdelight.common.block.WormrootTendrilsBlock;
import net.yirmiri.dungeonsdelight.common.block.WormrootsStalkBlock;
import net.yirmiri.dungeonsdelight.common.block.WormwoodButtonBlock;
import net.yirmiri.dungeonsdelight.common.util.DDProperties;
import net.yirmiri.dungeonsdelight.core.init.DDBlockSetTypes;
import net.yirmiri.dungeonsdelight.core.registry.DDItems;
import vectorwing.farmersdelight.common.block.CabinetBlock;
import vectorwing.farmersdelight.common.block.PieBlock;

public class DDBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"dungeonsdelight");
    public static final RegistryObject<Block> ROTBULB_CRATE = DDBlocks.registerBlockWOItem("rotbulb_crate", () -> new Block(DDProperties.BlockP.WORMWOOD));
    public static final RegistryObject<Block> POISONOUS_POTATO_CRATE = DDBlocks.registerBlock("poisonous_potato_crate", () -> new Block(DDProperties.BlockP.CRATE));
    public static final RegistryObject<Block> ROTTEN_TOMATO_CRATE = DDBlocks.registerBlock("rotten_tomato_crate", () -> new Block(DDProperties.BlockP.CRATE));
    public static final RegistryObject<Block> SCULK_MAYO_BLOCK = DDBlocks.registerBlock("sculk_mayo_block", () -> new Block(DDProperties.BlockP.SCULK_MAYO));
    public static final RegistryObject<Block> GUNK = DDBlocks.registerBlockWOItem("gunk", () -> new GunkBlock(DDProperties.BlockP.GUNK));
    public static final RegistryObject<Block> ROTTEN_SPAWNER = DDBlocks.registerBlockWOItem("rotten_spawner", () -> new Block(DDProperties.BlockP.ROTTEN_SPAWNER));
    public static final RegistryObject<Block> STAINED_SCRAP_BLOCK = DDBlocks.registerBlockWOItem("stained_scrap_block", () -> new Block(DDProperties.BlockP.SPAWNER));
    public static final RegistryObject<Block> CUT_STAINED_SCRAP = DDBlocks.registerBlockWOItem("cut_stained_scrap", () -> new Block(DDProperties.BlockP.SPAWNER));
    public static final RegistryObject<Block> CUT_STAINED_SCRAP_STAIRS = DDBlocks.registerBlockWOItem("cut_stained_scrap_stairs", () -> new PublicStairBlock(((Block)CUT_STAINED_SCRAP.get()).m_49966_(), DDProperties.BlockP.SPAWNER));
    public static final RegistryObject<Block> CUT_STAINED_SCRAP_SLAB = DDBlocks.registerBlockWOItem("cut_stained_scrap_slab", () -> new SlabBlock(DDProperties.BlockP.SPAWNER));
    public static final RegistryObject<Block> STAINED_SCRAP_BARS = DDBlocks.registerBlockWOItem("stained_scrap_bars", () -> new IronBarsBlock(DDProperties.BlockP.STAINED_SCRAP_BARS));
    public static final RegistryObject<Block> LIVING_FIRE = DDBlocks.registerBlockWOItem("living_fire", () -> new LivingFireBlock(DDProperties.BlockP.LIVING_FIRE));
    public static final RegistryObject<Block> LIVING_CANDLE = DDBlocks.registerBlockWOItem("living_candle", () -> new LivingCandleBlock(DDProperties.BlockP.LIVING_CANDLE));
    public static final RegistryObject<Block> LIVING_CAMPFIRE = DDBlocks.registerBlockWOItem("living_campfire", () -> new LivingCampfireBlock(DDProperties.BlockP.LIVING_CAMPFIRE));
    public static final RegistryObject<Block> LIVING_LANTERN = DDBlocks.registerBlockWOItem("living_lantern", () -> new LanternBlock(DDProperties.BlockP.LIVING_LANTERN));
    public static final RegistryObject<Block> LIVING_TORCH = DDBlocks.registerBlockWOItem("living_torch", () -> new LivingTorchBlock(DDProperties.BlockP.LIVING_TORCH));
    public static final RegistryObject<Block> WALL_LIVING_TORCH = DDBlocks.registerBlockWOItem("wall_living_torch", () -> new WallLivingTorchBlock(DDProperties.BlockP.LIVING_TORCH));
    public static final RegistryObject<Block> STAINED_SCRAP_CHAIN = DDBlocks.registerBlockWOItem("stained_scrap_chain", () -> new ChainBlock(DDProperties.BlockP.STAINED_SCRAP_CHAIN));
    public static final RegistryObject<Block> STAINED_SCRAP_GRATE = DDBlocks.registerBlockWOItem("stained_scrap_grate", () -> new StainedScrapGrateBlock(DDProperties.BlockP.SPAWNER_GRATE));
    public static final RegistryObject<Block> ROTBULB_CROP = DDBlocks.registerBlockWOItem("rotbulb_crop", () -> new RotbulbCropBlock(DDProperties.BlockP.ROTBULB));
    public static final RegistryObject<Block> ROTBULB_PLANT = DDBlocks.registerBlockWOItem("rotbulb_plant", () -> new RotbulbPlantBlock(DDProperties.BlockP.ROTBULB));
    public static final RegistryObject<Block> ROTTEN_CROP = DDBlocks.registerBlockWOItem("rotten_crop", () -> new RottenCropBlock(DDProperties.BlockP.ROTTEN_CROP));
    public static final RegistryObject<Block> ROTTEN_POTATOES = DDBlocks.registerBlockWOItem("rotten_potatoes", () -> new RottenPotatoCropBlock(DDProperties.BlockP.ROTTEN_CROP));
    public static final RegistryObject<Block> ROTTEN_TOMATOES = DDBlocks.registerBlockWOItem("rotten_tomatoes", () -> new RottenTomatoesBlock(DDProperties.BlockP.ROTTEN_CROP));
    public static final RegistryObject<Block> DUNGEON_STOVE = DDBlocks.registerBlockWOItem("dungeon_stove", () -> new DungeonStoveBlock(DDProperties.BlockP.DUNGEON_STOVE));
    public static final RegistryObject<Block> MONSTER_POT = DDBlocks.registerBlockWOItem("monster_pot", () -> new MonsterPotBlock(DDProperties.BlockP.MONSTER_POT));
    public static final RegistryObject<Block> EMBEDDED_EGGS = DDBlocks.registerBlock("embedded_eggs", () -> new EmbeddedEggsBlock(DDProperties.BlockP.SCULK_EGGS));
    public static final RegistryObject<Block> HEAP_OF_ANCIENT_EGGS = DDBlocks.registerBlock("heap_of_ancient_eggs", () -> new Block(DDProperties.BlockP.SCULK_EGGS));
    public static final RegistryObject<Block> SPIDER_PIE = DDBlocks.registerBlockWOItem("spider_pie", () -> new PieBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_), DDItems.SPIDER_PIE_SLICE));
    public static final RegistryObject<Block> SCULK_TART = DDBlocks.registerBlock("sculk_tart", () -> new ExperiencePieBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_).m_60918_(SoundType.f_222473_), 15, (Supplier<Item>)DDItems.SCULK_TART_SLICE));
    public static final RegistryObject<Block> MONSTER_CAKE = DDBlocks.registerBlockWOItem("monster_cake", () -> new MonsterCakeBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_)));
    public static final RegistryObject<Block> CANDLE_MONSTER_CAKE = DDBlocks.registerBlockWOItem("candle_monster_cake", () -> new CandleMonsterCakeBlock((Block)LIVING_CANDLE.get(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152525_)));
    public static final RegistryObject<Block> SPIDER_DONUT = DDBlocks.registerBlockWOItem("spider_donut", () -> new SpiderDonutBlock(DDProperties.BlockP.SPIDER_DONUT));
    public static final RegistryObject<Block> GLOW_BERRY_GELATIN_BLOCK = DDBlocks.registerFeastBlock("glow_berry_gelatin_block", () -> new GlowBerryGelatinBlock(DDProperties.BlockP.GLOW_BERRY_GELATIN_BLOCK, (Supplier<Item>)DDItems.GLOW_BERRY_GELATIN, true));
    public static final RegistryObject<Block> OSSOBUCO_BLOCK = DDBlocks.registerBlockWOItem("ossobuco_block", () -> new OssobucoBlock(DDProperties.BlockP.OSSOBUCO_BLOCK, (Supplier<Item>)DDItems.OSSOBUCO, true));
    public static final RegistryObject<Block> GUARDIAN_ANGEL_BLOCK = DDBlocks.registerBlockWOItem("guardian_angel_block", () -> new GuardianAngelBlock(DDProperties.BlockP.GUARDIAN_ANGEL_BLOCK, (Supplier<Item>)DDItems.GUARDIAN_ANGEL, true));
    public static final RegistryObject<Block> SILVERFISH_AND_CHIPS_BLOCK = DDBlocks.registerBlockWOItem("silverfish_and_chips_block", () -> new SilverfishAndChipsBlock(DDProperties.BlockP.SILVERFISH_AND_CHIPS_BLOCK, (Supplier<Item>)DDItems.SILVERFISH_AND_CHIPS, true));
    public static final RegistryObject<Block> WORMROOT_TENDRILS = DDBlocks.registerBlock("wormroot_tendrils", () -> new WormrootTendrilsBlock(DDProperties.BlockP.WORMROOT_TENDRILS));
    public static final RegistryObject<Block> WORMROOT_STALK = DDBlocks.registerBlock("wormroot_stalk", () -> new WormrootsStalkBlock(DDProperties.BlockP.WORMWOOD));
    public static final RegistryObject<Block> WORMOUTH = DDBlocks.registerBlock("wormouth", () -> new WormouthBlock(DDProperties.BlockP.WORMOUTH));
    public static final RegistryObject<Block> WORMROOTS_BLOCK = DDBlocks.registerBlock("wormroots_block", () -> new Block(DDProperties.BlockP.WORMWOOD));
    public static final RegistryObject<Block> WORMWOOD_PLANKS = DDBlocks.registerBlock("wormwood_planks", () -> new Block(DDProperties.BlockP.WORMWOOD));
    public static final RegistryObject<Block> WORMWOOD_STAIRS = DDBlocks.registerBlock("wormwood_stairs", () -> new PublicStairBlock(((Block)WORMWOOD_PLANKS.get()).m_49966_(), DDProperties.BlockP.WORMWOOD));
    public static final RegistryObject<Block> WORMWOOD_SLAB = DDBlocks.registerBlock("wormwood_slab", () -> new SlabBlock(DDProperties.BlockP.WORMWOOD));
    public static final RegistryObject<Block> WORMWOOD_MOSAIC = DDBlocks.registerBlock("wormwood_mosaic", () -> new Block(DDProperties.BlockP.WORMWOOD));
    public static final RegistryObject<Block> WORMWOOD_MOSAIC_STAIRS = DDBlocks.registerBlock("wormwood_mosaic_stairs", () -> new PublicStairBlock(((Block)WORMWOOD_MOSAIC.get()).m_49966_(), DDProperties.BlockP.WORMWOOD));
    public static final RegistryObject<Block> WORMWOOD_MOSAIC_SLAB = DDBlocks.registerBlock("wormwood_mosaic_slab", () -> new SlabBlock(DDProperties.BlockP.WORMWOOD));
    public static final RegistryObject<Block> WORMWOOD_FENCE = DDBlocks.registerBlock("wormwood_fence", () -> new FenceBlock(DDProperties.BlockP.WORMWOOD));
    public static final RegistryObject<Block> WORMWOOD_FENCE_GATE = DDBlocks.registerBlock("wormwood_fence_gate", () -> new FenceGateBlock(DDProperties.BlockP.WORMWOOD, DDBlockSetTypes.WORMWOOD));
    public static final RegistryObject<Block> WORMWOOD_DOOR = DDBlocks.registerBlock("wormwood_door", () -> new DoorBlock(DDProperties.BlockP.WORMWOOD_DOOR, DDBlockSetTypes.WORMWOOD_BLOCKSET));
    public static final RegistryObject<Block> WORMWOOD_TRAPDOOR = DDBlocks.registerBlock("wormwood_trapdoor", () -> new TrapDoorBlock(DDProperties.BlockP.WORMWOOD_TRAPDOOR, DDBlockSetTypes.WORMWOOD_BLOCKSET));
    public static final RegistryObject<Block> WORMWOOD_BUTTON = DDBlocks.registerBlock("wormwood_button", () -> new WormwoodButtonBlock(DDProperties.BlockP.WORMWOOD_BUTTON, DDBlockSetTypes.WORMWOOD_BLOCKSET));
    public static final RegistryObject<Block> WORMWOOD_PRESSURE_PLATE = DDBlocks.registerBlock("wormwood_pressure_plate", () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, DDProperties.BlockP.WORMWOOD_PRESSURE_PLATE, DDBlockSetTypes.WORMWOOD_BLOCKSET));
    public static final RegistryObject<Block> WORMWOOD_CABINET = DDBlocks.registerBlock("wormwood_cabinet", () -> new CabinetBlock(DDProperties.BlockP.WORMWOOD_CABINET));

    private static <T extends Block> RegistryObject<T> registerBlock(String id, Supplier<T> block) {
        RegistryObject blockRegister = BLOCKS.register(id, block);
        DDBlocks.registerBlockItem(id, blockRegister);
        return blockRegister;
    }

    private static <T extends Block> RegistryObject<T> registerBlockWOItem(String id, Supplier<T> block) {
        return BLOCKS.register(id, block);
    }

    private static <T extends Block> void registerBlockItem(String id, RegistryObject<T> block) {
        DDItems.ITEMS.register(id, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    private static <T extends Block> RegistryObject<T> registerFeastBlock(String id, Supplier<T> block) {
        RegistryObject blockRegister = BLOCKS.register(id, block);
        DDBlocks.registerFeastBlockItem(id, blockRegister);
        return blockRegister;
    }

    private static <T extends Block> void registerFeastBlockItem(String id, RegistryObject<T> block) {
        DDItems.ITEMS.register(id, () -> new BlockItem((Block)block.get(), new Item.Properties().m_41487_(1)));
    }
}

