/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.PitcherCropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.IPlantable;
import net.yirmiri.dungeonsdelight.common.entity.monster_yam.MonsterYamEntity;
import net.yirmiri.dungeonsdelight.core.init.DDTags;
import net.yirmiri.dungeonsdelight.core.registry.DDBlocks;
import net.yirmiri.dungeonsdelight.core.registry.DDEntities;
import net.yirmiri.dungeonsdelight.core.registry.DDSounds;

public class RotbulbCropBlock
extends PitcherCropBlock
implements BonemealableBlock {
    public RotbulbCropBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    private boolean m_276876_(BlockState state) {
        return (Integer)state.m_61143_((Property)f_276478_) >= 4;
    }

    public boolean m_6266_(BlockState state, BlockGetter getter, BlockPos pos) {
        return state.m_204336_(DDTags.BlockT.ROTBULB_GROWABLE_ON);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        LivingEntity living;
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_6336_().equals(MobType.f_21641_)) {
            living.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 300, 0));
            living.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 300, 0));
        }
        super.m_7892_(state, level, pos, entity);
    }

    public boolean m_7898_(BlockState state, LevelReader reader, BlockPos pos) {
        if (!RotbulbCropBlock.m_278754_(state)) {
            return super.m_7898_(state, reader, pos);
        }
        BlockPos below = pos.m_7495_();
        boolean isSoil = this.m_6266_(reader.m_8055_(below), (BlockGetter)reader, below);
        if (state.m_60734_() == this) {
            isSoil = reader.m_8055_(below).canSustainPlant((BlockGetter)reader, below, Direction.UP, (IPlantable)this);
        }
        return isSoil && ((Integer)state.m_61143_((Property)f_276478_) < 3 || RotbulbCropBlock.m_290001_(reader.m_8055_(pos.m_7494_())));
    }

    private void spawnMonsterYam(ServerLevel level, BlockPos pos) {
        MonsterYamEntity monsterYam = (MonsterYamEntity)((EntityType)DDEntities.MONSTER_YAM.get()).m_20615_((Level)level);
        if (monsterYam != null) {
            monsterYam.m_7678_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), 0.0f, 0.0f);
            level.m_7967_((Entity)monsterYam);
            monsterYam.m_21373_();
            level.m_245803_((Entity)monsterYam, pos, (SoundEvent)DDSounds.MONSTER_YAM_AMBIENT.get(), SoundSource.HOSTILE, 2.0f, -1.0f);
        }
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity entity, ItemStack stack) {
        super.m_6240_(level, player, pos, state, entity, stack);
        if (!level.f_46443_ && this.m_276876_(state) && level.m_46469_().m_46207_(GameRules.f_46136_)) {
            this.spawnMonsterYam((ServerLevel)level, pos);
        }
    }

    private static boolean m_277165_(LevelReader reader, BlockPos pos) {
        BlockState blockstate = reader.m_8055_(pos);
        return blockstate.m_60795_() || blockstate.m_60713_((Block)DDBlocks.ROTBULB_CROP.get());
    }

    private static boolean m_290004_(LevelReader reader, BlockPos pos) {
        return reader.m_45524_(pos, 0) <= 8 || !reader.m_45527_(pos);
    }

    private static boolean m_278754_(BlockState state) {
        return state.m_60713_((Block)DDBlocks.ROTBULB_CROP.get()) && state.m_61143_((Property)f_52858_) == DoubleBlockHalf.LOWER;
    }

    private static boolean m_290001_(BlockState state) {
        return state.m_60713_((Block)DDBlocks.ROTBULB_CROP.get()) && state.m_61143_((Property)f_52858_) == DoubleBlockHalf.UPPER;
    }

    private boolean m_289996_(LevelReader reader, BlockPos pos, BlockState state, int i) {
        return !this.m_276876_(state) && RotbulbCropBlock.m_290004_(reader, pos) && (i < 3 || RotbulbCropBlock.m_277165_(reader, pos.m_7494_()));
    }

    @Nullable
    private PosAndState getLowerHalf(LevelReader reader, BlockPos pos, BlockState state) {
        if (RotbulbCropBlock.m_278754_(state)) {
            return new PosAndState(pos, state);
        }
        BlockPos blockpos = pos.m_7495_();
        BlockState blockstate = reader.m_8055_(blockpos);
        return RotbulbCropBlock.m_278754_(blockstate) ? new PosAndState(blockpos, blockstate) : null;
    }

    public boolean m_7370_(LevelReader reader, BlockPos pos, BlockState state, boolean b) {
        PosAndState cropStatePos = this.getLowerHalf(reader, pos, state);
        return cropStatePos != null && this.m_289996_(reader, cropStatePos.pos, cropStatePos.state, (Integer)cropStatePos.state.m_61143_((Property)f_276478_) + 1);
    }

    public boolean m_214167_(Level level, RandomSource source, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource source, BlockPos pos, BlockState state) {
        PosAndState cropStatePos = this.getLowerHalf((LevelReader)level, pos, state);
        if (cropStatePos != null) {
            this.m_276898_(level, cropStatePos.state, cropStatePos.pos, 1);
        }
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource source) {
        boolean flag;
        float f = RotbulbCropBlock.getGrowthSpeed((Block)this, (BlockGetter)level, pos);
        boolean bl = flag = source.m_188503_((int)(25.0f / f) + 1) == 0;
        if (flag) {
            this.m_276898_(level, state, pos, 1);
        }
    }

    private void m_276898_(ServerLevel level, BlockState state, BlockPos pos, int i1) {
        int i = Math.min((Integer)state.m_61143_((Property)f_276478_) + i1, 4);
        if (this.m_289996_((LevelReader)level, pos, state, i)) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)f_276478_, (Comparable)Integer.valueOf(i)), 2);
            if (i >= 3) {
                BlockPos blockpos = pos.m_7494_();
                level.m_7731_(blockpos, RotbulbCropBlock.m_182453_((LevelReader)level, (BlockPos)pos, (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_276478_, (Comparable)Integer.valueOf(i))).m_61124_((Property)f_52858_, (Comparable)DoubleBlockHalf.UPPER))), 3);
            }
        }
    }

    protected static float getGrowthSpeed(Block block, BlockGetter getter, BlockPos pos) {
        boolean flag1;
        float f = 1.0f;
        BlockPos blockpos = pos.m_7495_();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float f1 = 0.0f;
                BlockState blockstate = getter.m_8055_(blockpos.m_7918_(i, 0, j));
                if (blockstate.canSustainPlant(getter, blockpos.m_7918_(i, 0, j), Direction.UP, (IPlantable)block)) {
                    f1 = 1.0f;
                    if (blockstate.isFertile(getter, pos.m_7918_(i, 0, j))) {
                        f1 = 3.0f;
                    }
                }
                if (i != 0 || j != 0) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        BlockPos blockpos1 = pos.m_122012_();
        BlockPos blockpos2 = pos.m_122019_();
        BlockPos blockpos3 = pos.m_122024_();
        BlockPos blockpos4 = pos.m_122029_();
        boolean flag = getter.m_8055_(blockpos3).m_60713_(block) || getter.m_8055_(blockpos4).m_60713_(block);
        boolean bl = flag1 = getter.m_8055_(blockpos1).m_60713_(block) || getter.m_8055_(blockpos2).m_60713_(block);
        if (flag && flag1) {
            f /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = getter.m_8055_(blockpos3.m_122012_()).m_60713_(block) || getter.m_8055_(blockpos4.m_122012_()).m_60713_(block) || getter.m_8055_(blockpos4.m_122019_()).m_60713_(block) || getter.m_8055_(blockpos3.m_122019_()).m_60713_(block);
            if (flag2) {
                f /= 2.0f;
            }
        }
        return f;
    }

    record PosAndState(BlockPos pos, BlockState state) {
    }
}

