/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.gui.versions;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableColor;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.concurrent.Callable;
import net.minecraft.CrashReportCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class MCVer {
    private static final ArrayDeque<ScissorBounds> scissorStateStack = new ArrayDeque();
    private static ScissorBounds scissorState = ScissorBounds.DISABLED;

    public static Minecraft getMinecraft() {
        return Minecraft.m_91087_();
    }

    public static void pushScissorState() {
        scissorStateStack.push(scissorState);
    }

    public static void popScissorState() {
        MCVer.setScissorBounds(scissorStateStack.pop());
    }

    public static void setScissorBounds(int x, int y, int width, int height) {
        MCVer.setScissorBounds(new ScissorBounds(x, y, width, height));
    }

    public static void setScissorDisabled() {
        MCVer.setScissorBounds(ScissorBounds.DISABLED);
    }

    private static void setScissorBounds(ScissorBounds newState) {
        boolean wasEnabled;
        ScissorBounds oldState = scissorState;
        if (Objects.equals(oldState, newState)) {
            return;
        }
        scissorState = newState;
        boolean isEnabled = newState != ScissorBounds.DISABLED;
        boolean bl = wasEnabled = oldState != ScissorBounds.DISABLED;
        if (isEnabled) {
            if (!wasEnabled) {
                GL11.glEnable((int)3089);
            }
            GL11.glScissor((int)MCVer.scissorState.x, (int)MCVer.scissorState.y, (int)MCVer.scissorState.width, (int)MCVer.scissorState.height);
        } else {
            GL11.glDisable((int)3089);
        }
    }

    public static Window newScaledResolution(Minecraft mc) {
        return mc.m_91268_();
    }

    public static void addDetail(CrashReportCategory category, String name, Callable<String> callable) {
        category.m_128165_(name, callable::call);
    }

    public static void drawRect(int right, int bottom, int left, int top) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder vertexBuffer = tessellator.m_85915_();
        vertexBuffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        vertexBuffer.m_5483_((double)right, (double)top, 0.0).m_5752_();
        vertexBuffer.m_5483_((double)left, (double)top, 0.0).m_5752_();
        vertexBuffer.m_5483_((double)left, (double)bottom, 0.0).m_5752_();
        vertexBuffer.m_5483_((double)right, (double)bottom, 0.0).m_5752_();
        tessellator.m_85914_();
    }

    public static void drawRect(int x, int y, int width, int height, ReadableColor tl, ReadableColor tr, ReadableColor bl, ReadableColor br) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder vertexBuffer = tessellator.m_85915_();
        vertexBuffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        vertexBuffer.m_5483_((double)x, (double)(y + height), 0.0).m_6122_(bl.getRed(), bl.getGreen(), bl.getBlue(), bl.getAlpha()).m_5752_();
        vertexBuffer.m_5483_((double)(x + width), (double)(y + height), 0.0).m_6122_(br.getRed(), br.getGreen(), br.getBlue(), br.getAlpha()).m_5752_();
        vertexBuffer.m_5483_((double)(x + width), (double)y, 0.0).m_6122_(tr.getRed(), tr.getGreen(), tr.getBlue(), tr.getAlpha()).m_5752_();
        vertexBuffer.m_5483_((double)x, (double)y, 0.0).m_6122_(tl.getRed(), tl.getGreen(), tl.getBlue(), tl.getAlpha()).m_5752_();
        tessellator.m_85914_();
    }

    public static void bindTexture(ResourceLocation identifier) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)identifier);
    }

    public static Font getFontRenderer() {
        return MCVer.getMinecraft().f_91062_;
    }

    public static void setClipboardString(String text) {
        MCVer.getMinecraft().f_91068_.m_90911_(text);
    }

    public static String getClipboardString() {
        return MCVer.getMinecraft().f_91068_.m_90876_();
    }

    public static Component literalText(String str) {
        return Component.m_237113_((String)str);
    }

    private static class ScissorBounds {
        private static final ScissorBounds DISABLED = new ScissorBounds(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
        private final int x;
        private final int y;
        private final int width;
        private final int height;

        private ScissorBounds(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ScissorBounds that = (ScissorBounds)o;
            return this.x == that.x && this.y == that.y && this.width == that.width && this.height == that.height;
        }

        public int hashCode() {
            return Objects.hash(this.x, this.y, this.width, this.height);
        }
    }

    public static abstract class Keyboard {
        public static final int KEY_ESCAPE = 256;
        public static final int KEY_HOME = 268;
        public static final int KEY_END = 269;
        public static final int KEY_UP = 265;
        public static final int KEY_DOWN = 264;
        public static final int KEY_LEFT = 263;
        public static final int KEY_RIGHT = 262;
        public static final int KEY_BACK = 259;
        public static final int KEY_DELETE = 261;
        public static final int KEY_RETURN = 257;
        public static final int KEY_TAB = 258;
        public static final int KEY_A = 65;
        public static final int KEY_C = 67;
        public static final int KEY_V = 86;
        public static final int KEY_X = 88;

        public static void enableRepeatEvents(boolean enabled) {
        }
    }
}

