/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.gui.element.advanced;

import de.johni0702.minecraft.gui.GuiRenderer;
import de.johni0702.minecraft.gui.RenderInfo;
import de.johni0702.minecraft.gui.container.GuiContainer;
import de.johni0702.minecraft.gui.element.AbstractGuiElement;
import de.johni0702.minecraft.gui.element.advanced.AbstractGuiTimeline;
import de.johni0702.minecraft.gui.element.advanced.IGuiTimelineTime;
import de.johni0702.minecraft.gui.utils.Colors;
import de.johni0702.minecraft.gui.utils.lwjgl.Dimension;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableDimension;
import de.johni0702.minecraft.gui.versions.MCVer;

public abstract class AbstractGuiTimelineTime<T extends AbstractGuiTimelineTime<T, U>, U extends AbstractGuiTimeline<U>>
extends AbstractGuiElement<T>
implements IGuiTimelineTime<T, U> {
    private U timeline;

    public AbstractGuiTimelineTime() {
    }

    public AbstractGuiTimelineTime(GuiContainer container) {
        super(container);
    }

    @Override
    public void draw(GuiRenderer renderer, ReadableDimension size, RenderInfo renderInfo) {
        super.draw(renderer, size, renderInfo);
        if (this.timeline == null || ((AbstractGuiTimeline)this.timeline).getLastSize() == null) {
            return;
        }
        int offset = (size.getWidth() - ((AbstractGuiTimeline)this.timeline).getLastSize().getWidth()) / 2;
        int visibleLength = (int)((double)((AbstractGuiTimeline)this.timeline).getLength() * ((AbstractGuiTimeline)this.timeline).getZoom());
        int markerInterval = ((AbstractGuiTimeline)this.timeline).getMarkerInterval();
        for (int time = ((AbstractGuiTimeline)this.timeline).getOffset() / markerInterval * markerInterval; time <= ((AbstractGuiTimeline)this.timeline).getOffset() + visibleLength; time += markerInterval) {
            if (time < ((AbstractGuiTimeline)this.timeline).getOffset()) continue;
            this.drawTime(renderer, size, time, offset);
        }
    }

    protected void drawTime(GuiRenderer renderer, ReadableDimension size, int time, int offset) {
        int visibleLength = (int)((double)((AbstractGuiTimeline)this.timeline).getLength() * ((AbstractGuiTimeline)this.timeline).getZoom());
        double positionInVisible = time - ((AbstractGuiTimeline)this.timeline).getOffset();
        double fractionOfVisible = positionInVisible / (double)visibleLength;
        int positionX = (int)(4.0 + fractionOfVisible * (double)(size.getWidth() - 4 - 4)) + offset;
        String str = ((AbstractGuiTimeline)this.timeline).getLength() > 3600000 ? String.format("%02d:%02d:%02d", time / 1000 / 60 / 60, time / 1000 / 60 % 60, time / 1000 % 60) : String.format("%02d:%02d", time / 1000 / 60, time / 1000 % 60);
        int stringWidth = MCVer.getFontRenderer().m_92895_(str);
        positionX = Math.max(stringWidth / 2, Math.min(size.getWidth() - stringWidth / 2, positionX));
        renderer.drawCenteredString(positionX, 0, Colors.WHITE, str, true);
    }

    @Override
    public ReadableDimension calcMinSize() {
        return new Dimension(0, 0);
    }

    @Override
    public T setTimeline(U timeline) {
        this.timeline = timeline;
        return (T)((AbstractGuiTimelineTime)this.getThis());
    }

    @Override
    public U getTimeline() {
        return this.timeline;
    }
}

