/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.gui.element;

import com.mojang.blaze3d.systems.RenderSystem;
import de.johni0702.minecraft.gui.GuiRenderer;
import de.johni0702.minecraft.gui.RenderInfo;
import de.johni0702.minecraft.gui.container.GuiContainer;
import de.johni0702.minecraft.gui.element.AbstractGuiButton;
import de.johni0702.minecraft.gui.element.AbstractGuiClickable;
import de.johni0702.minecraft.gui.element.IGuiTexturedButton;
import de.johni0702.minecraft.gui.function.Clickable;
import de.johni0702.minecraft.gui.utils.lwjgl.Dimension;
import de.johni0702.minecraft.gui.utils.lwjgl.Point;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableDimension;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadablePoint;
import de.johni0702.minecraft.gui.utils.lwjgl.WritableDimension;
import de.johni0702.minecraft.gui.utils.lwjgl.WritablePoint;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public abstract class AbstractGuiTexturedButton<T extends AbstractGuiTexturedButton<T>>
extends AbstractGuiClickable<T>
implements Clickable,
IGuiTexturedButton<T> {
    private ResourceLocation texture;
    private SoundEvent sound = (SoundEvent)SoundEvents.f_12490_.m_203334_();
    private ReadableDimension textureSize = new ReadableDimension(){

        public int getWidth() {
            return AbstractGuiTexturedButton.this.getMaxSize().getWidth();
        }

        public int getHeight() {
            return AbstractGuiTexturedButton.this.getMaxSize().getHeight();
        }

        public void getSize(WritableDimension dest) {
            AbstractGuiTexturedButton.this.getMaxSize().getSize(dest);
        }
    };
    private ReadableDimension textureTotalSize;
    private ReadablePoint textureNormal;
    private ReadablePoint textureHover;
    private ReadablePoint textureDisabled;

    public AbstractGuiTexturedButton() {
    }

    public AbstractGuiTexturedButton(GuiContainer container) {
        super(container);
    }

    @Override
    public void draw(GuiRenderer renderer, ReadableDimension size, RenderInfo renderInfo) {
        super.draw(renderer, size, renderInfo);
        renderer.bindTexture(this.texture);
        ReadablePoint texture = this.textureNormal;
        if (!this.isEnabled()) {
            texture = this.textureDisabled;
        } else if (this.isMouseHovering((ReadablePoint)new Point(renderInfo.mouseX, renderInfo.mouseY))) {
            texture = this.textureHover;
        }
        if (texture == null) {
            texture = this.textureNormal;
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.blendFunc((int)770, (int)771);
        renderer.drawTexturedRect(0, 0, texture.getX(), texture.getY(), size.getWidth(), size.getHeight(), this.textureSize.getWidth(), this.textureSize.getHeight(), this.textureTotalSize.getWidth(), this.textureTotalSize.getHeight());
    }

    @Override
    public ReadableDimension calcMinSize() {
        return new Dimension(0, 0);
    }

    @Override
    public void onClick() {
        AbstractGuiButton.playClickSound(this.getMinecraft(), this.sound);
        super.onClick();
    }

    @Override
    public T setTexture(ResourceLocation resourceLocation, int size) {
        return (T)this.setTexture(resourceLocation, size, size);
    }

    @Override
    public T setTexture(ResourceLocation resourceLocation, int width, int height) {
        this.texture = resourceLocation;
        this.textureTotalSize = new Dimension(width, height);
        return (T)((AbstractGuiTexturedButton)this.getThis());
    }

    @Override
    public T setTextureSize(int size) {
        return (T)this.setTextureSize(size, size);
    }

    @Override
    public T setTextureSize(int width, int height) {
        this.textureSize = new Dimension(width, height);
        return (T)((AbstractGuiTexturedButton)this.getThis());
    }

    @Override
    public T setTexturePosH(int x, int y) {
        return (T)this.setTexturePosH((ReadablePoint)new Point(x, y));
    }

    @Override
    public T setTexturePosV(int x, int y) {
        return (T)this.setTexturePosV((ReadablePoint)new Point(x, y));
    }

    @Override
    public T setTexturePosH(final ReadablePoint pos) {
        this.textureNormal = pos;
        this.textureHover = new ReadablePoint(){

            public int getX() {
                return pos.getX() + AbstractGuiTexturedButton.this.textureSize.getWidth();
            }

            public int getY() {
                return pos.getY();
            }

            public void getLocation(WritablePoint dest) {
                dest.setLocation(this.getX(), this.getY());
            }
        };
        return (T)((AbstractGuiTexturedButton)this.getThis());
    }

    @Override
    public T setTexturePosV(final ReadablePoint pos) {
        this.textureNormal = pos;
        this.textureHover = new ReadablePoint(){

            public int getX() {
                return pos.getX();
            }

            public int getY() {
                return pos.getY() + AbstractGuiTexturedButton.this.textureSize.getHeight();
            }

            public void getLocation(WritablePoint dest) {
                dest.setLocation(this.getX(), this.getY());
            }
        };
        return (T)((AbstractGuiTexturedButton)this.getThis());
    }

    @Override
    public T setTexturePos(int normalX, int normalY, int hoverX, int hoverY) {
        return (T)this.setTexturePos((ReadablePoint)new Point(normalX, normalY), (ReadablePoint)new Point(hoverX, hoverY));
    }

    @Override
    public T setTexturePos(ReadablePoint normal, ReadablePoint hover) {
        this.textureNormal = normal;
        this.textureHover = hover;
        return (T)((AbstractGuiTexturedButton)this.getThis());
    }

    @Override
    public T setTexturePos(int normalX, int normalY, int hoverX, int hoverY, int disabledX, int disabledY) {
        return (T)this.setTexturePos((ReadablePoint)new Point(normalX, normalY), (ReadablePoint)new Point(hoverX, hoverY), (ReadablePoint)new Point(disabledX, disabledY));
    }

    @Override
    public T setTexturePos(ReadablePoint normal, ReadablePoint hover, ReadablePoint disabled) {
        this.textureDisabled = disabled;
        return (T)this.setTexturePos(normal, hover);
    }

    @Override
    public T setSound(SoundEvent sound) {
        this.sound = sound;
        return (T)((AbstractGuiTexturedButton)this.getThis());
    }

    public SoundEvent getSound() {
        return this.sound;
    }

    @Override
    public ResourceLocation getTexture() {
        return this.texture;
    }

    @Override
    public ReadableDimension getTextureSize() {
        return this.textureSize;
    }

    @Override
    public ReadableDimension getTextureTotalSize() {
        return this.textureTotalSize;
    }

    @Override
    public ReadablePoint getTextureNormal() {
        return this.textureNormal;
    }

    @Override
    public ReadablePoint getTextureHover() {
        return this.textureHover;
    }

    @Override
    public ReadablePoint getTextureDisabled() {
        return this.textureDisabled;
    }
}

