/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.gui.element;

import de.johni0702.minecraft.gui.GuiRenderer;
import de.johni0702.minecraft.gui.RenderInfo;
import de.johni0702.minecraft.gui.container.GuiContainer;
import de.johni0702.minecraft.gui.element.AbstractGuiElement;
import de.johni0702.minecraft.gui.element.IGuiLabel;
import de.johni0702.minecraft.gui.utils.lwjgl.Dimension;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableColor;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadableDimension;
import de.johni0702.minecraft.gui.versions.MCVer;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.gui.Font;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;

public abstract class AbstractGuiLabel<T extends AbstractGuiLabel<T>>
extends AbstractGuiElement<T>
implements IGuiLabel<T> {
    private String text = "";
    private ReadableColor color = ReadableColor.WHITE;
    private ReadableColor disabledColor = ReadableColor.GREY;

    public AbstractGuiLabel() {
    }

    public AbstractGuiLabel(GuiContainer container) {
        super(container);
    }

    @Override
    public void draw(GuiRenderer renderer, ReadableDimension size, RenderInfo renderInfo) {
        super.draw(renderer, size, renderInfo);
        Font fontRenderer = MCVer.getFontRenderer();
        List lines = fontRenderer.m_92865_().m_92414_((FormattedText)MCVer.literalText(this.text), size.getWidth(), Style.f_131099_).stream().map(it -> it.m_5651_(Optional::of)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        int y = 0;
        for (String line : lines) {
            renderer.drawString(0, y, this.isEnabled() ? this.color : this.disabledColor, line);
            Objects.requireNonNull(fontRenderer);
            y += 9;
        }
    }

    @Override
    public ReadableDimension calcMinSize() {
        Font fontRenderer = MCVer.getFontRenderer();
        int n = fontRenderer.m_92895_(this.text);
        Objects.requireNonNull(fontRenderer);
        return new Dimension(n, 9);
    }

    @Override
    public ReadableDimension getMaxSize() {
        return this.getMinSize();
    }

    @Override
    public T setText(String text) {
        this.text = text;
        return (T)((AbstractGuiLabel)this.getThis());
    }

    @Override
    public T setI18nText(String text, Object ... args) {
        return (T)this.setText(I18n.m_118938_((String)text, (Object[])args));
    }

    @Override
    public T setColor(ReadableColor color) {
        this.color = color;
        return (T)((AbstractGuiLabel)this.getThis());
    }

    @Override
    public T setDisabledColor(ReadableColor disabledColor) {
        this.disabledColor = disabledColor;
        return (T)((AbstractGuiLabel)this.getThis());
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public ReadableColor getColor() {
        return this.color;
    }

    @Override
    public ReadableColor getDisabledColor() {
        return this.disabledColor;
    }
}

