/*
 * Decompiled with CFR 0.152.
 */
package com.replaymod.simplepathing.gui;

import com.replaymod.pathing.properties.CameraProperties;
import com.replaymod.pathing.properties.TimestampProperty;
import com.replaymod.replay.ReplayModReplay;
import com.replaymod.replaystudio.pathing.change.Change;
import com.replaymod.replaystudio.pathing.change.CombinedChange;
import com.replaymod.replaystudio.pathing.interpolation.CatmullRomSplineInterpolator;
import com.replaymod.replaystudio.pathing.interpolation.CubicSplineInterpolator;
import com.replaymod.replaystudio.pathing.interpolation.Interpolator;
import com.replaymod.replaystudio.pathing.interpolation.LinearInterpolator;
import com.replaymod.replaystudio.pathing.path.Keyframe;
import com.replaymod.replaystudio.pathing.path.Path;
import com.replaymod.replaystudio.pathing.path.PathSegment;
import com.replaymod.simplepathing.InterpolatorType;
import com.replaymod.simplepathing.SPTimeline;
import com.replaymod.simplepathing.Setting;
import com.replaymod.simplepathing.gui.GuiPathing;
import com.replaymod.simplepathing.properties.ExplicitInterpolationProperty;
import de.johni0702.minecraft.gui.container.AbstractGuiContainer;
import de.johni0702.minecraft.gui.container.GuiPanel;
import de.johni0702.minecraft.gui.element.GuiButton;
import de.johni0702.minecraft.gui.element.GuiElement;
import de.johni0702.minecraft.gui.element.GuiLabel;
import de.johni0702.minecraft.gui.element.GuiNumberField;
import de.johni0702.minecraft.gui.element.GuiTooltip;
import de.johni0702.minecraft.gui.element.IGuiLabel;
import de.johni0702.minecraft.gui.element.advanced.GuiDropdownMenu;
import de.johni0702.minecraft.gui.function.Typeable;
import de.johni0702.minecraft.gui.layout.GridLayout;
import de.johni0702.minecraft.gui.layout.HorizontalLayout;
import de.johni0702.minecraft.gui.layout.VerticalLayout;
import de.johni0702.minecraft.gui.popup.AbstractGuiPopup;
import de.johni0702.minecraft.gui.utils.Colors;
import de.johni0702.minecraft.gui.utils.Consumer;
import de.johni0702.minecraft.gui.utils.Utils;
import de.johni0702.minecraft.gui.utils.lwjgl.ReadablePoint;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.resources.language.I18n;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class GuiEditKeyframe<T extends GuiEditKeyframe<T>>
extends AbstractGuiPopup<T>
implements Typeable {
    protected static final Logger logger = LogManager.getLogger();
    protected final GuiPathing guiPathing;
    protected final long time;
    protected final Keyframe keyframe;
    protected final Path path;
    public final GuiLabel title = new GuiLabel();
    public final GuiPanel inputs = new GuiPanel();
    public final GuiNumberField timeMinField = (GuiNumberField)((GuiNumberField)GuiEditKeyframe.newGuiNumberField().setSize(30, 20)).setMinValue(0);
    public final GuiNumberField timeSecField = (GuiNumberField)((GuiNumberField)((GuiNumberField)GuiEditKeyframe.newGuiNumberField().setSize(20, 20)).setMinValue(0)).setMaxValue(59);
    public final GuiNumberField timeMSecField = (GuiNumberField)((GuiNumberField)((GuiNumberField)GuiEditKeyframe.newGuiNumberField().setSize(30, 20)).setMinValue(0)).setMaxValue(999);
    public final GuiPanel timePanel = (GuiPanel)((GuiPanel)new GuiPanel().setLayout(new HorizontalLayout(HorizontalLayout.Alignment.RIGHT).setSpacing(3))).addElements(new HorizontalLayout.Data(0.5), new GuiElement[]{new GuiLabel().setI18nText("replaymod.gui.editkeyframe.timelineposition", new Object[0]), this.timeMinField, new GuiLabel().setI18nText("replaymod.gui.minutes", new Object[0]), this.timeSecField, new GuiLabel().setI18nText("replaymod.gui.seconds", new Object[0]), this.timeMSecField, new GuiLabel().setI18nText("replaymod.gui.milliseconds", new Object[0])});
    public final GuiButton saveButton = (GuiButton)((GuiButton)new GuiButton().setSize(150, 20)).setI18nLabel("replaymod.gui.save", new Object[0]);
    public final GuiButton cancelButton = (GuiButton)((GuiButton)((GuiButton)new GuiButton().onClick(() -> this.close())).setSize(150, 20)).setI18nLabel("replaymod.gui.cancel", new Object[0]);
    public final GuiPanel buttons = (GuiPanel)((GuiPanel)new GuiPanel().setLayout(new HorizontalLayout(HorizontalLayout.Alignment.CENTER).setSpacing(7))).addElements(new HorizontalLayout.Data(0.5), new GuiElement[]{this.saveButton, this.cancelButton});

    private static GuiNumberField newGuiNumberField() {
        return (GuiNumberField)((GuiNumberField)new GuiNumberField().setPrecision(0)).setValidateOnFocusChange(true);
    }

    public GuiEditKeyframe(GuiPathing gui, SPTimeline.SPPath path, long time, String type) {
        super(ReplayModReplay.instance.getReplayHandler().getOverlay());
        this.setBackgroundColor(Colors.DARK_TRANSPARENT);
        ((GuiPanel)this.popup.setLayout(new VerticalLayout().setSpacing(10))).addElements(new VerticalLayout.Data(0.5, false), new GuiElement[]{this.title, this.inputs, this.timePanel, this.buttons});
        this.guiPathing = gui;
        this.time = time;
        this.path = gui.getMod().getCurrentTimeline().getPath(path);
        this.keyframe = this.path.getKeyframe(time);
        Consumer<String> updateSaveButtonState = s -> this.saveButton.setEnabled(this.canSave());
        ((GuiNumberField)this.timeMinField.setValue(time / 1000L / 60L)).onTextChanged((Consumer)updateSaveButtonState);
        ((GuiNumberField)this.timeSecField.setValue(time / 1000L % 60L)).onTextChanged((Consumer)updateSaveButtonState);
        ((GuiNumberField)this.timeMSecField.setValue(time % 1000L)).onTextChanged((Consumer)updateSaveButtonState);
        this.title.setI18nText("replaymod.gui.editkeyframe.title." + type, new Object[0]);
        this.saveButton.onClick(() -> {
            Change change = this.save();
            long newTime = (this.timeMinField.getInteger() * 60 + this.timeSecField.getInteger()) * 1000 + this.timeMSecField.getInteger();
            if (newTime != time) {
                change = CombinedChange.createFromApplied(change, gui.getMod().getCurrentTimeline().moveKeyframe(path, time, newTime));
                if (gui.getMod().getSelectedPath() == path && gui.getMod().getSelectedTime() == time) {
                    gui.getMod().setSelected(path, newTime);
                }
            }
            gui.getMod().getCurrentTimeline().getTimeline().pushChange(change);
            this.close();
        });
    }

    private boolean canSave() {
        long newTime = (this.timeMinField.getInteger() * 60 + this.timeSecField.getInteger()) * 1000 + this.timeMSecField.getInteger();
        if (newTime < 0L || newTime > (long)this.guiPathing.timeline.getLength()) {
            return false;
        }
        return newTime == this.keyframe.getTime() || this.path.getKeyframe(newTime) == null;
    }

    @Override
    public boolean typeKey(ReadablePoint mousePosition, int keyCode, char keyChar, boolean ctrlDown, boolean shiftDown) {
        if (keyCode == 256) {
            this.cancelButton.onClick();
            return true;
        }
        return false;
    }

    @Override
    public void open() {
        super.open();
    }

    protected abstract Change save();

    public static class Position
    extends GuiEditKeyframe<Position> {
        public final GuiNumberField xField = (GuiNumberField)((GuiNumberField)GuiEditKeyframe.newGuiNumberField().setSize(60, 20)).setPrecision(5);
        public final GuiNumberField yField = (GuiNumberField)((GuiNumberField)GuiEditKeyframe.newGuiNumberField().setSize(60, 20)).setPrecision(5);
        public final GuiNumberField zField = (GuiNumberField)((GuiNumberField)GuiEditKeyframe.newGuiNumberField().setSize(60, 20)).setPrecision(5);
        public final GuiNumberField yawField = (GuiNumberField)((GuiNumberField)GuiEditKeyframe.newGuiNumberField().setSize(60, 20)).setPrecision(5);
        public final GuiNumberField pitchField = (GuiNumberField)((GuiNumberField)GuiEditKeyframe.newGuiNumberField().setSize(60, 20)).setPrecision(5);
        public final GuiNumberField rollField = (GuiNumberField)((GuiNumberField)GuiEditKeyframe.newGuiNumberField().setSize(60, 20)).setPrecision(5);
        public final InterpolationPanel interpolationPanel = new InterpolationPanel();

        public Position(GuiPathing gui, SPTimeline.SPPath path, long keyframe) {
            super(gui, path, keyframe, "pos");
            GuiPanel positionInputs = (GuiPanel)((GuiPanel)new GuiPanel().setLayout(new GridLayout().setCellsEqualSize(false).setColumns(4).setSpacingX(3).setSpacingY(5))).addElements(new GridLayout.Data(1.0, 0.5), new GuiElement[]{new GuiLabel().setI18nText("replaymod.gui.editkeyframe.xpos", new Object[0]), this.xField, new GuiLabel().setI18nText("replaymod.gui.editkeyframe.camyaw", new Object[0]), this.yawField, new GuiLabel().setI18nText("replaymod.gui.editkeyframe.ypos", new Object[0]), this.yField, new GuiLabel().setI18nText("replaymod.gui.editkeyframe.campitch", new Object[0]), this.pitchField, new GuiLabel().setI18nText("replaymod.gui.editkeyframe.zpos", new Object[0]), this.zField, new GuiLabel().setI18nText("replaymod.gui.editkeyframe.camroll", new Object[0]), this.rollField});
            ((GuiPanel)this.inputs.setLayout(new VerticalLayout().setSpacing(10))).addElements(new VerticalLayout.Data(0.5, false), new GuiElement[]{positionInputs, this.interpolationPanel});
            this.keyframe.getValue(CameraProperties.POSITION).ifPresent(pos -> {
                this.xField.setValue((Double)pos.getLeft());
                this.yField.setValue((Double)pos.getMiddle());
                this.zField.setValue((Double)pos.getRight());
            });
            this.keyframe.getValue(CameraProperties.ROTATION).ifPresent(rot -> {
                this.yawField.setValue(((Float)rot.getLeft()).floatValue());
                this.pitchField.setValue(((Float)rot.getMiddle()).floatValue());
                this.rollField.setValue(((Float)rot.getRight()).floatValue());
            });
            Utils.link(this.xField, this.yField, this.zField, this.yawField, this.pitchField, this.rollField, this.timeMinField, this.timeSecField, this.timeMSecField);
            this.popup.invokeAll(IGuiLabel.class, e -> e.setColor(Colors.BLACK));
        }

        @Override
        protected Change save() {
            SPTimeline timeline = this.guiPathing.getMod().getCurrentTimeline();
            Change positionChange = timeline.updatePositionKeyframe(this.time, this.xField.getDouble(), this.yField.getDouble(), this.zField.getDouble(), this.yawField.getFloat(), this.pitchField.getFloat(), this.rollField.getFloat());
            if (this.interpolationPanel.getSettingsPanel() == null) {
                return positionChange;
            }
            Object interpolator = this.interpolationPanel.getSettingsPanel().createInterpolator();
            if (this.interpolationPanel.getInterpolatorType() == InterpolatorType.DEFAULT) {
                return CombinedChange.createFromApplied(positionChange, timeline.setInterpolatorToDefault(this.time), timeline.setDefaultInterpolator((Interpolator)interpolator));
            }
            return CombinedChange.createFromApplied(positionChange, timeline.setInterpolator(this.time, (Interpolator)interpolator));
        }

        @Override
        protected Position getThis() {
            return this;
        }

        public class InterpolationPanel
        extends AbstractGuiContainer<InterpolationPanel> {
            private SettingsPanel settingsPanel;
            private GuiDropdownMenu<InterpolatorType> dropdown;

            public InterpolationPanel() {
                this.setLayout(new VerticalLayout());
                this.dropdown = (GuiDropdownMenu)((GuiDropdownMenu)((GuiDropdownMenu)((GuiDropdownMenu)new GuiDropdownMenu().setToString(s -> I18n.m_118938_((String)s.getI18nName(), (Object[])new Object[0]))).setValues((Object[])InterpolatorType.values())).setHeight(20)).onSelection(i -> this.setSettingsPanel((InterpolatorType)((Object)((Object)this.dropdown.getSelectedValue()))));
                for (Map.Entry e : this.dropdown.getDropdownEntries().entrySet()) {
                    e.getValue().setTooltip((GuiElement)new GuiTooltip().setI18nText(((InterpolatorType)((Object)e.getKey())).getI18nDescription(), new Object[0]));
                }
                GuiPanel dropdownPanel = (GuiPanel)((GuiPanel)new GuiPanel().setLayout(new GridLayout().setCellsEqualSize(false).setColumns(2).setSpacingX(3).setSpacingY(5))).addElements(new GridLayout.Data(1.0, 0.5), new GuiElement[]{new GuiLabel().setI18nText("replaymod.gui.editkeyframe.interpolator", new Object[0]), this.dropdown});
                this.addElements(new VerticalLayout.Data(0.5, false), new GuiElement[]{dropdownPanel});
                Optional<PathSegment> segment = Position.this.path.getSegments().stream().filter(s -> s.getStartKeyframe() == Position.this.keyframe).findFirst();
                if (segment.isPresent()) {
                    Interpolator interpolator = segment.get().getInterpolator();
                    InterpolatorType type = InterpolatorType.fromClass(interpolator.getClass());
                    if (Position.this.keyframe.getValue(ExplicitInterpolationProperty.PROPERTY).isPresent()) {
                        this.dropdown.setSelected((Object)type);
                    } else {
                        this.setSettingsPanel(InterpolatorType.DEFAULT);
                        type = InterpolatorType.DEFAULT;
                    }
                    if (this.getInterpolatorTypeNoDefault(type).getInterpolatorClass().isInstance(interpolator)) {
                        this.settingsPanel.loadSettings(interpolator);
                    }
                } else {
                    this.dropdown.setDisabled();
                }
            }

            public SettingsPanel getSettingsPanel() {
                return this.settingsPanel;
            }

            public void setSettingsPanel(InterpolatorType type) {
                this.removeElement(this.settingsPanel);
                switch (this.getInterpolatorTypeNoDefault(type)) {
                    case CATMULL_ROM: {
                        this.settingsPanel = new CatmullRomSettingsPanel();
                        break;
                    }
                    case CUBIC: {
                        this.settingsPanel = new CubicSettingsPanel();
                        break;
                    }
                    case LINEAR: {
                        this.settingsPanel = new LinearSettingsPanel();
                    }
                }
                this.addElements(new GridLayout.Data(0.5, 0.5), new GuiElement[]{this.settingsPanel});
            }

            protected InterpolatorType getInterpolatorTypeNoDefault(InterpolatorType interpolatorType) {
                if (interpolatorType == InterpolatorType.DEFAULT || interpolatorType == null) {
                    InterpolatorType defaultType = InterpolatorType.fromString(Position.this.guiPathing.getMod().getCore().getSettingsRegistry().get(Setting.DEFAULT_INTERPOLATION));
                    return defaultType;
                }
                return interpolatorType;
            }

            public InterpolatorType getInterpolatorType() {
                return (InterpolatorType)((Object)this.dropdown.getSelectedValue());
            }

            @Override
            protected InterpolationPanel getThis() {
                return this;
            }

            public abstract class SettingsPanel<I extends Interpolator, T extends SettingsPanel<I, T>>
            extends AbstractGuiContainer<T> {
                public abstract void loadSettings(I var1);

                public abstract I createInterpolator();
            }

            public class CatmullRomSettingsPanel
            extends SettingsPanel<CatmullRomSplineInterpolator, CatmullRomSettingsPanel> {
                public final GuiLabel alphaLabel = (GuiLabel)((GuiLabel)new GuiLabel().setColor(Colors.BLACK)).setI18nText("replaymod.gui.editkeyframe.interpolator.catmullrom.alpha", new Object[0]);
                public final GuiNumberField alphaField = (GuiNumberField)((GuiNumberField)((GuiNumberField)((GuiNumberField)new GuiNumberField().setSize(100, 20)).setPrecision(5)).setMinValue(0)).setValidateOnFocusChange(true);

                public CatmullRomSettingsPanel() {
                    this.setLayout(new HorizontalLayout(HorizontalLayout.Alignment.CENTER));
                    this.addElements(new HorizontalLayout.Data(0.5), new GuiElement[]{this.alphaLabel, this.alphaField});
                }

                @Override
                public void loadSettings(CatmullRomSplineInterpolator interpolator) {
                    this.alphaField.setValue(interpolator.getAlpha());
                }

                @Override
                public CatmullRomSplineInterpolator createInterpolator() {
                    return new CatmullRomSplineInterpolator(this.alphaField.getDouble());
                }

                @Override
                protected CatmullRomSettingsPanel getThis() {
                    return this;
                }
            }

            public class CubicSettingsPanel
            extends SettingsPanel<CubicSplineInterpolator, CubicSettingsPanel> {
                @Override
                public void loadSettings(CubicSplineInterpolator interpolator) {
                }

                @Override
                public CubicSplineInterpolator createInterpolator() {
                    return new CubicSplineInterpolator();
                }

                @Override
                protected CubicSettingsPanel getThis() {
                    return this;
                }
            }

            public class LinearSettingsPanel
            extends SettingsPanel<LinearInterpolator, LinearSettingsPanel> {
                @Override
                public void loadSettings(LinearInterpolator interpolator) {
                }

                @Override
                public LinearInterpolator createInterpolator() {
                    return new LinearInterpolator();
                }

                @Override
                protected LinearSettingsPanel getThis() {
                    return this;
                }
            }
        }
    }

    public static class Time
    extends GuiEditKeyframe<Time> {
        public final GuiNumberField timestampMinField = (GuiNumberField)((GuiNumberField)GuiEditKeyframe.newGuiNumberField().setSize(30, 20)).setMinValue(0);
        public final GuiNumberField timestampSecField = (GuiNumberField)((GuiNumberField)((GuiNumberField)GuiEditKeyframe.newGuiNumberField().setSize(20, 20)).setMinValue(0)).setMaxValue(59);
        public final GuiNumberField timestampMSecField = (GuiNumberField)((GuiNumberField)((GuiNumberField)GuiEditKeyframe.newGuiNumberField().setSize(30, 20)).setMinValue(0)).setMaxValue(999);

        public Time(GuiPathing gui, SPTimeline.SPPath path, long keyframe) {
            super(gui, path, keyframe, "time");
            ((GuiPanel)this.inputs.setLayout(new HorizontalLayout(HorizontalLayout.Alignment.RIGHT).setSpacing(3))).addElements(new HorizontalLayout.Data(0.5), new GuiElement[]{new GuiLabel().setI18nText("replaymod.gui.editkeyframe.timestamp", new Object[0]), this.timestampMinField, new GuiLabel().setI18nText("replaymod.gui.minutes", new Object[0]), this.timestampSecField, new GuiLabel().setI18nText("replaymod.gui.seconds", new Object[0]), this.timestampMSecField, new GuiLabel().setI18nText("replaymod.gui.milliseconds", new Object[0])});
            this.keyframe.getValue(TimestampProperty.PROPERTY).ifPresent(time -> {
                this.timestampMinField.setValue(time / 1000 / 60);
                this.timestampSecField.setValue(time / 1000 % 60);
                this.timestampMSecField.setValue(time % 1000);
            });
            Utils.link(this.timestampMinField, this.timestampSecField, this.timestampMSecField, this.timeMinField, this.timeSecField, this.timeMSecField);
            this.popup.invokeAll(IGuiLabel.class, e -> e.setColor(Colors.BLACK));
        }

        @Override
        protected Change save() {
            int time = (this.timestampMinField.getInteger() * 60 + this.timestampSecField.getInteger()) * 1000 + this.timestampMSecField.getInteger();
            return this.guiPathing.getMod().getCurrentTimeline().updateTimeKeyframe(this.keyframe.getTime(), time);
        }

        @Override
        protected Time getThis() {
            return this;
        }
    }

    public static class Spectator
    extends GuiEditKeyframe<Spectator> {
        public Spectator(GuiPathing gui, SPTimeline.SPPath path, long keyframe) {
            super(gui, path, keyframe, "spec");
            Utils.link(this.timeMinField, this.timeSecField, this.timeMSecField);
            this.popup.invokeAll(IGuiLabel.class, e -> e.setColor(Colors.BLACK));
        }

        @Override
        protected Change save() {
            return CombinedChange.createFromApplied(new Change[0]);
        }

        @Override
        protected Spectator getThis() {
            return this;
        }
    }
}

